/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.temperature;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import sfiomn.legendarysurvivaloverhaul.api.temperature.ModifierBase;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.TemperatureModifierRegistry;
import sfiomn.legendarysurvivaloverhaul.util.WorldUtil;

public class WeatherModifier
extends ModifierBase {
    @Override
    public float getWorldInfluence(Player player, Level level, BlockPos pos) {
        Biome.Precipitation precipitation = Biome.Precipitation.NONE;
        boolean isUndercover = WorldUtil.isPlayerOrPosUndercover(level, player, pos.m_7494_());
        if (!isUndercover) {
            precipitation = WorldUtil.getPrecipitationAt(level, player, pos.m_7494_());
        }
        if (precipitation == Biome.Precipitation.NONE && !isUndercover) {
            return 0.0f;
        }
        float weatherTemperature = 0.0f;
        long time = level.m_6106_().m_6792_();
        if (Config.Baked.shadeTimeModifier != 0.0 && time <= 12000L && (double)(((ModifierBase)TemperatureModifierRegistry.BIOME.get()).getWorldInfluence(player, level, pos) + ((ModifierBase)TemperatureModifierRegistry.SERENE_SEASONS.get()).getWorldInfluence(player, level, pos) + ((ModifierBase)TemperatureModifierRegistry.ECLIPTIC_SEASONS.get()).getWorldInfluence(player, level, pos)) >= Config.Baked.shadeTimeModifierThreshold) {
            float shadeTemperature = (float)Config.Baked.shadeTimeModifier * (float)Math.sin((double)time * 2.6179938E-4);
            weatherTemperature += shadeTemperature;
        }
        if (precipitation == Biome.Precipitation.RAIN) {
            weatherTemperature += (float)Config.Baked.rainTemperatureModifier;
        } else if (precipitation == Biome.Precipitation.SNOW) {
            weatherTemperature += (float)Config.Baked.snowTemperatureModifier;
        }
        return weatherTemperature;
    }
}

