/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.api.thirst.HydrationEnum;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.common.items.drink.CanteenItem;

public class PurificationBlastingRecipe
extends BlastingRecipe {
    public PurificationBlastingRecipe(ResourceLocation id, String group, CookingBookCategory cookingBookCategory, Ingredient ingredient, ItemStack result, float experience, int cookingTime) {
        super(id, group, cookingBookCategory, ingredient, result, experience, cookingTime);
    }

    public boolean m_5818_(Container inventory, @NotNull Level level) {
        return this.f_43729_.test(inventory.m_8020_(0)) && ThirstUtil.getCapacityTag(inventory.m_8020_(0)) > 0;
    }

    @NotNull
    public ItemStack m_5874_(Container inventory, @NotNull RegistryAccess access) {
        int hydrationCapacity = ThirstUtil.getCapacityTag(inventory.m_8020_(0));
        ItemStack result = this.f_43730_.m_41777_();
        ThirstUtil.setHydrationEnumTag(result, HydrationEnum.PURIFIED);
        ThirstUtil.setCapacityTag(result, hydrationCapacity);
        return result;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess access) {
        ItemStack result = this.f_43730_.m_41777_();
        int maxHydrationCapacity = 0;
        Item item = this.f_43730_.m_41720_();
        if (item instanceof CanteenItem) {
            CanteenItem resultItem = (CanteenItem)item;
            maxHydrationCapacity = resultItem.getMaxCapacity();
        }
        ThirstUtil.setHydrationEnumTag(result, HydrationEnum.PURIFIED);
        ThirstUtil.setCapacityTag(result, maxHydrationCapacity);
        return result;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.f_43727_;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return RecipeType.f_44109_;
    }

    public static class Serializer
    implements RecipeSerializer<PurificationBlastingRecipe> {
        public static final Serializer INSTANCE = new Serializer(100);
        private final int defaultCookingTime;

        public Serializer(int cookingTime) {
            this.defaultCookingTime = cookingTime;
        }

        public PurificationBlastingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            ItemStack itemstack;
            String s = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
            CookingBookCategory cookingbookcategory = (CookingBookCategory)CookingBookCategory.f_244271_.m_262792_(GsonHelper.m_13851_((JsonObject)pJson, (String)"category", (String)null), (Enum)CookingBookCategory.MISC);
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)pJson, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_288218_((JsonElement)jsonelement, (boolean)false);
            if (!pJson.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            if (pJson.get("result").isJsonObject()) {
                itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
            } else {
                String s1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"result");
                ResourceLocation resourcelocation = new ResourceLocation(s1);
                itemstack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
            }
            float f = GsonHelper.m_13820_((JsonObject)pJson, (String)"experience", (float)0.0f);
            int i = GsonHelper.m_13824_((JsonObject)pJson, (String)"cookingtime", (int)this.defaultCookingTime);
            return new PurificationBlastingRecipe(pRecipeId, s, cookingbookcategory, ingredient, itemstack, f, i);
        }

        public PurificationBlastingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            String s = pBuffer.m_130277_();
            CookingBookCategory cookingbookcategory = (CookingBookCategory)pBuffer.m_130066_(CookingBookCategory.class);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack itemstack = pBuffer.m_130267_();
            float f = pBuffer.readFloat();
            int i = pBuffer.m_130242_();
            return new PurificationBlastingRecipe(pRecipeId, s, cookingbookcategory, ingredient, itemstack, f, i);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, PurificationBlastingRecipe pRecipe) {
            pBuffer.m_130070_(pRecipe.m_6076_());
            pBuffer.m_130068_((Enum)pRecipe.m_245534_());
            pRecipe.f_43729_.m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.f_43730_);
            pBuffer.writeFloat(pRecipe.f_43731_);
            pBuffer.m_130130_(pRecipe.f_43732_);
        }
    }
}

