/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureResistance;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ITemperatureOriginManager;
import sfiomn.legendarysurvivaloverhaul.network.packets.SyncTemperatureOriginsPacket;

public class TemperatureOriginListener
extends SimpleJsonResourceReloadListener
implements ITemperatureOriginManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, JsonTemperatureResistance> TEMPERATURE_ORIGINS = new HashMap<ResourceLocation, JsonTemperatureResistance>();

    public TemperatureOriginListener() {
        super(GSON, "legendarysurvivaloverhaul/temperature/origins");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        TEMPERATURE_ORIGINS.clear();
        resourceLocationJsonElementMap.forEach((key, json) -> {
            try {
                DataResult parsedJson = JsonTemperatureResistance.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
                JsonTemperatureResistance temperatures = (JsonTemperatureResistance)parsedJson.getOrThrow(false, error -> LegendarySurvivalOverhaul.LOGGER.error("Failed parsing temperature origin : {}", error));
                if (ModList.get().isLoaded(key.m_135827_())) {
                    TEMPERATURE_ORIGINS.put((ResourceLocation)key, temperatures);
                }
            }
            catch (JsonParseException error2) {
                LegendarySurvivalOverhaul.LOGGER.error("Failed to parse temperature origin json {}", key);
            }
        });
        LegendarySurvivalOverhaul.LOGGER.info("Loaded {} temperature origins", (Object)TEMPERATURE_ORIGINS.size());
    }

    public static void sendDataToClient(PacketDistributor.PacketTarget packetTarget) {
        SyncTemperatureOriginsPacket.sendTo(packetTarget, TEMPERATURE_ORIGINS);
    }

    public static void acceptServerTemperatureOrigins(Map<ResourceLocation, JsonTemperatureResistance> temperatureOrigins) {
        TEMPERATURE_ORIGINS.clear();
        TEMPERATURE_ORIGINS.putAll(temperatureOrigins);
    }

    @Override
    public JsonTemperatureResistance get(ResourceLocation originRegistryName) {
        return TEMPERATURE_ORIGINS.get(originRegistryName);
    }
}

