/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureFuelItem;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ITemperatureFuelItemManager;
import sfiomn.legendarysurvivaloverhaul.network.packets.SyncTemperatureFuelItemsPacket;

public class TemperatureFuelItemListener
extends SimpleJsonResourceReloadListener
implements ITemperatureFuelItemManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, JsonTemperatureFuelItem> TEMPERATURE_FUEL_ITEMS = new HashMap<ResourceLocation, JsonTemperatureFuelItem>();

    public TemperatureFuelItemListener() {
        super(GSON, "legendarysurvivaloverhaul/temperature/fuel_items");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        TEMPERATURE_FUEL_ITEMS.clear();
        resourceLocationJsonElementMap.forEach((key, json) -> {
            try {
                DataResult parsedJson = JsonTemperatureFuelItem.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
                JsonTemperatureFuelItem temperatures = (JsonTemperatureFuelItem)parsedJson.getOrThrow(false, error -> LegendarySurvivalOverhaul.LOGGER.error("Failed parsing temperature fuel item : {}", error));
                if (ModList.get().isLoaded(key.m_135827_())) {
                    TEMPERATURE_FUEL_ITEMS.put((ResourceLocation)key, temperatures);
                }
            }
            catch (JsonParseException error2) {
                LegendarySurvivalOverhaul.LOGGER.error("Failed to parse temperature fuel item json {}", key);
            }
        });
        LegendarySurvivalOverhaul.LOGGER.info("Loaded {} temperature fuel items", (Object)TEMPERATURE_FUEL_ITEMS.size());
    }

    public static void sendDataToClient(PacketDistributor.PacketTarget packetTarget) {
        SyncTemperatureFuelItemsPacket.sendTo(packetTarget, TEMPERATURE_FUEL_ITEMS);
    }

    public static void acceptServerTemperatureFuelItems(Map<ResourceLocation, JsonTemperatureFuelItem> temperatureFuelItems) {
        TEMPERATURE_FUEL_ITEMS.clear();
        TEMPERATURE_FUEL_ITEMS.putAll(temperatureFuelItems);
    }

    @Override
    public JsonTemperatureFuelItem get(ResourceLocation itemRegistryName) {
        return TEMPERATURE_FUEL_ITEMS.get(itemRegistryName);
    }
}

