/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.capabilities.wetness;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.LavaFluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import sfiomn.legendarysurvivaloverhaul.api.wetness.IWetnessCapability;
import sfiomn.legendarysurvivaloverhaul.common.integration.curios.CuriosUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.meadow.MeadowUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;
import sfiomn.legendarysurvivaloverhaul.util.WorldUtil;

public class WetnessCapability
implements IWetnessCapability {
    public static final int WETNESS_LIMIT = 400;
    private int wetness;
    private int wetnessTickTimer;
    private int packetTimer;
    private int oldWetness;
    private boolean dirty = false;

    public WetnessCapability() {
        this.init();
    }

    public void init() {
        this.wetness = 0;
        this.wetnessTickTimer = 0;
        this.packetTimer = 0;
        this.oldWetness = this.wetness;
        this.dirty = false;
    }

    @Override
    public int getWetness() {
        return this.wetness;
    }

    @Override
    public int getWetnessTickTimer() {
        return this.wetnessTickTimer;
    }

    @Override
    public void setWetness(int wetness) {
        this.wetness = Mth.m_14045_((int)wetness, (int)0, (int)400);
    }

    @Override
    public void setWetnessTickTimer(int tickTimer) {
        this.wetnessTickTimer = tickTimer;
    }

    @Override
    public void addWetness(int wetness) {
        this.setWetness(this.wetness + wetness);
    }

    @Override
    public void addWetnessTickTimer(int tickTimer) {
        this.setWetnessTickTimer(this.getWetnessTickTimer() + tickTimer);
    }

    @Override
    public void tickUpdate(Player player, Level level, TickEvent.Phase phase) {
        ResourceLocation entityRegistryName;
        if (this.getWetnessTickTimer() == -1 || CuriosUtil.isCurioItemEquipped(player, (Item)ItemRegistry.SPONGE.get())) {
            if (this.getWetness() > 0) {
                this.setWetness(0);
            }
            return;
        }
        if (phase == TickEvent.Phase.START) {
            ++this.packetTimer;
            return;
        }
        this.addWetnessTickTimer(1);
        if (this.getWetnessTickTimer() < Config.Baked.wetnessTickTimer) {
            return;
        }
        this.setWetnessTickTimer(0);
        if (this.wetness > 0 && player.m_20094_() > 0 && !player.m_5825_()) {
            this.addWetness(-10);
        }
        BlockPos pos = player.m_20183_();
        if (player.m_20202_() != null && (entityRegistryName = ForgeRegistries.ENTITY_TYPES.getKey((Object)player.m_20202_().m_6095_())) != null && Config.Baked.wetnessImmunityMounts.contains(entityRegistryName.toString())) {
            if (this.wetness > 0) {
                this.addWetness(Config.Baked.wetnessDecrease);
            }
            return;
        }
        if (player.m_20202_() != null && !(player.m_20202_() instanceof LivingEntity) && !player.m_20202_().f_19812_) {
            pos = pos.m_7494_();
            if (this.wetness > 0 && level.m_6425_(pos).m_76178_()) {
                this.worldParticles(player, level);
            }
        } else if (this.wetness > 0 && (level.m_6425_(pos).m_76178_() || level.m_6425_(pos.m_7494_()).m_76178_())) {
            this.worldParticles(player, level);
        }
        FluidState fluidState = level.m_6425_(pos);
        BlockState blockState = level.m_8055_(pos);
        FluidState fluidStateUp = level.m_6425_(pos.m_7494_());
        if (fluidState.m_76178_() && !blockState.m_60713_(Blocks.f_152476_) && !MeadowUtil.isInWoodenWaterCauldron(blockState)) {
            Biome.Precipitation precipitation = WorldUtil.getPrecipitationAt(level, player, pos);
            if (this.wetness < 400 && precipitation == Biome.Precipitation.RAIN) {
                this.addWetness(Config.Baked.wetnessRainIncrease);
            } else if (this.wetness > 0 && precipitation == Biome.Precipitation.NONE) {
                this.addWetness(Config.Baked.wetnessDecrease);
            }
        } else {
            Fluid fluid = Fluids.f_76191_;
            float fractionalLevel = 0.0f;
            if (!fluidState.m_76178_()) {
                fluid = fluidState.m_76152_();
                fractionalLevel = MathUtil.invLerp(1.0f, 8.0f, fluidState.m_76186_());
            } else if (blockState.m_60713_(Blocks.f_152476_) || MeadowUtil.isInWoodenWaterCauldron(blockState)) {
                fluid = Fluids.f_76193_;
                if (blockState.m_61138_((Property)LayeredCauldronBlock.f_153514_)) {
                    fractionalLevel = MathUtil.invLerp(1.0f, 3.0f, ((Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_)).intValue());
                }
            }
            if ((float)player.m_20182_().m_7098_() > (float)pos.m_123342_() + fractionalLevel + 0.0625f) {
                return;
            }
            if (!fluidStateUp.m_76178_()) {
                fractionalLevel += MathUtil.invLerp(1.0f, 8.0f, fluidStateUp.m_76186_());
            }
            if (fluid instanceof ForgeFlowingFluid) {
                ForgeFlowingFluid forgeFluid = (ForgeFlowingFluid)fluidState.m_76152_();
                if (this.wetness > 0 && forgeFluid.getFluidType().isAir()) {
                    this.addWetness(Config.Baked.wetnessDecrease);
                    return;
                }
                int temperature = forgeFluid.getFluidType().getTemperature();
                if (this.wetness < 400 && temperature < 400) {
                    this.addWetness(Math.round((float)Config.Baked.wetnessFluidIncrease * fractionalLevel));
                } else if (this.wetness > 0) {
                    this.addWetness(Config.Baked.wetnessDecrease);
                }
            } else if (this.wetness > 0 && fluid instanceof LavaFluid) {
                this.addWetness(-Math.round(20.0f * fractionalLevel));
            } else if (this.wetness < 400) {
                this.addWetness(Math.round((float)Config.Baked.wetnessFluidIncrease * fractionalLevel));
            }
        }
    }

    private void worldParticles(Player player, Level level) {
        Vec3 pos = player.m_20182_();
        AABB box = player.m_20191_();
        int particleSpawnRate = Math.round((1.0f - MathUtil.invLerp(0.0f, 400.0f, this.wetness)) * 10.0f);
        if (particleSpawnRate == 0 || level.m_6106_().m_6793_() % (long)particleSpawnRate == 0L) {
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123804_, pos.f_82479_, pos.f_82480_ + box.m_82376_() / 2.0, pos.f_82481_, 1, box.m_82362_() / 3.0, box.m_82376_() / 4.0, box.m_82385_() / 3.0, 0.0);
        }
    }

    @Override
    public boolean isDirty() {
        return this.wetness != this.oldWetness || this.dirty;
    }

    @Override
    public void setClean() {
        this.oldWetness = this.wetness;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public int getPacketTimer() {
        return this.packetTimer;
    }

    public CompoundTag writeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("wetness", this.getWetness());
        compound.m_128405_("wetnessTickTimer", this.getWetnessTickTimer());
        return compound;
    }

    public void readNBT(CompoundTag compound) {
        this.init();
        if (compound.m_128441_("wetness")) {
            this.setWetness(compound.m_128451_("wetness"));
        }
        if (compound.m_128441_("wetnessTickTimer")) {
            this.setWetnessTickTimer(compound.m_128451_("wetnessTickTimer"));
        }
    }
}

