/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.capabilities.health;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import sfiomn.legendarysurvivaloverhaul.api.health.IHealthCapability;
import sfiomn.legendarysurvivaloverhaul.config.Config;

public class HealthCapability
implements IHealthCapability {
    private float additionalHealth;
    private float shieldHealth;
    private float oldAdditionalHealth;
    private float oldShieldHealth;
    private int packetTimer;

    public HealthCapability() {
        this.init();
    }

    public void init() {
        this.additionalHealth = 0.0f;
        this.shieldHealth = 0.0f;
        this.oldAdditionalHealth = 0.0f;
        this.oldShieldHealth = 0.0f;
        this.packetTimer = 0;
    }

    @Override
    public void addAdditionalHealth(float healthValue) {
        this.setAdditionalHealth(this.getAdditionalHealth() + healthValue);
    }

    @Override
    public void addShieldHealth(float shieldValue) {
        this.setShieldHealth(this.getShieldHealth() + shieldValue);
    }

    @Override
    public void setAdditionalHealth(float newHealthValue) {
        this.additionalHealth = Math.min(newHealthValue, (float)Config.Baked.maxAdditionalHealth);
    }

    @Override
    public void setShieldHealth(float newHealthValue) {
        this.shieldHealth = Mth.m_14036_((float)newHealthValue, (float)0.0f, (float)((float)Config.Baked.maxShieldHealth));
    }

    @Override
    public float getAdditionalHealth() {
        return this.additionalHealth;
    }

    @Override
    public float getShieldHealth() {
        return this.shieldHealth;
    }

    @Override
    public boolean isDirty() {
        return this.additionalHealth != this.oldAdditionalHealth || this.shieldHealth != this.oldShieldHealth;
    }

    @Override
    public void setClean() {
        this.oldAdditionalHealth = this.additionalHealth;
        this.oldShieldHealth = this.shieldHealth;
    }

    @Override
    public int getPacketTimer() {
        return this.packetTimer;
    }

    public CompoundTag writeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128350_("additionalHealth", this.getAdditionalHealth());
        compound.m_128350_("shieldHealth", this.getShieldHealth());
        return compound;
    }

    public void readNBT(CompoundTag compound) {
        this.init();
        if (compound.m_128441_("additionalHealth")) {
            this.setAdditionalHealth(compound.m_128457_("additionalHealth"));
        }
        if (compound.m_128441_("shieldHealth")) {
            this.setShieldHealth(compound.m_128457_("shieldHealth"));
        }
    }
}

