/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.blockentities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.api.block.ThermalTypeEnum;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureFuelItem;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.TemperatureDataManager;
import sfiomn.legendarysurvivaloverhaul.common.blocks.ThermalBlock;

public abstract class AbstractThermalBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
StackedContentsCompatible {
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    protected final ContainerData dataAccess;
    private int fuelTime = 0;
    private int fuelDuration;
    private int tickCount = 0;
    private final ThermalTypeEnum thermalType;
    public static final int SLOT_COUNT = 4;

    public AbstractThermalBlockEntity(BlockEntityType<?> blockEntityType, ThermalTypeEnum thermalType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.thermalType = thermalType;
        this.dataAccess = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> AbstractThermalBlockEntity.this.fuelTime;
                    case 1 -> AbstractThermalBlockEntity.this.fuelDuration;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        AbstractThermalBlockEntity.this.fuelTime = value;
                        break;
                    }
                    case 1: {
                        AbstractThermalBlockEntity.this.fuelDuration = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    @NotNull
    public abstract Component m_6820_();

    @NotNull
    public abstract AbstractContainerMenu m_6555_(int var1, @NotNull Inventory var2);

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractThermalBlockEntity entity) {
        if (level == null) {
            return;
        }
        if (!entity.isPowered()) {
            if (((Boolean)state.m_61143_((Property)ThermalBlock.LIT)).booleanValue() && !level.f_46443_) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)ThermalBlock.LIT, (Comparable)Boolean.valueOf(false)));
                entity.m_6596_();
            }
            return;
        }
        if (entity.isLit() && !((Boolean)state.m_61143_((Property)ThermalBlock.LIT)).booleanValue() && !level.f_46443_) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ThermalBlock.LIT, (Comparable)Boolean.valueOf(entity.isLit())));
            entity.m_6596_();
        }
        if (entity.tickCount > 20) {
            entity.tickCount = 0;
            boolean initiallyLit = entity.isLit();
            boolean needRefresh = false;
            if (entity.isLit()) {
                entity.consumeFuel();
            }
            if (!entity.isLit() && !level.f_46443_) {
                entity.refillFuel();
                if (entity.isLit()) {
                    level.m_7260_(pos, state, state, 2);
                    needRefresh = true;
                }
            }
            if (initiallyLit != entity.isLit() && !level.f_46443_) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)ThermalBlock.LIT, (Comparable)Boolean.valueOf(entity.isLit())));
                needRefresh = true;
            }
            if (needRefresh) {
                entity.m_6596_();
            }
        }
        ++entity.tickCount;
    }

    private void consumeFuel() {
        this.fuelTime -= 20;
    }

    public void refillFuel() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            int fuelValue;
            if (this.m_8020_(i).m_41613_() <= 0 || !this.isItemValid(this.m_8020_(i).m_41720_()) || (fuelValue = this.getFuelDuration((ItemStack)this.items.get(i))) <= 0) continue;
            this.fuelTime = fuelValue;
            this.fuelDuration = fuelValue;
            this.m_8020_(i).m_41774_(1);
            return;
        }
    }

    public boolean isItemValid(Item item) {
        ResourceLocation registryNameItem = ForgeRegistries.ITEMS.getKey((Object)item);
        JsonTemperatureFuelItem fuelInfo = TemperatureDataManager.getFuelItem(registryNameItem);
        return fuelInfo != null && fuelInfo.thermalType == this.thermalType && fuelInfo.duration > 0;
    }

    public int getFuelDuration(ItemStack item) {
        ResourceLocation registryNameItem = ForgeRegistries.ITEMS.getKey((Object)item.m_41720_());
        JsonTemperatureFuelItem fuelInfo = TemperatureDataManager.getFuelItem(registryNameItem);
        return fuelInfo != null ? fuelInfo.duration : 0;
    }

    public boolean isLit() {
        if (this.f_58857_ != null) {
            return this.fuelTime > 0;
        }
        return false;
    }

    public boolean isPowered() {
        if (this.f_58857_ != null) {
            return this.f_58857_.m_276867_(this.f_58858_);
        }
        return false;
    }

    public void m_5809_(@NotNull StackedContents p_58342_) {
        for (ItemStack itemstack : this.items) {
            p_58342_.m_36491_(itemstack);
        }
    }

    public int @NotNull [] m_7071_(@NotNull Direction direction) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean m_7013_(int slot, ItemStack itemStack) {
        return this.isItemValid(itemStack.m_41720_());
    }

    public boolean m_7155_(int slot, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(slot, itemStack);
    }

    public boolean m_7157_(int slot, @NotNull ItemStack stack, @NotNull Direction direction) {
        return slot < 4;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
    }

    @Nonnull
    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(@NotNull Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.fuelTime = tag.m_128451_("fuelTime");
        this.fuelDuration = tag.m_128451_("fuelDuration");
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("fuelTime", this.fuelTime);
        tag.m_128405_("fuelDuration", this.fuelDuration);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }
}

