/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.api.config.json_old.temperature;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.JsonPropertyValue;

public class JsonBlockFluidTemperature {
    @SerializedName(value="properties")
    public Map<String, String> properties;
    @SerializedName(value="temperature")
    public float temperature;

    public JsonBlockFluidTemperature(float temperature, JsonPropertyValue ... props) {
        this.temperature = temperature;
        this.properties = new HashMap<String, String>();
        for (JsonPropertyValue prop : props) {
            this.properties.put(prop.name, prop.value);
        }
    }

    public JsonPropertyValue[] getPropertyArray() {
        ArrayList<JsonPropertyValue> jpvList = new ArrayList<JsonPropertyValue>();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            jpvList.add(new JsonPropertyValue(entry.getKey(), entry.getValue()));
        }
        return jpvList.toArray(new JsonPropertyValue[0]);
    }

    public boolean matchesState(BlockState blockState) {
        for (Property property : blockState.m_61147_()) {
            String name = property.m_61708_();
            if (!this.properties.containsKey(name)) continue;
            String stateValue = blockState.m_61143_(property).toString();
            if (this.properties.get(name).equalsIgnoreCase(stateValue)) continue;
            return false;
        }
        return true;
    }

    public boolean matchesState(FluidState fluidState) {
        for (Property property : fluidState.m_61147_()) {
            String name = property.m_61708_();
            if (!this.properties.containsKey(name)) continue;
            String stateValue = fluidState.m_61143_(property).toString();
            if (this.properties.get(name).equalsIgnoreCase(stateValue)) continue;
            return false;
        }
        return true;
    }

    public boolean matchesProperties(JsonPropertyValue ... props) {
        if (props.length != this.properties.keySet().size()) {
            return false;
        }
        for (JsonPropertyValue prop : props) {
            if (!this.properties.containsKey(prop.name)) {
                return false;
            }
            if (prop.value.equalsIgnoreCase(this.properties.get(prop.name))) continue;
            return false;
        }
        return true;
    }
}

