/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.block.entity;

import com.google.common.collect.ImmutableSet;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxesTypes;
import com.progwml6.ironshulkerbox.common.block.entity.AbstractIronShulkerBoxBlockEntity;
import com.progwml6.ironshulkerbox.common.block.entity.ICrystalShulkerBox;
import com.progwml6.ironshulkerbox.common.inventory.IronShulkerBoxMenu;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlockEntityTypes;
import com.progwml6.ironshulkerbox.common.registraton.IronShulkerBoxesBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public class CrystalShulkerBoxBlockEntity
extends AbstractIronShulkerBoxBlockEntity
implements ICrystalShulkerBox {
    private NonNullList<ItemStack> topStacks = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    private boolean inventoryTouched;
    private boolean hadStuff;

    public CrystalShulkerBoxBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)IronShulkerBoxesBlockEntityTypes.CRYSTAL_SHULKER_BOX.get(), pPos, pState, IronShulkerBoxesTypes.CRYSTAL);
    }

    public CrystalShulkerBoxBlockEntity(@Nullable DyeColor pColor, BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)IronShulkerBoxesBlockEntityTypes.CRYSTAL_SHULKER_BOX.get(), blockPos, blockState, pColor, IronShulkerBoxesTypes.CRYSTAL);
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return IronShulkerBoxMenu.createCrystalContainer(pContainerId, pInventory, (Container)this);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, AbstractIronShulkerBoxBlockEntity pBlockEntity) {
        pBlockEntity.updateAnimation(pLevel, pPos, pState);
        if (pBlockEntity instanceof CrystalShulkerBoxBlockEntity) {
            CrystalShulkerBoxBlockEntity crystalShulkerBoxBlockEntity = (CrystalShulkerBoxBlockEntity)pBlockEntity;
            if (!pLevel.f_46443_ && crystalShulkerBoxBlockEntity.inventoryTouched) {
                crystalShulkerBoxBlockEntity.inventoryTouched = false;
                crystalShulkerBoxBlockEntity.sortTopStacks();
            }
        }
    }

    @Override
    public void m_6520_(NonNullList<ItemStack> contents) {
        super.m_6520_(contents);
        this.inventoryTouched = true;
    }

    public ItemStack m_8020_(int index) {
        this.inventoryTouched = true;
        return super.m_8020_(index);
    }

    @Override
    public NonNullList<ItemStack> getTopItems() {
        return this.topStacks;
    }

    @Override
    public Level getChestLevel() {
        return this.f_58857_;
    }

    @Override
    public BlockPos getChestWorldPosition() {
        return this.f_58858_;
    }

    @Override
    public void receiveMessageFromServer(NonNullList<ItemStack> topStacks) {
        this.topStacks = topStacks;
    }

    @Override
    public void setHadStuff(boolean hadStuff) {
        this.hadStuff = hadStuff;
    }

    @Override
    public boolean getHadStuff() {
        return this.hadStuff;
    }

    @Override
    public NonNullList<ItemStack> getCurrentItems() {
        return this.m_7086_();
    }

    @Override
    public Block getBlockToUse() {
        if (this.getColor() == null) {
            return (Block)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOX.get();
        }
        return (Block)((RegistryObject)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOXES.get((Object)this.getColor())).get();
    }

    public static void buildBlocks(ImmutableSet.Builder<Block> builder) {
        builder.add((Object)((Block)IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOX.get()));
        IronShulkerBoxesBlocks.CRYSTAL_SHULKER_BOXES.forEach((dyeColor, block) -> builder.add((Object)((Block)block.get())));
    }
}

