/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.eldritch_blast;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.entity.spells.eldritch_blast.EldritchBlastVisualEntity;
import io.redspace.ironsspellbooks.entity.spells.magic_arrow.MagicArrowRenderer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class EldritchBlastRenderer
extends EntityRenderer<EldritchBlastVisualEntity> {
    public static final ModelLayerLocation MODEL_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"eldritch_blast_model"), "main");
    private static final ResourceLocation TEXTURE_CORE = IronsSpellbooks.id("textures/entity/eldritch_blast/core.png");
    private static final ResourceLocation TEXTURE_OVERLAY = IronsSpellbooks.id("textures/entity/eldritch_blast/overlay.png");
    private final ModelPart body;

    public EldritchBlastRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart modelpart = context.m_174023_(MODEL_LAYER_LOCATION);
        this.body = modelpart.m_171324_("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -16.0f, -8.0f, 16.0f, 32.0f, 16.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public boolean shouldRender(EldritchBlastVisualEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return true;
    }

    public void render(EldritchBlastVisualEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.m_85836_();
        float lifetime = 8.0f;
        float scalar = 0.25f;
        float length = 32.0f * scalar * scalar;
        float f = (float)entity.f_19797_ + partialTicks;
        poseStack.m_85837_(0.0, entity.m_20191_().m_82376_() * 0.5, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-entity.m_146908_() - 180.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-entity.m_146909_() - 90.0f));
        poseStack.m_85841_(scalar, scalar, scalar);
        float alpha = Mth.m_14036_((float)(1.0f - f / lifetime), (float)0.0f, (float)1.0f);
        for (float i = 0.0f; i < entity.distance * 4.0f; i += length) {
            poseStack.m_252880_(0.0f, length, 0.0f);
            VertexConsumer consumer = bufferSource.m_6299_(MagicArrowRenderer.CustomRenderType.magicNoCull(TEXTURE_OVERLAY));
            poseStack.m_85836_();
            float expansion = Mth.m_144920_((float)1.2f, (float)0.0f, (float)(f / lifetime));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(f * 5.0f));
            poseStack.m_85841_(expansion, 1.0f, expansion);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
            this.body.m_104306_(poseStack, consumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
            poseStack.m_85849_();
            consumer = bufferSource.m_6299_(CustomerRenderType.m_110494_(TEXTURE_CORE));
            poseStack.m_85836_();
            expansion = Mth.m_144920_((float)1.0f, (float)0.0f, (float)(f / (lifetime - 5.0f)));
            poseStack.m_85841_(expansion, 1.0f, expansion);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(f * -10.0f));
            this.body.m_104306_(poseStack, consumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(EldritchBlastVisualEntity entity) {
        return TEXTURE_CORE;
    }

    public static class CustomerRenderType
    extends RenderType {
        protected static final RenderStateShard.TransparencyStateShard ONE_MINUS = new RenderStateShard.TransparencyStateShard("one_minus", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });

        public CustomerRenderType(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
            super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
        }

        @NotNull
        public static RenderType m_110494_(@NotNull ResourceLocation pLocation) {
            return CustomerRenderType.m_173215_((String)"crumbling", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173074_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(pLocation, false, false)).m_110685_(ONE_MINUS).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(false));
        }
    }
}

