/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.ftbxaerocompat;

import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xaero.map.WorldMap;
import xaero.map.highlight.ChunkHighlighter;

public class ClaimsHighlighter
extends ChunkHighlighter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClaimsHighlighter.class);

    public ClaimsHighlighter() {
        super(true);
    }

    public boolean regionHasHighlights(ResourceKey<Level> key, int regionX, int regionZ) {
        return true;
    }

    public boolean chunkIsHighlit(ResourceKey<Level> key, int x, int z) {
        if (!WorldMap.settings.displayClaims) {
            return false;
        }
        Optional opt = MapDimension.getCurrent();
        if (opt.isEmpty()) {
            return false;
        }
        MapChunk chunk = ClaimsHighlighter.getChunk((MapDimension)opt.get(), x, z);
        return chunk != null && chunk.getTeam().isPresent();
    }

    protected int[] getColors(ResourceKey<Level> key, int x, int z) {
        if (!WorldMap.settings.displayClaims) {
            return null;
        }
        Optional opt = MapDimension.getCurrent();
        if (opt.isEmpty()) {
            return null;
        }
        MapDimension dim = (MapDimension)opt.get();
        MapChunk centerChunk = ClaimsHighlighter.getChunk(dim, x, z);
        if (centerChunk == null) {
            return null;
        }
        Optional optTeam = centerChunk.getTeam();
        if (optTeam.isEmpty()) {
            return null;
        }
        Team team = (Team)optTeam.get();
        MapChunk top = ClaimsHighlighter.getChunk(dim, x, z - 1);
        MapChunk right = ClaimsHighlighter.getChunk(dim, x + 1, z);
        MapChunk bottom = ClaimsHighlighter.getChunk(dim, x, z + 1);
        MapChunk left = ClaimsHighlighter.getChunk(dim, x - 1, z);
        int rgb = ((Color4I)team.getProperties().get((TeamProperty)TeamProperties.COLOR)).rgb() & 0xFFFFFF;
        int packed = (rgb & 0xFF) << 24 | (rgb >> 8 & 0xFF) << 16 | (rgb >> 16 & 0xFF) << 8;
        int fillOpacity = 255 * WorldMap.settings.claimsFillOpacity / 100;
        int borderOpacity = 255 * WorldMap.settings.claimsBorderOpacity / 100;
        int fill = packed & 0xFFFFFF00 | fillOpacity;
        int edge = packed & 0xFFFFFF00 | borderOpacity;
        this.resultStore[0] = fill;
        this.resultStore[1] = ClaimsHighlighter.sameOwner(top, centerChunk) ? fill : edge;
        this.resultStore[2] = ClaimsHighlighter.sameOwner(right, centerChunk) ? fill : edge;
        this.resultStore[3] = ClaimsHighlighter.sameOwner(bottom, centerChunk) ? fill : edge;
        this.resultStore[4] = ClaimsHighlighter.sameOwner(left, centerChunk) ? fill : edge;
        return this.resultStore;
    }

    private static boolean sameOwner(MapChunk a, MapChunk b) {
        if (a == null || b == null) {
            return false;
        }
        Optional aTeam = a.getTeam();
        Optional bTeam = b.getTeam();
        if (aTeam.isEmpty() || bTeam.isEmpty()) {
            return false;
        }
        return ((Team)aTeam.get()).getId().equals(((Team)bTeam.get()).getId());
    }

    public int calculateRegionHash(ResourceKey<Level> key, int regionX, int regionZ) {
        if (!WorldMap.settings.displayClaims) {
            return 0;
        }
        Optional opt = MapDimension.getCurrent();
        if (opt.isEmpty()) {
            return 0;
        }
        MapDimension dim = (MapDimension)opt.get();
        int chunkX = regionX * 32;
        int chunkZ = regionZ * 32;
        long acc = 0L;
        acc = acc * 37L + (long)WorldMap.settings.claimsBorderOpacity;
        acc = acc * 37L + (long)WorldMap.settings.claimsFillOpacity;
        for (int i = 0; i < 32; ++i) {
            acc = this.accountChunk(acc, ClaimsHighlighter.getChunk(dim, chunkX + i, chunkZ - 1));
            acc = this.accountChunk(acc, ClaimsHighlighter.getChunk(dim, chunkX + 32, chunkZ + i));
            acc = this.accountChunk(acc, ClaimsHighlighter.getChunk(dim, chunkX + i, chunkZ + 32));
            acc = this.accountChunk(acc, ClaimsHighlighter.getChunk(dim, chunkX - 1, chunkZ + i));
            for (int j = 0; j < 32; ++j) {
                acc = this.accountChunk(acc, ClaimsHighlighter.getChunk(dim, chunkX + i, chunkZ + j));
            }
        }
        return (int)(acc >> 32) * 37 + (int)(acc & 0xFFFFFFFFL);
    }

    private long accountChunk(long acc, @Nullable MapChunk chunk) {
        if (chunk != null) {
            Optional optional = chunk.getTeam();
            if (optional.isEmpty()) {
                return acc * 37L;
            }
            Team team = (Team)optional.get();
            UUID teamId = team.getId();
            int color = ((Color4I)team.getProperties().get((TeamProperty)TeamProperties.COLOR)).rgb();
            acc += teamId.getLeastSignificantBits();
            acc *= 37L;
            acc += teamId.getMostSignificantBits();
            acc *= 37L;
            acc += (long)color;
            acc *= 37L;
            acc += chunk.getForceLoadedDate().isPresent() ? 1L : 0L;
            acc *= 37L;
        }
        return acc * 37L;
    }

    public Component getChunkHighlightSubtleTooltip(ResourceKey<Level> key, int x, int z) {
        Optional opt = MapDimension.getCurrent();
        if (opt.isEmpty()) {
            return null;
        }
        MapChunk chunk = ClaimsHighlighter.getChunk((MapDimension)opt.get(), x, z);
        if (chunk == null) {
            return null;
        }
        return chunk.getTeam().map(Team::getColoredName).orElse((Component)Component.m_237119_());
    }

    public Component getChunkHighlightBluntTooltip(ResourceKey<Level> resourceKey, int x, int t) {
        return null;
    }

    public void addMinimapBlockHighlightTooltips(List<Component> list, ResourceKey<Level> resourceKey, int x, int z, int width) {
    }

    @Nullable
    private static MapChunk getChunk(MapDimension dim, int chunkX, int chunkZ) {
        MapRegion r = dim.getRegion(XZ.regionFromChunk((int)chunkX, (int)chunkZ));
        return r.getChunkForAbsoluteChunkPos(XZ.of((int)chunkX, (int)chunkZ));
    }
}

