/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelpreview.lib.logger;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.Nullable;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class ReallySimpleLogger
extends MarkerIgnoringBase {
    public static final int LOG_LEVEL_TRACE = 0;
    public static final int LOG_LEVEL_DEBUG = 10;
    public static final int LOG_LEVEL_INFO = 20;
    public static final int LOG_LEVEL_WARN = 30;
    public static final int LOG_LEVEL_ERROR = 40;
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final PrintStream SYS_OUT = System.out;
    private final String name;
    private final int logLevel;

    ReallySimpleLogger(String name, int logLevel) {
        this.name = name;
        this.logLevel = logLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(int level, String message, @Nullable Throwable t) {
        if (level < this.logLevel) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[').append(TIME_FORMAT.format(new Date())).append("] ");
        builder.append('[').append(Thread.currentThread().getName()).append('/').append(ReallySimpleLogger.getLevelName(level)).append("] ");
        builder.append("[").append(this.name).append("]: ");
        builder.append(message);
        PrintStream printStream = SYS_OUT;
        synchronized (printStream) {
            SYS_OUT.println(builder);
            if (t != null) {
                t.printStackTrace(SYS_OUT);
            }
            SYS_OUT.flush();
        }
    }

    private void formatAndLog(int level, String format, Object ... arguments) {
        if (level < this.logLevel) {
            return;
        }
        FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.log(level, tp.getMessage(), tp.getThrowable());
    }

    private static String getLevelName(int level) {
        switch (level) {
            case 0: {
                return "TRACE";
            }
            case 10: {
                return "DEBUG";
            }
            case 20: {
                return "INFO";
            }
            case 30: {
                return "WARN";
            }
            case 40: {
                return "ERROR";
            }
        }
        throw new IllegalStateException("Switch falloff. Unknown level: " + level);
    }

    public void trace(String msg) {
        this.log(0, msg, null);
    }

    public void trace(String format, Object arg) {
        this.formatAndLog(0, format, arg, null);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.formatAndLog(0, format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.formatAndLog(0, format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.log(0, msg, t);
    }

    public void debug(String msg) {
        this.log(10, msg, null);
    }

    public void debug(String format, Object arg) {
        this.formatAndLog(10, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.formatAndLog(10, format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.formatAndLog(10, format, arguments);
    }

    public void debug(String msg, Throwable t) {
        this.log(10, msg, t);
    }

    public void info(String msg) {
        this.log(20, msg, null);
    }

    public void info(String format, Object arg) {
        this.formatAndLog(20, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.formatAndLog(20, format, arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        this.formatAndLog(20, format, arguments);
    }

    public void info(String msg, Throwable t) {
        this.log(20, msg, t);
    }

    public void warn(String msg) {
        this.log(30, msg, null);
    }

    public void warn(String format, Object arg) {
        this.formatAndLog(30, format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.formatAndLog(30, format, arg1, arg2);
    }

    public void warn(String format, Object ... arguments) {
        this.formatAndLog(30, format, arguments);
    }

    public void warn(String msg, Throwable t) {
        this.log(30, msg, t);
    }

    public void error(String msg) {
        this.log(40, msg, null);
    }

    public void error(String format, Object arg) {
        this.formatAndLog(40, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.formatAndLog(40, format, arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        this.formatAndLog(40, format, arguments);
    }

    public void error(String msg, Throwable t) {
        this.log(40, msg, t);
    }

    public boolean isTraceEnabled() {
        return 0 >= this.logLevel;
    }

    public boolean isDebugEnabled() {
        return 10 >= this.logLevel;
    }

    public boolean isInfoEnabled() {
        return 20 >= this.logLevel;
    }

    public boolean isWarnEnabled() {
        return 30 >= this.logLevel;
    }

    public boolean isErrorEnabled() {
        return 40 >= this.logLevel;
    }
}

