/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.lib;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;
import net.creeperhost.levelio.lib.nbt.NBTHandler;

public class BlockIdConverter {
    public static final String UNKNOWN_BLOCK_NAME = "<unknown>:<unknown>";
    private static final ICompoundTag[] ID_MAP = new ICompoundTag[4096];
    private static final ICompoundTag[] BLOCK_DEFAULTS = new ICompoundTag[256];
    private static final Map<ICompoundTag, Integer> TAG_MAP = new HashMap<ICompoundTag, Integer>();
    private static NBTHandler nbtHandler;

    public static void init(NBTHandler nbtHandler) {
        if (BlockIdConverter.nbtHandler == null) {
            BlockIdConverter.nbtHandler = nbtHandler;
            BlockIdConverter.registerConversions();
        }
    }

    private static void register(int idMeta, String blockData) {
        try {
            BlockIdConverter.ID_MAP[idMeta] = nbtHandler.fromSNBT(blockData.replace('\'', '\"'));
            TAG_MAP.put(ID_MAP[idMeta], idMeta);
            int blockId = idMeta >> 4;
            if (BLOCK_DEFAULTS[blockId] == null) {
                BlockIdConverter.BLOCK_DEFAULTS[blockId] = ID_MAP[idMeta];
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasMapping(int blockId, int metaData) {
        int id = blockId << 4 | metaData;
        return id >= 0 && id < ID_MAP.length;
    }

    public static ICompoundTag dataFromId(int blockId, int metaData) {
        int id = blockId << 4 | metaData;
        if (id >= 0 && id < ID_MAP.length) {
            return ID_MAP[id];
        }
        return null;
    }

    public static IdMeta idMetaFromTag(ICompoundTag tag) {
        int id = TAG_MAP.getOrDefault(tag, 0);
        int blockId = id >> 4;
        int metaData = id & 4;
        return new IdMeta(blockId, metaData);
    }

    private static void registerConversions() {
        BlockIdConverter.register(0, "{Name:'minecraft:air'}");
        BlockIdConverter.register(16, "{Name:'minecraft:stone'}");
        BlockIdConverter.register(17, "{Name:'minecraft:granite'}");
        BlockIdConverter.register(18, "{Name:'minecraft:polished_granite'}");
        BlockIdConverter.register(19, "{Name:'minecraft:diorite'}");
        BlockIdConverter.register(20, "{Name:'minecraft:polished_diorite'}");
        BlockIdConverter.register(21, "{Name:'minecraft:andesite'}");
        BlockIdConverter.register(22, "{Name:'minecraft:polished_andesite'}");
        BlockIdConverter.register(32, "{Name:'minecraft:grass_block',Properties:{snowy:'false'}}");
        BlockIdConverter.register(48, "{Name:'minecraft:dirt'}");
        BlockIdConverter.register(49, "{Name:'minecraft:coarse_dirt'}");
        BlockIdConverter.register(50, "{Name:'minecraft:podzol',Properties:{snowy:'false'}}");
        BlockIdConverter.register(64, "{Name:'minecraft:cobblestone'}");
        BlockIdConverter.register(80, "{Name:'minecraft:oak_planks'}");
        BlockIdConverter.register(81, "{Name:'minecraft:spruce_planks'}");
        BlockIdConverter.register(82, "{Name:'minecraft:birch_planks'}");
        BlockIdConverter.register(83, "{Name:'minecraft:jungle_planks'}");
        BlockIdConverter.register(84, "{Name:'minecraft:acacia_planks'}");
        BlockIdConverter.register(85, "{Name:'minecraft:dark_oak_planks'}");
        BlockIdConverter.register(96, "{Name:'minecraft:oak_sapling',Properties:{stage:'0'}}");
        BlockIdConverter.register(97, "{Name:'minecraft:spruce_sapling',Properties:{stage:'0'}}");
        BlockIdConverter.register(98, "{Name:'minecraft:birch_sapling',Properties:{stage:'0'}}");
        BlockIdConverter.register(99, "{Name:'minecraft:jungle_sapling',Properties:{stage:'0'}}");
        BlockIdConverter.register(100, "{Name:'minecraft:acacia_sapling',Properties:{stage:'0'}}");
        BlockIdConverter.register(101, "{Name:'minecraft:dark_oak_sapling',Properties:{stage:'0'}}");
        BlockIdConverter.register(104, "{Name:'minecraft:oak_sapling',Properties:{stage:'1'}}");
        BlockIdConverter.register(105, "{Name:'minecraft:spruce_sapling',Properties:{stage:'1'}}");
        BlockIdConverter.register(106, "{Name:'minecraft:birch_sapling',Properties:{stage:'1'}}");
        BlockIdConverter.register(107, "{Name:'minecraft:jungle_sapling',Properties:{stage:'1'}}");
        BlockIdConverter.register(108, "{Name:'minecraft:acacia_sapling',Properties:{stage:'1'}}");
        BlockIdConverter.register(109, "{Name:'minecraft:dark_oak_sapling',Properties:{stage:'1'}}");
        BlockIdConverter.register(112, "{Name:'minecraft:bedrock'}");
        BlockIdConverter.register(128, "{Name:'minecraft:water',Properties:{level:'0'}}");
        BlockIdConverter.register(129, "{Name:'minecraft:water',Properties:{level:'1'}}");
        BlockIdConverter.register(130, "{Name:'minecraft:water',Properties:{level:'2'}}");
        BlockIdConverter.register(131, "{Name:'minecraft:water',Properties:{level:'3'}}");
        BlockIdConverter.register(132, "{Name:'minecraft:water',Properties:{level:'4'}}");
        BlockIdConverter.register(133, "{Name:'minecraft:water',Properties:{level:'5'}}");
        BlockIdConverter.register(134, "{Name:'minecraft:water',Properties:{level:'6'}}");
        BlockIdConverter.register(135, "{Name:'minecraft:water',Properties:{level:'7'}}");
        BlockIdConverter.register(136, "{Name:'minecraft:water',Properties:{level:'8'}}");
        BlockIdConverter.register(137, "{Name:'minecraft:water',Properties:{level:'9'}}");
        BlockIdConverter.register(138, "{Name:'minecraft:water',Properties:{level:'10'}}");
        BlockIdConverter.register(139, "{Name:'minecraft:water',Properties:{level:'11'}}");
        BlockIdConverter.register(140, "{Name:'minecraft:water',Properties:{level:'12'}}");
        BlockIdConverter.register(141, "{Name:'minecraft:water',Properties:{level:'13'}}");
        BlockIdConverter.register(142, "{Name:'minecraft:water',Properties:{level:'14'}}");
        BlockIdConverter.register(143, "{Name:'minecraft:water',Properties:{level:'15'}}");
        BlockIdConverter.register(144, "{Name:'minecraft:water',Properties:{level:'0'}}");
        BlockIdConverter.register(145, "{Name:'minecraft:water',Properties:{level:'1'}}");
        BlockIdConverter.register(146, "{Name:'minecraft:water',Properties:{level:'2'}}");
        BlockIdConverter.register(147, "{Name:'minecraft:water',Properties:{level:'3'}}");
        BlockIdConverter.register(148, "{Name:'minecraft:water',Properties:{level:'4'}}");
        BlockIdConverter.register(149, "{Name:'minecraft:water',Properties:{level:'5'}}");
        BlockIdConverter.register(150, "{Name:'minecraft:water',Properties:{level:'6'}}");
        BlockIdConverter.register(151, "{Name:'minecraft:water',Properties:{level:'7'}}");
        BlockIdConverter.register(152, "{Name:'minecraft:water',Properties:{level:'8'}}");
        BlockIdConverter.register(153, "{Name:'minecraft:water',Properties:{level:'9'}}");
        BlockIdConverter.register(154, "{Name:'minecraft:water',Properties:{level:'10'}}");
        BlockIdConverter.register(155, "{Name:'minecraft:water',Properties:{level:'11'}}");
        BlockIdConverter.register(156, "{Name:'minecraft:water',Properties:{level:'12'}}");
        BlockIdConverter.register(157, "{Name:'minecraft:water',Properties:{level:'13'}}");
        BlockIdConverter.register(158, "{Name:'minecraft:water',Properties:{level:'14'}}");
        BlockIdConverter.register(159, "{Name:'minecraft:water',Properties:{level:'15'}}");
        BlockIdConverter.register(160, "{Name:'minecraft:lava',Properties:{level:'0'}}");
        BlockIdConverter.register(161, "{Name:'minecraft:lava',Properties:{level:'1'}}");
        BlockIdConverter.register(162, "{Name:'minecraft:lava',Properties:{level:'2'}}");
        BlockIdConverter.register(163, "{Name:'minecraft:lava',Properties:{level:'3'}}");
        BlockIdConverter.register(164, "{Name:'minecraft:lava',Properties:{level:'4'}}");
        BlockIdConverter.register(165, "{Name:'minecraft:lava',Properties:{level:'5'}}");
        BlockIdConverter.register(166, "{Name:'minecraft:lava',Properties:{level:'6'}}");
        BlockIdConverter.register(167, "{Name:'minecraft:lava',Properties:{level:'7'}}");
        BlockIdConverter.register(168, "{Name:'minecraft:lava',Properties:{level:'8'}}");
        BlockIdConverter.register(169, "{Name:'minecraft:lava',Properties:{level:'9'}}");
        BlockIdConverter.register(170, "{Name:'minecraft:lava',Properties:{level:'10'}}");
        BlockIdConverter.register(171, "{Name:'minecraft:lava',Properties:{level:'11'}}");
        BlockIdConverter.register(172, "{Name:'minecraft:lava',Properties:{level:'12'}}");
        BlockIdConverter.register(173, "{Name:'minecraft:lava',Properties:{level:'13'}}");
        BlockIdConverter.register(174, "{Name:'minecraft:lava',Properties:{level:'14'}}");
        BlockIdConverter.register(175, "{Name:'minecraft:lava',Properties:{level:'15'}}");
        BlockIdConverter.register(176, "{Name:'minecraft:lava',Properties:{level:'0'}}");
        BlockIdConverter.register(177, "{Name:'minecraft:lava',Properties:{level:'1'}}");
        BlockIdConverter.register(178, "{Name:'minecraft:lava',Properties:{level:'2'}}");
        BlockIdConverter.register(179, "{Name:'minecraft:lava',Properties:{level:'3'}}");
        BlockIdConverter.register(180, "{Name:'minecraft:lava',Properties:{level:'4'}}");
        BlockIdConverter.register(181, "{Name:'minecraft:lava',Properties:{level:'5'}}");
        BlockIdConverter.register(182, "{Name:'minecraft:lava',Properties:{level:'6'}}");
        BlockIdConverter.register(183, "{Name:'minecraft:lava',Properties:{level:'7'}}");
        BlockIdConverter.register(184, "{Name:'minecraft:lava',Properties:{level:'8'}}");
        BlockIdConverter.register(185, "{Name:'minecraft:lava',Properties:{level:'9'}}");
        BlockIdConverter.register(186, "{Name:'minecraft:lava',Properties:{level:'10'}}");
        BlockIdConverter.register(187, "{Name:'minecraft:lava',Properties:{level:'11'}}");
        BlockIdConverter.register(188, "{Name:'minecraft:lava',Properties:{level:'12'}}");
        BlockIdConverter.register(189, "{Name:'minecraft:lava',Properties:{level:'13'}}");
        BlockIdConverter.register(190, "{Name:'minecraft:lava',Properties:{level:'14'}}");
        BlockIdConverter.register(191, "{Name:'minecraft:lava',Properties:{level:'15'}}");
        BlockIdConverter.register(192, "{Name:'minecraft:sand'}");
        BlockIdConverter.register(193, "{Name:'minecraft:red_sand'}");
        BlockIdConverter.register(208, "{Name:'minecraft:gravel'}");
        BlockIdConverter.register(224, "{Name:'minecraft:gold_ore'}");
        BlockIdConverter.register(240, "{Name:'minecraft:iron_ore'}");
        BlockIdConverter.register(256, "{Name:'minecraft:coal_ore'}");
        BlockIdConverter.register(272, "{Name:'minecraft:oak_log',Properties:{axis:'y'}}");
        BlockIdConverter.register(273, "{Name:'minecraft:spruce_log',Properties:{axis:'y'}}");
        BlockIdConverter.register(274, "{Name:'minecraft:birch_log',Properties:{axis:'y'}}");
        BlockIdConverter.register(275, "{Name:'minecraft:jungle_log',Properties:{axis:'y'}}");
        BlockIdConverter.register(276, "{Name:'minecraft:oak_log',Properties:{axis:'x'}}");
        BlockIdConverter.register(277, "{Name:'minecraft:spruce_log',Properties:{axis:'x'}}");
        BlockIdConverter.register(278, "{Name:'minecraft:birch_log',Properties:{axis:'x'}}");
        BlockIdConverter.register(279, "{Name:'minecraft:jungle_log',Properties:{axis:'x'}}");
        BlockIdConverter.register(280, "{Name:'minecraft:oak_log',Properties:{axis:'z'}}");
        BlockIdConverter.register(281, "{Name:'minecraft:spruce_log',Properties:{axis:'z'}}");
        BlockIdConverter.register(282, "{Name:'minecraft:birch_log',Properties:{axis:'z'}}");
        BlockIdConverter.register(283, "{Name:'minecraft:jungle_log',Properties:{axis:'z'}}");
        BlockIdConverter.register(284, "{Name:'minecraft:oak_bark'}");
        BlockIdConverter.register(285, "{Name:'minecraft:spruce_bark'}");
        BlockIdConverter.register(286, "{Name:'minecraft:birch_bark'}");
        BlockIdConverter.register(287, "{Name:'minecraft:jungle_bark'}");
        BlockIdConverter.register(288, "{Name:'minecraft:oak_leaves',Properties:{check_decay:'false',decayable:'true'}}");
        BlockIdConverter.register(289, "{Name:'minecraft:spruce_leaves',Properties:{check_decay:'false',decayable:'true'}}");
        BlockIdConverter.register(290, "{Name:'minecraft:birch_leaves',Properties:{check_decay:'false',decayable:'true'}}");
        BlockIdConverter.register(291, "{Name:'minecraft:jungle_leaves',Properties:{check_decay:'false',decayable:'true'}}");
        BlockIdConverter.register(292, "{Name:'minecraft:oak_leaves',Properties:{check_decay:'false',decayable:'false'}}");
        BlockIdConverter.register(293, "{Name:'minecraft:spruce_leaves',Properties:{check_decay:'false',decayable:'false'}}");
        BlockIdConverter.register(294, "{Name:'minecraft:birch_leaves',Properties:{check_decay:'false',decayable:'false'}}");
        BlockIdConverter.register(295, "{Name:'minecraft:jungle_leaves',Properties:{check_decay:'false',decayable:'false'}}");
        BlockIdConverter.register(296, "{Name:'minecraft:oak_leaves',Properties:{check_decay:'true',decayable:'true'}}");
        BlockIdConverter.register(297, "{Name:'minecraft:spruce_leaves',Properties:{check_decay:'true',decayable:'true'}}");
        BlockIdConverter.register(298, "{Name:'minecraft:birch_leaves',Properties:{check_decay:'true',decayable:'true'}}");
        BlockIdConverter.register(299, "{Name:'minecraft:jungle_leaves',Properties:{check_decay:'true',decayable:'true'}}");
        BlockIdConverter.register(300, "{Name:'minecraft:oak_leaves',Properties:{check_decay:'true',decayable:'false'}}");
        BlockIdConverter.register(301, "{Name:'minecraft:spruce_leaves',Properties:{check_decay:'true',decayable:'false'}}");
        BlockIdConverter.register(302, "{Name:'minecraft:birch_leaves',Properties:{check_decay:'true',decayable:'false'}}");
        BlockIdConverter.register(303, "{Name:'minecraft:jungle_leaves',Properties:{check_decay:'true',decayable:'false'}}");
        BlockIdConverter.register(304, "{Name:'minecraft:sponge'}");
        BlockIdConverter.register(305, "{Name:'minecraft:wet_sponge'}");
        BlockIdConverter.register(320, "{Name:'minecraft:glass'}");
        BlockIdConverter.register(336, "{Name:'minecraft:lapis_ore'}");
        BlockIdConverter.register(352, "{Name:'minecraft:lapis_block'}");
        BlockIdConverter.register(368, "{Name:'minecraft:dispenser',Properties:{facing:'down',triggered:'false'}}");
        BlockIdConverter.register(369, "{Name:'minecraft:dispenser',Properties:{facing:'up',triggered:'false'}}");
        BlockIdConverter.register(370, "{Name:'minecraft:dispenser',Properties:{facing:'north',triggered:'false'}}");
        BlockIdConverter.register(371, "{Name:'minecraft:dispenser',Properties:{facing:'south',triggered:'false'}}");
        BlockIdConverter.register(372, "{Name:'minecraft:dispenser',Properties:{facing:'west',triggered:'false'}}");
        BlockIdConverter.register(373, "{Name:'minecraft:dispenser',Properties:{facing:'east',triggered:'false'}}");
        BlockIdConverter.register(376, "{Name:'minecraft:dispenser',Properties:{facing:'down',triggered:'true'}}");
        BlockIdConverter.register(377, "{Name:'minecraft:dispenser',Properties:{facing:'up',triggered:'true'}}");
        BlockIdConverter.register(378, "{Name:'minecraft:dispenser',Properties:{facing:'north',triggered:'true'}}");
        BlockIdConverter.register(379, "{Name:'minecraft:dispenser',Properties:{facing:'south',triggered:'true'}}");
        BlockIdConverter.register(380, "{Name:'minecraft:dispenser',Properties:{facing:'west',triggered:'true'}}");
        BlockIdConverter.register(381, "{Name:'minecraft:dispenser',Properties:{facing:'east',triggered:'true'}}");
        BlockIdConverter.register(384, "{Name:'minecraft:sandstone'}");
        BlockIdConverter.register(385, "{Name:'minecraft:chiseled_sandstone'}");
        BlockIdConverter.register(386, "{Name:'minecraft:cut_sandstone'}");
        BlockIdConverter.register(400, "{Name:'minecraft:note_block'}");
        BlockIdConverter.register(416, "{Name:'minecraft:red_bed',Properties:{facing:'south',occupied:'false',part:'foot'}}");
        BlockIdConverter.register(417, "{Name:'minecraft:red_bed',Properties:{facing:'west',occupied:'false',part:'foot'}}");
        BlockIdConverter.register(418, "{Name:'minecraft:red_bed',Properties:{facing:'north',occupied:'false',part:'foot'}}");
        BlockIdConverter.register(419, "{Name:'minecraft:red_bed',Properties:{facing:'east',occupied:'false',part:'foot'}}");
        BlockIdConverter.register(424, "{Name:'minecraft:red_bed',Properties:{facing:'south',occupied:'false',part:'head'}}");
        BlockIdConverter.register(425, "{Name:'minecraft:red_bed',Properties:{facing:'west',occupied:'false',part:'head'}}");
        BlockIdConverter.register(426, "{Name:'minecraft:red_bed',Properties:{facing:'north',occupied:'false',part:'head'}}");
        BlockIdConverter.register(427, "{Name:'minecraft:red_bed',Properties:{facing:'east',occupied:'false',part:'head'}}");
        BlockIdConverter.register(428, "{Name:'minecraft:red_bed',Properties:{facing:'south',occupied:'true',part:'head'}}");
        BlockIdConverter.register(429, "{Name:'minecraft:red_bed',Properties:{facing:'west',occupied:'true',part:'head'}}");
        BlockIdConverter.register(430, "{Name:'minecraft:red_bed',Properties:{facing:'north',occupied:'true',part:'head'}}");
        BlockIdConverter.register(431, "{Name:'minecraft:red_bed',Properties:{facing:'east',occupied:'true',part:'head'}}");
        BlockIdConverter.register(432, "{Name:'minecraft:powered_rail',Properties:{powered:'false',shape:'north_south'}}");
        BlockIdConverter.register(433, "{Name:'minecraft:powered_rail',Properties:{powered:'false',shape:'east_west'}}");
        BlockIdConverter.register(434, "{Name:'minecraft:powered_rail',Properties:{powered:'false',shape:'ascending_east'}}");
        BlockIdConverter.register(435, "{Name:'minecraft:powered_rail',Properties:{powered:'false',shape:'ascending_west'}}");
        BlockIdConverter.register(436, "{Name:'minecraft:powered_rail',Properties:{powered:'false',shape:'ascending_north'}}");
        BlockIdConverter.register(437, "{Name:'minecraft:powered_rail',Properties:{powered:'false',shape:'ascending_south'}}");
        BlockIdConverter.register(440, "{Name:'minecraft:powered_rail',Properties:{powered:'true',shape:'north_south'}}");
        BlockIdConverter.register(441, "{Name:'minecraft:powered_rail',Properties:{powered:'true',shape:'east_west'}}");
        BlockIdConverter.register(442, "{Name:'minecraft:powered_rail',Properties:{powered:'true',shape:'ascending_east'}}");
        BlockIdConverter.register(443, "{Name:'minecraft:powered_rail',Properties:{powered:'true',shape:'ascending_west'}}");
        BlockIdConverter.register(444, "{Name:'minecraft:powered_rail',Properties:{powered:'true',shape:'ascending_north'}}");
        BlockIdConverter.register(445, "{Name:'minecraft:powered_rail',Properties:{powered:'true',shape:'ascending_south'}}");
        BlockIdConverter.register(448, "{Name:'minecraft:detector_rail',Properties:{powered:'false',shape:'north_south'}}");
        BlockIdConverter.register(449, "{Name:'minecraft:detector_rail',Properties:{powered:'false',shape:'east_west'}}");
        BlockIdConverter.register(450, "{Name:'minecraft:detector_rail',Properties:{powered:'false',shape:'ascending_east'}}");
        BlockIdConverter.register(451, "{Name:'minecraft:detector_rail',Properties:{powered:'false',shape:'ascending_west'}}");
        BlockIdConverter.register(452, "{Name:'minecraft:detector_rail',Properties:{powered:'false',shape:'ascending_north'}}");
        BlockIdConverter.register(453, "{Name:'minecraft:detector_rail',Properties:{powered:'false',shape:'ascending_south'}}");
        BlockIdConverter.register(456, "{Name:'minecraft:detector_rail',Properties:{powered:'true',shape:'north_south'}}");
        BlockIdConverter.register(457, "{Name:'minecraft:detector_rail',Properties:{powered:'true',shape:'east_west'}}");
        BlockIdConverter.register(458, "{Name:'minecraft:detector_rail',Properties:{powered:'true',shape:'ascending_east'}}");
        BlockIdConverter.register(459, "{Name:'minecraft:detector_rail',Properties:{powered:'true',shape:'ascending_west'}}");
        BlockIdConverter.register(460, "{Name:'minecraft:detector_rail',Properties:{powered:'true',shape:'ascending_north'}}");
        BlockIdConverter.register(461, "{Name:'minecraft:detector_rail',Properties:{powered:'true',shape:'ascending_south'}}");
        BlockIdConverter.register(464, "{Name:'minecraft:sticky_piston',Properties:{extended:'false',facing:'down'}}");
        BlockIdConverter.register(465, "{Name:'minecraft:sticky_piston',Properties:{extended:'false',facing:'up'}}");
        BlockIdConverter.register(466, "{Name:'minecraft:sticky_piston',Properties:{extended:'false',facing:'north'}}");
        BlockIdConverter.register(467, "{Name:'minecraft:sticky_piston',Properties:{extended:'false',facing:'south'}}");
        BlockIdConverter.register(468, "{Name:'minecraft:sticky_piston',Properties:{extended:'false',facing:'west'}}");
        BlockIdConverter.register(469, "{Name:'minecraft:sticky_piston',Properties:{extended:'false',facing:'east'}}");
        BlockIdConverter.register(472, "{Name:'minecraft:sticky_piston',Properties:{extended:'true',facing:'down'}}");
        BlockIdConverter.register(473, "{Name:'minecraft:sticky_piston',Properties:{extended:'true',facing:'up'}}");
        BlockIdConverter.register(474, "{Name:'minecraft:sticky_piston',Properties:{extended:'true',facing:'north'}}");
        BlockIdConverter.register(475, "{Name:'minecraft:sticky_piston',Properties:{extended:'true',facing:'south'}}");
        BlockIdConverter.register(476, "{Name:'minecraft:sticky_piston',Properties:{extended:'true',facing:'west'}}");
        BlockIdConverter.register(477, "{Name:'minecraft:sticky_piston',Properties:{extended:'true',facing:'east'}}");
        BlockIdConverter.register(480, "{Name:'minecraft:cobweb'}");
        BlockIdConverter.register(496, "{Name:'minecraft:dead_bush'}");
        BlockIdConverter.register(497, "{Name:'minecraft:grass'}");
        BlockIdConverter.register(498, "{Name:'minecraft:fern'}");
        BlockIdConverter.register(512, "{Name:'minecraft:dead_bush'}");
        BlockIdConverter.register(528, "{Name:'minecraft:piston',Properties:{extended:'false',facing:'down'}}");
        BlockIdConverter.register(529, "{Name:'minecraft:piston',Properties:{extended:'false',facing:'up'}}");
        BlockIdConverter.register(530, "{Name:'minecraft:piston',Properties:{extended:'false',facing:'north'}}");
        BlockIdConverter.register(531, "{Name:'minecraft:piston',Properties:{extended:'false',facing:'south'}}");
        BlockIdConverter.register(532, "{Name:'minecraft:piston',Properties:{extended:'false',facing:'west'}}");
        BlockIdConverter.register(533, "{Name:'minecraft:piston',Properties:{extended:'false',facing:'east'}}");
        BlockIdConverter.register(536, "{Name:'minecraft:piston',Properties:{extended:'true',facing:'down'}}");
        BlockIdConverter.register(537, "{Name:'minecraft:piston',Properties:{extended:'true',facing:'up'}}");
        BlockIdConverter.register(538, "{Name:'minecraft:piston',Properties:{extended:'true',facing:'north'}}");
        BlockIdConverter.register(539, "{Name:'minecraft:piston',Properties:{extended:'true',facing:'south'}}");
        BlockIdConverter.register(540, "{Name:'minecraft:piston',Properties:{extended:'true',facing:'west'}}");
        BlockIdConverter.register(541, "{Name:'minecraft:piston',Properties:{extended:'true',facing:'east'}}");
        BlockIdConverter.register(544, "{Name:'minecraft:piston_head',Properties:{facing:'down',short:'false',type:'normal'}}");
        BlockIdConverter.register(545, "{Name:'minecraft:piston_head',Properties:{facing:'up',short:'false',type:'normal'}}");
        BlockIdConverter.register(546, "{Name:'minecraft:piston_head',Properties:{facing:'north',short:'false',type:'normal'}}");
        BlockIdConverter.register(547, "{Name:'minecraft:piston_head',Properties:{facing:'south',short:'false',type:'normal'}}");
        BlockIdConverter.register(548, "{Name:'minecraft:piston_head',Properties:{facing:'west',short:'false',type:'normal'}}");
        BlockIdConverter.register(549, "{Name:'minecraft:piston_head',Properties:{facing:'east',short:'false',type:'normal'}}");
        BlockIdConverter.register(552, "{Name:'minecraft:piston_head',Properties:{facing:'down',short:'false',type:'sticky'}}");
        BlockIdConverter.register(553, "{Name:'minecraft:piston_head',Properties:{facing:'up',short:'false',type:'sticky'}}");
        BlockIdConverter.register(554, "{Name:'minecraft:piston_head',Properties:{facing:'north',short:'false',type:'sticky'}}");
        BlockIdConverter.register(555, "{Name:'minecraft:piston_head',Properties:{facing:'south',short:'false',type:'sticky'}}");
        BlockIdConverter.register(556, "{Name:'minecraft:piston_head',Properties:{facing:'west',short:'false',type:'sticky'}}");
        BlockIdConverter.register(557, "{Name:'minecraft:piston_head',Properties:{facing:'east',short:'false',type:'sticky'}}");
        BlockIdConverter.register(560, "{Name:'minecraft:white_wool'}");
        BlockIdConverter.register(561, "{Name:'minecraft:orange_wool'}");
        BlockIdConverter.register(562, "{Name:'minecraft:magenta_wool'}");
        BlockIdConverter.register(563, "{Name:'minecraft:light_blue_wool'}");
        BlockIdConverter.register(564, "{Name:'minecraft:yellow_wool'}");
        BlockIdConverter.register(565, "{Name:'minecraft:lime_wool'}");
        BlockIdConverter.register(566, "{Name:'minecraft:pink_wool'}");
        BlockIdConverter.register(567, "{Name:'minecraft:gray_wool'}");
        BlockIdConverter.register(568, "{Name:'minecraft:light_gray_wool'}");
        BlockIdConverter.register(569, "{Name:'minecraft:cyan_wool'}");
        BlockIdConverter.register(570, "{Name:'minecraft:purple_wool'}");
        BlockIdConverter.register(571, "{Name:'minecraft:blue_wool'}");
        BlockIdConverter.register(572, "{Name:'minecraft:brown_wool'}");
        BlockIdConverter.register(573, "{Name:'minecraft:green_wool'}");
        BlockIdConverter.register(574, "{Name:'minecraft:red_wool'}");
        BlockIdConverter.register(575, "{Name:'minecraft:black_wool'}");
        BlockIdConverter.register(576, "{Name:'minecraft:moving_piston',Properties:{facing:'down',type:'normal'}}");
        BlockIdConverter.register(577, "{Name:'minecraft:moving_piston',Properties:{facing:'up',type:'normal'}}");
        BlockIdConverter.register(578, "{Name:'minecraft:moving_piston',Properties:{facing:'north',type:'normal'}}");
        BlockIdConverter.register(579, "{Name:'minecraft:moving_piston',Properties:{facing:'south',type:'normal'}}");
        BlockIdConverter.register(580, "{Name:'minecraft:moving_piston',Properties:{facing:'west',type:'normal'}}");
        BlockIdConverter.register(581, "{Name:'minecraft:moving_piston',Properties:{facing:'east',type:'normal'}}");
        BlockIdConverter.register(584, "{Name:'minecraft:moving_piston',Properties:{facing:'down',type:'sticky'}}");
        BlockIdConverter.register(585, "{Name:'minecraft:moving_piston',Properties:{facing:'up',type:'sticky'}}");
        BlockIdConverter.register(586, "{Name:'minecraft:moving_piston',Properties:{facing:'north',type:'sticky'}}");
        BlockIdConverter.register(587, "{Name:'minecraft:moving_piston',Properties:{facing:'south',type:'sticky'}}");
        BlockIdConverter.register(588, "{Name:'minecraft:moving_piston',Properties:{facing:'west',type:'sticky'}}");
        BlockIdConverter.register(589, "{Name:'minecraft:moving_piston',Properties:{facing:'east',type:'sticky'}}");
        BlockIdConverter.register(592, "{Name:'minecraft:dandelion'}");
        BlockIdConverter.register(608, "{Name:'minecraft:poppy'}");
        BlockIdConverter.register(609, "{Name:'minecraft:blue_orchid'}");
        BlockIdConverter.register(610, "{Name:'minecraft:allium'}");
        BlockIdConverter.register(611, "{Name:'minecraft:azure_bluet'}");
        BlockIdConverter.register(612, "{Name:'minecraft:red_tulip'}");
        BlockIdConverter.register(613, "{Name:'minecraft:orange_tulip'}");
        BlockIdConverter.register(614, "{Name:'minecraft:white_tulip'}");
        BlockIdConverter.register(615, "{Name:'minecraft:pink_tulip'}");
        BlockIdConverter.register(616, "{Name:'minecraft:oxeye_daisy'}");
        BlockIdConverter.register(624, "{Name:'minecraft:brown_mushroom'}");
        BlockIdConverter.register(640, "{Name:'minecraft:red_mushroom'}");
        BlockIdConverter.register(656, "{Name:'minecraft:gold_block'}");
        BlockIdConverter.register(672, "{Name:'minecraft:iron_block'}");
        BlockIdConverter.register(688, "{Name:'minecraft:stone_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(689, "{Name:'minecraft:sandstone_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(690, "{Name:'minecraft:petrified_oak_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(691, "{Name:'minecraft:cobblestone_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(692, "{Name:'minecraft:brick_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(693, "{Name:'minecraft:stone_brick_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(694, "{Name:'minecraft:nether_brick_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(695, "{Name:'minecraft:quartz_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(696, "{Name:'minecraft:smooth_stone'}");
        BlockIdConverter.register(697, "{Name:'minecraft:smooth_sandstone'}");
        BlockIdConverter.register(698, "{Name:'minecraft:petrified_oak_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(699, "{Name:'minecraft:cobblestone_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(700, "{Name:'minecraft:brick_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(701, "{Name:'minecraft:stone_brick_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(702, "{Name:'minecraft:nether_brick_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(703, "{Name:'minecraft:smooth_quartz'}");
        BlockIdConverter.register(704, "{Name:'minecraft:stone_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(705, "{Name:'minecraft:sandstone_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(706, "{Name:'minecraft:petrified_oak_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(707, "{Name:'minecraft:cobblestone_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(708, "{Name:'minecraft:brick_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(709, "{Name:'minecraft:stone_brick_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(710, "{Name:'minecraft:nether_brick_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(711, "{Name:'minecraft:quartz_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(712, "{Name:'minecraft:stone_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(713, "{Name:'minecraft:sandstone_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(714, "{Name:'minecraft:petrified_oak_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(715, "{Name:'minecraft:cobblestone_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(716, "{Name:'minecraft:brick_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(717, "{Name:'minecraft:stone_brick_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(718, "{Name:'minecraft:nether_brick_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(719, "{Name:'minecraft:quartz_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(720, "{Name:'minecraft:bricks'}");
        BlockIdConverter.register(736, "{Name:'minecraft:tnt',Properties:{unstable:'false'}}");
        BlockIdConverter.register(737, "{Name:'minecraft:tnt',Properties:{unstable:'true'}}");
        BlockIdConverter.register(752, "{Name:'minecraft:bookshelf'}");
        BlockIdConverter.register(768, "{Name:'minecraft:mossy_cobblestone'}");
        BlockIdConverter.register(784, "{Name:'minecraft:obsidian'}");
        BlockIdConverter.register(801, "{Name:'minecraft:wall_torch',Properties:{facing:'east'}}");
        BlockIdConverter.register(802, "{Name:'minecraft:wall_torch',Properties:{facing:'west'}}");
        BlockIdConverter.register(803, "{Name:'minecraft:wall_torch',Properties:{facing:'south'}}");
        BlockIdConverter.register(804, "{Name:'minecraft:wall_torch',Properties:{facing:'north'}}");
        BlockIdConverter.register(805, "{Name:'minecraft:torch'}");
        BlockIdConverter.register(816, "{Name:'minecraft:fire',Properties:{age:'0',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(817, "{Name:'minecraft:fire',Properties:{age:'1',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(818, "{Name:'minecraft:fire',Properties:{age:'2',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(819, "{Name:'minecraft:fire',Properties:{age:'3',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(820, "{Name:'minecraft:fire',Properties:{age:'4',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(821, "{Name:'minecraft:fire',Properties:{age:'5',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(822, "{Name:'minecraft:fire',Properties:{age:'6',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(823, "{Name:'minecraft:fire',Properties:{age:'7',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(824, "{Name:'minecraft:fire',Properties:{age:'8',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(825, "{Name:'minecraft:fire',Properties:{age:'9',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(826, "{Name:'minecraft:fire',Properties:{age:'10',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(827, "{Name:'minecraft:fire',Properties:{age:'11',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(828, "{Name:'minecraft:fire',Properties:{age:'12',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(829, "{Name:'minecraft:fire',Properties:{age:'13',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(830, "{Name:'minecraft:fire',Properties:{age:'14',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(831, "{Name:'minecraft:fire',Properties:{age:'15',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(832, "{Name:'minecraft:mob_spawner'}");
        BlockIdConverter.register(848, "{Name:'minecraft:oak_stairs',Properties:{facing:'east',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(849, "{Name:'minecraft:oak_stairs',Properties:{facing:'west',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(850, "{Name:'minecraft:oak_stairs',Properties:{facing:'south',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(851, "{Name:'minecraft:oak_stairs',Properties:{facing:'north',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(852, "{Name:'minecraft:oak_stairs',Properties:{facing:'east',half:'top',shape:'straight'}}");
        BlockIdConverter.register(853, "{Name:'minecraft:oak_stairs',Properties:{facing:'west',half:'top',shape:'straight'}}");
        BlockIdConverter.register(854, "{Name:'minecraft:oak_stairs',Properties:{facing:'south',half:'top',shape:'straight'}}");
        BlockIdConverter.register(855, "{Name:'minecraft:oak_stairs',Properties:{facing:'north',half:'top',shape:'straight'}}");
        BlockIdConverter.register(866, "{Name:'minecraft:chest',Properties:{facing:'north',type:'single'}}");
        BlockIdConverter.register(867, "{Name:'minecraft:chest',Properties:{facing:'south',type:'single'}}");
        BlockIdConverter.register(868, "{Name:'minecraft:chest',Properties:{facing:'west',type:'single'}}");
        BlockIdConverter.register(869, "{Name:'minecraft:chest',Properties:{facing:'east',type:'single'}}");
        BlockIdConverter.register(880, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'0',south:'none',west:'none'}}");
        BlockIdConverter.register(881, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'1',south:'none',west:'none'}}");
        BlockIdConverter.register(882, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'2',south:'none',west:'none'}}");
        BlockIdConverter.register(883, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'3',south:'none',west:'none'}}");
        BlockIdConverter.register(884, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'4',south:'none',west:'none'}}");
        BlockIdConverter.register(885, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'5',south:'none',west:'none'}}");
        BlockIdConverter.register(886, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'6',south:'none',west:'none'}}");
        BlockIdConverter.register(887, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'7',south:'none',west:'none'}}");
        BlockIdConverter.register(888, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'8',south:'none',west:'none'}}");
        BlockIdConverter.register(889, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'9',south:'none',west:'none'}}");
        BlockIdConverter.register(890, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'10',south:'none',west:'none'}}");
        BlockIdConverter.register(891, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'11',south:'none',west:'none'}}");
        BlockIdConverter.register(892, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'12',south:'none',west:'none'}}");
        BlockIdConverter.register(893, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'13',south:'none',west:'none'}}");
        BlockIdConverter.register(894, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'14',south:'none',west:'none'}}");
        BlockIdConverter.register(895, "{Name:'minecraft:redstone_wire',Properties:{east:'none',north:'none',power:'15',south:'none',west:'none'}}");
        BlockIdConverter.register(896, "{Name:'minecraft:diamond_ore'}");
        BlockIdConverter.register(912, "{Name:'minecraft:diamond_block'}");
        BlockIdConverter.register(928, "{Name:'minecraft:crafting_table'}");
        BlockIdConverter.register(944, "{Name:'minecraft:wheat',Properties:{age:'0'}}");
        BlockIdConverter.register(945, "{Name:'minecraft:wheat',Properties:{age:'1'}}");
        BlockIdConverter.register(946, "{Name:'minecraft:wheat',Properties:{age:'2'}}");
        BlockIdConverter.register(947, "{Name:'minecraft:wheat',Properties:{age:'3'}}");
        BlockIdConverter.register(948, "{Name:'minecraft:wheat',Properties:{age:'4'}}");
        BlockIdConverter.register(949, "{Name:'minecraft:wheat',Properties:{age:'5'}}");
        BlockIdConverter.register(950, "{Name:'minecraft:wheat',Properties:{age:'6'}}");
        BlockIdConverter.register(951, "{Name:'minecraft:wheat',Properties:{age:'7'}}");
        BlockIdConverter.register(960, "{Name:'minecraft:farmland',Properties:{moisture:'0'}}");
        BlockIdConverter.register(961, "{Name:'minecraft:farmland',Properties:{moisture:'1'}}");
        BlockIdConverter.register(962, "{Name:'minecraft:farmland',Properties:{moisture:'2'}}");
        BlockIdConverter.register(963, "{Name:'minecraft:farmland',Properties:{moisture:'3'}}");
        BlockIdConverter.register(964, "{Name:'minecraft:farmland',Properties:{moisture:'4'}}");
        BlockIdConverter.register(965, "{Name:'minecraft:farmland',Properties:{moisture:'5'}}");
        BlockIdConverter.register(966, "{Name:'minecraft:farmland',Properties:{moisture:'6'}}");
        BlockIdConverter.register(967, "{Name:'minecraft:farmland',Properties:{moisture:'7'}}");
        BlockIdConverter.register(978, "{Name:'minecraft:furnace',Properties:{facing:'north',lit:'false'}}");
        BlockIdConverter.register(979, "{Name:'minecraft:furnace',Properties:{facing:'south',lit:'false'}}");
        BlockIdConverter.register(980, "{Name:'minecraft:furnace',Properties:{facing:'west',lit:'false'}}");
        BlockIdConverter.register(981, "{Name:'minecraft:furnace',Properties:{facing:'east',lit:'false'}}");
        BlockIdConverter.register(994, "{Name:'minecraft:furnace',Properties:{facing:'north',lit:'true'}}");
        BlockIdConverter.register(995, "{Name:'minecraft:furnace',Properties:{facing:'south',lit:'true'}}");
        BlockIdConverter.register(996, "{Name:'minecraft:furnace',Properties:{facing:'west',lit:'true'}}");
        BlockIdConverter.register(997, "{Name:'minecraft:furnace',Properties:{facing:'east',lit:'true'}}");
        BlockIdConverter.register(1008, "{Name:'minecraft:sign',Properties:{rotation:'0'}}");
        BlockIdConverter.register(1009, "{Name:'minecraft:sign',Properties:{rotation:'1'}}");
        BlockIdConverter.register(1010, "{Name:'minecraft:sign',Properties:{rotation:'2'}}");
        BlockIdConverter.register(1011, "{Name:'minecraft:sign',Properties:{rotation:'3'}}");
        BlockIdConverter.register(1012, "{Name:'minecraft:sign',Properties:{rotation:'4'}}");
        BlockIdConverter.register(1013, "{Name:'minecraft:sign',Properties:{rotation:'5'}}");
        BlockIdConverter.register(1014, "{Name:'minecraft:sign',Properties:{rotation:'6'}}");
        BlockIdConverter.register(1015, "{Name:'minecraft:sign',Properties:{rotation:'7'}}");
        BlockIdConverter.register(1016, "{Name:'minecraft:sign',Properties:{rotation:'8'}}");
        BlockIdConverter.register(1017, "{Name:'minecraft:sign',Properties:{rotation:'9'}}");
        BlockIdConverter.register(1018, "{Name:'minecraft:sign',Properties:{rotation:'10'}}");
        BlockIdConverter.register(1019, "{Name:'minecraft:sign',Properties:{rotation:'11'}}");
        BlockIdConverter.register(1020, "{Name:'minecraft:sign',Properties:{rotation:'12'}}");
        BlockIdConverter.register(1021, "{Name:'minecraft:sign',Properties:{rotation:'13'}}");
        BlockIdConverter.register(1022, "{Name:'minecraft:sign',Properties:{rotation:'14'}}");
        BlockIdConverter.register(1023, "{Name:'minecraft:sign',Properties:{rotation:'15'}}");
        BlockIdConverter.register(1024, "{Name:'minecraft:oak_door',Properties:{facing:'east',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(1025, "{Name:'minecraft:oak_door',Properties:{facing:'south',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(1026, "{Name:'minecraft:oak_door',Properties:{facing:'west',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(1027, "{Name:'minecraft:oak_door',Properties:{facing:'north',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(1028, "{Name:'minecraft:oak_door',Properties:{facing:'east',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(1029, "{Name:'minecraft:oak_door',Properties:{facing:'south',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(1030, "{Name:'minecraft:oak_door',Properties:{facing:'west',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(1031, "{Name:'minecraft:oak_door',Properties:{facing:'north',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(1032, "{Name:'minecraft:oak_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'false',powered:'false'}}");
        BlockIdConverter.register(1033, "{Name:'minecraft:oak_door',Properties:{facing:'east',half:'upper',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(1034, "{Name:'minecraft:oak_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'false',powered:'true'}}");
        BlockIdConverter.register(1035, "{Name:'minecraft:oak_door',Properties:{facing:'east',half:'upper',hinge:'right',open:'false',powered:'true'}}");
        BlockIdConverter.register(1036, "{Name:'minecraft:oak_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'true',powered:'false'}}");
        BlockIdConverter.register(1037, "{Name:'minecraft:oak_door',Properties:{facing:'south',half:'upper',hinge:'left',open:'true',powered:'false'}}");
        BlockIdConverter.register(1038, "{Name:'minecraft:oak_door',Properties:{facing:'west',half:'upper',hinge:'left',open:'true',powered:'false'}}");
        BlockIdConverter.register(1039, "{Name:'minecraft:oak_door',Properties:{facing:'north',half:'upper',hinge:'left',open:'true',powered:'false'}}");
        BlockIdConverter.register(1042, "{Name:'minecraft:ladder',Properties:{facing:'north'}}");
        BlockIdConverter.register(1043, "{Name:'minecraft:ladder',Properties:{facing:'south'}}");
        BlockIdConverter.register(1044, "{Name:'minecraft:ladder',Properties:{facing:'west'}}");
        BlockIdConverter.register(1045, "{Name:'minecraft:ladder',Properties:{facing:'east'}}");
        BlockIdConverter.register(1056, "{Name:'minecraft:rail',Properties:{shape:'north_south'}}");
        BlockIdConverter.register(1057, "{Name:'minecraft:rail',Properties:{shape:'east_west'}}");
        BlockIdConverter.register(1058, "{Name:'minecraft:rail',Properties:{shape:'ascending_east'}}");
        BlockIdConverter.register(1059, "{Name:'minecraft:rail',Properties:{shape:'ascending_west'}}");
        BlockIdConverter.register(1060, "{Name:'minecraft:rail',Properties:{shape:'ascending_north'}}");
        BlockIdConverter.register(1061, "{Name:'minecraft:rail',Properties:{shape:'ascending_south'}}");
        BlockIdConverter.register(1062, "{Name:'minecraft:rail',Properties:{shape:'south_east'}}");
        BlockIdConverter.register(1063, "{Name:'minecraft:rail',Properties:{shape:'south_west'}}");
        BlockIdConverter.register(1064, "{Name:'minecraft:rail',Properties:{shape:'north_west'}}");
        BlockIdConverter.register(1065, "{Name:'minecraft:rail',Properties:{shape:'north_east'}}");
        BlockIdConverter.register(1072, "{Name:'minecraft:cobblestone_stairs',Properties:{facing:'east',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1073, "{Name:'minecraft:cobblestone_stairs',Properties:{facing:'west',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1074, "{Name:'minecraft:cobblestone_stairs',Properties:{facing:'south',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1075, "{Name:'minecraft:cobblestone_stairs',Properties:{facing:'north',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1076, "{Name:'minecraft:cobblestone_stairs',Properties:{facing:'east',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1077, "{Name:'minecraft:cobblestone_stairs',Properties:{facing:'west',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1078, "{Name:'minecraft:cobblestone_stairs',Properties:{facing:'south',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1079, "{Name:'minecraft:cobblestone_stairs',Properties:{facing:'north',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1090, "{Name:'minecraft:wall_sign',Properties:{facing:'north'}}");
        BlockIdConverter.register(1091, "{Name:'minecraft:wall_sign',Properties:{facing:'south'}}");
        BlockIdConverter.register(1092, "{Name:'minecraft:wall_sign',Properties:{facing:'west'}}");
        BlockIdConverter.register(1093, "{Name:'minecraft:wall_sign',Properties:{facing:'east'}}");
        BlockIdConverter.register(1104, "{Name:'minecraft:lever',Properties:{face:'ceiling',facing:'west',powered:'false'}}");
        BlockIdConverter.register(1105, "{Name:'minecraft:lever',Properties:{face:'wall',facing:'east',powered:'false'}}");
        BlockIdConverter.register(1106, "{Name:'minecraft:lever',Properties:{face:'wall',facing:'west',powered:'false'}}");
        BlockIdConverter.register(1107, "{Name:'minecraft:lever',Properties:{face:'wall',facing:'south',powered:'false'}}");
        BlockIdConverter.register(1108, "{Name:'minecraft:lever',Properties:{face:'wall',facing:'north',powered:'false'}}");
        BlockIdConverter.register(1109, "{Name:'minecraft:lever',Properties:{face:'floor',facing:'north',powered:'false'}}");
        BlockIdConverter.register(1110, "{Name:'minecraft:lever',Properties:{face:'floor',facing:'west',powered:'false'}}");
        BlockIdConverter.register(1111, "{Name:'minecraft:lever',Properties:{face:'ceiling',facing:'north',powered:'false'}}");
        BlockIdConverter.register(1112, "{Name:'minecraft:lever',Properties:{face:'ceiling',facing:'west',powered:'true'}}");
        BlockIdConverter.register(1113, "{Name:'minecraft:lever',Properties:{face:'wall',facing:'east',powered:'true'}}");
        BlockIdConverter.register(1114, "{Name:'minecraft:lever',Properties:{face:'wall',facing:'west',powered:'true'}}");
        BlockIdConverter.register(1115, "{Name:'minecraft:lever',Properties:{face:'wall',facing:'south',powered:'true'}}");
        BlockIdConverter.register(1116, "{Name:'minecraft:lever',Properties:{face:'wall',facing:'north',powered:'true'}}");
        BlockIdConverter.register(1117, "{Name:'minecraft:lever',Properties:{face:'floor',facing:'north',powered:'true'}}");
        BlockIdConverter.register(1118, "{Name:'minecraft:lever',Properties:{face:'floor',facing:'west',powered:'true'}}");
        BlockIdConverter.register(1119, "{Name:'minecraft:lever',Properties:{face:'ceiling',facing:'north',powered:'true'}}");
        BlockIdConverter.register(1120, "{Name:'minecraft:stone_pressure_plate',Properties:{powered:'false'}}");
        BlockIdConverter.register(1121, "{Name:'minecraft:stone_pressure_plate',Properties:{powered:'true'}}");
        BlockIdConverter.register(1136, "{Name:'minecraft:iron_door',Properties:{facing:'east',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(1137, "{Name:'minecraft:iron_door',Properties:{facing:'south',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(1138, "{Name:'minecraft:iron_door',Properties:{facing:'west',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(1139, "{Name:'minecraft:iron_door',Properties:{facing:'north',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(1140, "{Name:'minecraft:iron_door',Properties:{facing:'east',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(1141, "{Name:'minecraft:iron_door',Properties:{facing:'south',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(1142, "{Name:'minecraft:iron_door',Properties:{facing:'west',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(1143, "{Name:'minecraft:iron_door',Properties:{facing:'north',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(1144, "{Name:'minecraft:iron_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'false',powered:'false'}}");
        BlockIdConverter.register(1145, "{Name:'minecraft:iron_door',Properties:{facing:'east',half:'upper',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(1146, "{Name:'minecraft:iron_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'false',powered:'true'}}");
        BlockIdConverter.register(1147, "{Name:'minecraft:iron_door',Properties:{facing:'east',half:'upper',hinge:'right',open:'false',powered:'true'}}");
        BlockIdConverter.register(1148, "{Name:'minecraft:iron_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'true',powered:'false'}}");
        BlockIdConverter.register(1149, "{Name:'minecraft:iron_door',Properties:{facing:'south',half:'upper',hinge:'left',open:'true',powered:'false'}}");
        BlockIdConverter.register(1150, "{Name:'minecraft:iron_door',Properties:{facing:'west',half:'upper',hinge:'left',open:'true',powered:'false'}}");
        BlockIdConverter.register(1151, "{Name:'minecraft:iron_door',Properties:{facing:'north',half:'upper',hinge:'left',open:'true',powered:'false'}}");
        BlockIdConverter.register(1152, "{Name:'minecraft:oak_pressure_plate',Properties:{powered:'false'}}");
        BlockIdConverter.register(1153, "{Name:'minecraft:oak_pressure_plate',Properties:{powered:'true'}}");
        BlockIdConverter.register(1168, "{Name:'minecraft:redstone_ore',Properties:{lit:'false'}}");
        BlockIdConverter.register(1184, "{Name:'minecraft:redstone_ore',Properties:{lit:'true'}}");
        BlockIdConverter.register(1201, "{Name:'minecraft:redstone_wall_torch',Properties:{facing:'east',lit:'false'}}");
        BlockIdConverter.register(1202, "{Name:'minecraft:redstone_wall_torch',Properties:{facing:'west',lit:'false'}}");
        BlockIdConverter.register(1203, "{Name:'minecraft:redstone_wall_torch',Properties:{facing:'south',lit:'false'}}");
        BlockIdConverter.register(1204, "{Name:'minecraft:redstone_wall_torch',Properties:{facing:'north',lit:'false'}}");
        BlockIdConverter.register(1205, "{Name:'minecraft:redstone_torch',Properties:{lit:'false'}}");
        BlockIdConverter.register(1217, "{Name:'minecraft:redstone_wall_torch',Properties:{facing:'east',lit:'true'}}");
        BlockIdConverter.register(1218, "{Name:'minecraft:redstone_wall_torch',Properties:{facing:'west',lit:'true'}}");
        BlockIdConverter.register(1219, "{Name:'minecraft:redstone_wall_torch',Properties:{facing:'south',lit:'true'}}");
        BlockIdConverter.register(1220, "{Name:'minecraft:redstone_wall_torch',Properties:{facing:'north',lit:'true'}}");
        BlockIdConverter.register(1221, "{Name:'minecraft:redstone_torch',Properties:{lit:'true'}}");
        BlockIdConverter.register(1232, "{Name:'minecraft:stone_button',Properties:{face:'ceiling',facing:'north',powered:'false'}}");
        BlockIdConverter.register(1233, "{Name:'minecraft:stone_button',Properties:{face:'wall',facing:'east',powered:'false'}}");
        BlockIdConverter.register(1234, "{Name:'minecraft:stone_button',Properties:{face:'wall',facing:'west',powered:'false'}}");
        BlockIdConverter.register(1235, "{Name:'minecraft:stone_button',Properties:{face:'wall',facing:'south',powered:'false'}}");
        BlockIdConverter.register(1236, "{Name:'minecraft:stone_button',Properties:{face:'wall',facing:'north',powered:'false'}}");
        BlockIdConverter.register(1237, "{Name:'minecraft:stone_button',Properties:{face:'floor',facing:'north',powered:'false'}}");
        BlockIdConverter.register(1240, "{Name:'minecraft:stone_button',Properties:{face:'ceiling',facing:'north',powered:'true'}}");
        BlockIdConverter.register(1241, "{Name:'minecraft:stone_button',Properties:{face:'wall',facing:'east',powered:'true'}}");
        BlockIdConverter.register(1242, "{Name:'minecraft:stone_button',Properties:{face:'wall',facing:'west',powered:'true'}}");
        BlockIdConverter.register(1243, "{Name:'minecraft:stone_button',Properties:{face:'wall',facing:'south',powered:'true'}}");
        BlockIdConverter.register(1244, "{Name:'minecraft:stone_button',Properties:{face:'wall',facing:'north',powered:'true'}}");
        BlockIdConverter.register(1245, "{Name:'minecraft:stone_button',Properties:{face:'floor',facing:'north',powered:'true'}}");
        BlockIdConverter.register(1248, "{Name:'minecraft:snow',Properties:{layers:'1'}}");
        BlockIdConverter.register(1249, "{Name:'minecraft:snow',Properties:{layers:'2'}}");
        BlockIdConverter.register(1250, "{Name:'minecraft:snow',Properties:{layers:'3'}}");
        BlockIdConverter.register(1251, "{Name:'minecraft:snow',Properties:{layers:'4'}}");
        BlockIdConverter.register(1252, "{Name:'minecraft:snow',Properties:{layers:'5'}}");
        BlockIdConverter.register(1253, "{Name:'minecraft:snow',Properties:{layers:'6'}}");
        BlockIdConverter.register(1254, "{Name:'minecraft:snow',Properties:{layers:'7'}}");
        BlockIdConverter.register(1255, "{Name:'minecraft:snow',Properties:{layers:'8'}}");
        BlockIdConverter.register(1264, "{Name:'minecraft:ice'}");
        BlockIdConverter.register(1280, "{Name:'minecraft:snow_block'}");
        BlockIdConverter.register(1296, "{Name:'minecraft:cactus',Properties:{age:'0'}}");
        BlockIdConverter.register(1297, "{Name:'minecraft:cactus',Properties:{age:'1'}}");
        BlockIdConverter.register(1298, "{Name:'minecraft:cactus',Properties:{age:'2'}}");
        BlockIdConverter.register(1299, "{Name:'minecraft:cactus',Properties:{age:'3'}}");
        BlockIdConverter.register(1300, "{Name:'minecraft:cactus',Properties:{age:'4'}}");
        BlockIdConverter.register(1301, "{Name:'minecraft:cactus',Properties:{age:'5'}}");
        BlockIdConverter.register(1302, "{Name:'minecraft:cactus',Properties:{age:'6'}}");
        BlockIdConverter.register(1303, "{Name:'minecraft:cactus',Properties:{age:'7'}}");
        BlockIdConverter.register(1304, "{Name:'minecraft:cactus',Properties:{age:'8'}}");
        BlockIdConverter.register(1305, "{Name:'minecraft:cactus',Properties:{age:'9'}}");
        BlockIdConverter.register(1306, "{Name:'minecraft:cactus',Properties:{age:'10'}}");
        BlockIdConverter.register(1307, "{Name:'minecraft:cactus',Properties:{age:'11'}}");
        BlockIdConverter.register(1308, "{Name:'minecraft:cactus',Properties:{age:'12'}}");
        BlockIdConverter.register(1309, "{Name:'minecraft:cactus',Properties:{age:'13'}}");
        BlockIdConverter.register(1310, "{Name:'minecraft:cactus',Properties:{age:'14'}}");
        BlockIdConverter.register(1311, "{Name:'minecraft:cactus',Properties:{age:'15'}}");
        BlockIdConverter.register(1312, "{Name:'minecraft:clay'}");
        BlockIdConverter.register(1328, "{Name:'minecraft:sugar_cane',Properties:{age:'0'}}");
        BlockIdConverter.register(1329, "{Name:'minecraft:sugar_cane',Properties:{age:'1'}}");
        BlockIdConverter.register(1330, "{Name:'minecraft:sugar_cane',Properties:{age:'2'}}");
        BlockIdConverter.register(1331, "{Name:'minecraft:sugar_cane',Properties:{age:'3'}}");
        BlockIdConverter.register(1332, "{Name:'minecraft:sugar_cane',Properties:{age:'4'}}");
        BlockIdConverter.register(1333, "{Name:'minecraft:sugar_cane',Properties:{age:'5'}}");
        BlockIdConverter.register(1334, "{Name:'minecraft:sugar_cane',Properties:{age:'6'}}");
        BlockIdConverter.register(1335, "{Name:'minecraft:sugar_cane',Properties:{age:'7'}}");
        BlockIdConverter.register(1336, "{Name:'minecraft:sugar_cane',Properties:{age:'8'}}");
        BlockIdConverter.register(1337, "{Name:'minecraft:sugar_cane',Properties:{age:'9'}}");
        BlockIdConverter.register(1338, "{Name:'minecraft:sugar_cane',Properties:{age:'10'}}");
        BlockIdConverter.register(1339, "{Name:'minecraft:sugar_cane',Properties:{age:'11'}}");
        BlockIdConverter.register(1340, "{Name:'minecraft:sugar_cane',Properties:{age:'12'}}");
        BlockIdConverter.register(1341, "{Name:'minecraft:sugar_cane',Properties:{age:'13'}}");
        BlockIdConverter.register(1342, "{Name:'minecraft:sugar_cane',Properties:{age:'14'}}");
        BlockIdConverter.register(1343, "{Name:'minecraft:sugar_cane',Properties:{age:'15'}}");
        BlockIdConverter.register(1344, "{Name:'minecraft:jukebox',Properties:{has_record:'false'}}");
        BlockIdConverter.register(1345, "{Name:'minecraft:jukebox',Properties:{has_record:'true'}}");
        BlockIdConverter.register(1360, "{Name:'minecraft:oak_fence',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(1376, "{Name:'minecraft:carved_pumpkin',Properties:{facing:'south'}}");
        BlockIdConverter.register(1377, "{Name:'minecraft:carved_pumpkin',Properties:{facing:'west'}}");
        BlockIdConverter.register(1378, "{Name:'minecraft:carved_pumpkin',Properties:{facing:'north'}}");
        BlockIdConverter.register(1379, "{Name:'minecraft:carved_pumpkin',Properties:{facing:'east'}}");
        BlockIdConverter.register(1392, "{Name:'minecraft:netherrack'}");
        BlockIdConverter.register(1408, "{Name:'minecraft:soul_sand'}");
        BlockIdConverter.register(1424, "{Name:'minecraft:glowstone'}");
        BlockIdConverter.register(1441, "{Name:'minecraft:portal',Properties:{axis:'x'}}");
        BlockIdConverter.register(1442, "{Name:'minecraft:portal',Properties:{axis:'z'}}");
        BlockIdConverter.register(1456, "{Name:'minecraft:jack_o_lantern',Properties:{facing:'south'}}");
        BlockIdConverter.register(1457, "{Name:'minecraft:jack_o_lantern',Properties:{facing:'west'}}");
        BlockIdConverter.register(1458, "{Name:'minecraft:jack_o_lantern',Properties:{facing:'north'}}");
        BlockIdConverter.register(1459, "{Name:'minecraft:jack_o_lantern',Properties:{facing:'east'}}");
        BlockIdConverter.register(1472, "{Name:'minecraft:cake',Properties:{bites:'0'}}");
        BlockIdConverter.register(1473, "{Name:'minecraft:cake',Properties:{bites:'1'}}");
        BlockIdConverter.register(1474, "{Name:'minecraft:cake',Properties:{bites:'2'}}");
        BlockIdConverter.register(1475, "{Name:'minecraft:cake',Properties:{bites:'3'}}");
        BlockIdConverter.register(1476, "{Name:'minecraft:cake',Properties:{bites:'4'}}");
        BlockIdConverter.register(1477, "{Name:'minecraft:cake',Properties:{bites:'5'}}");
        BlockIdConverter.register(1478, "{Name:'minecraft:cake',Properties:{bites:'6'}}");
        BlockIdConverter.register(1488, "{Name:'minecraft:repeater',Properties:{delay:'1',facing:'south',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1489, "{Name:'minecraft:repeater',Properties:{delay:'1',facing:'west',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1490, "{Name:'minecraft:repeater',Properties:{delay:'1',facing:'north',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1491, "{Name:'minecraft:repeater',Properties:{delay:'1',facing:'east',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1492, "{Name:'minecraft:repeater',Properties:{delay:'2',facing:'south',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1493, "{Name:'minecraft:repeater',Properties:{delay:'2',facing:'west',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1494, "{Name:'minecraft:repeater',Properties:{delay:'2',facing:'north',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1495, "{Name:'minecraft:repeater',Properties:{delay:'2',facing:'east',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1496, "{Name:'minecraft:repeater',Properties:{delay:'3',facing:'south',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1497, "{Name:'minecraft:repeater',Properties:{delay:'3',facing:'west',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1498, "{Name:'minecraft:repeater',Properties:{delay:'3',facing:'north',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1499, "{Name:'minecraft:repeater',Properties:{delay:'3',facing:'east',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1500, "{Name:'minecraft:repeater',Properties:{delay:'4',facing:'south',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1501, "{Name:'minecraft:repeater',Properties:{delay:'4',facing:'west',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1502, "{Name:'minecraft:repeater',Properties:{delay:'4',facing:'north',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1503, "{Name:'minecraft:repeater',Properties:{delay:'4',facing:'east',locked:'false',powered:'false'}}");
        BlockIdConverter.register(1504, "{Name:'minecraft:repeater',Properties:{delay:'1',facing:'south',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1505, "{Name:'minecraft:repeater',Properties:{delay:'1',facing:'west',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1506, "{Name:'minecraft:repeater',Properties:{delay:'1',facing:'north',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1507, "{Name:'minecraft:repeater',Properties:{delay:'1',facing:'east',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1508, "{Name:'minecraft:repeater',Properties:{delay:'2',facing:'south',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1509, "{Name:'minecraft:repeater',Properties:{delay:'2',facing:'west',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1510, "{Name:'minecraft:repeater',Properties:{delay:'2',facing:'north',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1511, "{Name:'minecraft:repeater',Properties:{delay:'2',facing:'east',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1512, "{Name:'minecraft:repeater',Properties:{delay:'3',facing:'south',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1513, "{Name:'minecraft:repeater',Properties:{delay:'3',facing:'west',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1514, "{Name:'minecraft:repeater',Properties:{delay:'3',facing:'north',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1515, "{Name:'minecraft:repeater',Properties:{delay:'3',facing:'east',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1516, "{Name:'minecraft:repeater',Properties:{delay:'4',facing:'south',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1517, "{Name:'minecraft:repeater',Properties:{delay:'4',facing:'west',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1518, "{Name:'minecraft:repeater',Properties:{delay:'4',facing:'north',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1519, "{Name:'minecraft:repeater',Properties:{delay:'4',facing:'east',locked:'false',powered:'true'}}");
        BlockIdConverter.register(1520, "{Name:'minecraft:white_stained_glass'}");
        BlockIdConverter.register(1521, "{Name:'minecraft:orange_stained_glass'}");
        BlockIdConverter.register(1522, "{Name:'minecraft:magenta_stained_glass'}");
        BlockIdConverter.register(1523, "{Name:'minecraft:light_blue_stained_glass'}");
        BlockIdConverter.register(1524, "{Name:'minecraft:yellow_stained_glass'}");
        BlockIdConverter.register(1525, "{Name:'minecraft:lime_stained_glass'}");
        BlockIdConverter.register(1526, "{Name:'minecraft:pink_stained_glass'}");
        BlockIdConverter.register(1527, "{Name:'minecraft:gray_stained_glass'}");
        BlockIdConverter.register(1528, "{Name:'minecraft:light_gray_stained_glass'}");
        BlockIdConverter.register(1529, "{Name:'minecraft:cyan_stained_glass'}");
        BlockIdConverter.register(1530, "{Name:'minecraft:purple_stained_glass'}");
        BlockIdConverter.register(1531, "{Name:'minecraft:blue_stained_glass'}");
        BlockIdConverter.register(1532, "{Name:'minecraft:brown_stained_glass'}");
        BlockIdConverter.register(1533, "{Name:'minecraft:green_stained_glass'}");
        BlockIdConverter.register(1534, "{Name:'minecraft:red_stained_glass'}");
        BlockIdConverter.register(1535, "{Name:'minecraft:black_stained_glass'}");
        BlockIdConverter.register(1536, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'north',half:'bottom',open:'false'}}");
        BlockIdConverter.register(1537, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'south',half:'bottom',open:'false'}}");
        BlockIdConverter.register(1538, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'west',half:'bottom',open:'false'}}");
        BlockIdConverter.register(1539, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'east',half:'bottom',open:'false'}}");
        BlockIdConverter.register(1540, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'north',half:'bottom',open:'true'}}");
        BlockIdConverter.register(1541, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'south',half:'bottom',open:'true'}}");
        BlockIdConverter.register(1542, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'west',half:'bottom',open:'true'}}");
        BlockIdConverter.register(1543, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'east',half:'bottom',open:'true'}}");
        BlockIdConverter.register(1544, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'north',half:'top',open:'false'}}");
        BlockIdConverter.register(1545, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'south',half:'top',open:'false'}}");
        BlockIdConverter.register(1546, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'west',half:'top',open:'false'}}");
        BlockIdConverter.register(1547, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'east',half:'top',open:'false'}}");
        BlockIdConverter.register(1548, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'north',half:'top',open:'true'}}");
        BlockIdConverter.register(1549, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'south',half:'top',open:'true'}}");
        BlockIdConverter.register(1550, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'west',half:'top',open:'true'}}");
        BlockIdConverter.register(1551, "{Name:'minecraft:oak_trapdoor',Properties:{facing:'east',half:'top',open:'true'}}");
        BlockIdConverter.register(1552, "{Name:'minecraft:infested_stone'}");
        BlockIdConverter.register(1553, "{Name:'minecraft:infested_cobblestone'}");
        BlockIdConverter.register(1554, "{Name:'minecraft:infested_stone_bricks'}");
        BlockIdConverter.register(1555, "{Name:'minecraft:infested_mossy_stone_bricks'}");
        BlockIdConverter.register(1556, "{Name:'minecraft:infested_cracked_stone_bricks'}");
        BlockIdConverter.register(1557, "{Name:'minecraft:infested_chiseled_stone_bricks'}");
        BlockIdConverter.register(1568, "{Name:'minecraft:stone_bricks'}");
        BlockIdConverter.register(1569, "{Name:'minecraft:mossy_stone_bricks'}");
        BlockIdConverter.register(1570, "{Name:'minecraft:cracked_stone_bricks'}");
        BlockIdConverter.register(1571, "{Name:'minecraft:chiseled_stone_bricks'}");
        BlockIdConverter.register(1584, "{Name:'minecraft:brown_mushroom_block',Properties:{north:'false',east:'false',south:'false',west:'false',up:'false',down:'false'}}");
        BlockIdConverter.register(1585, "{Name:'minecraft:brown_mushroom_block',Properties:{north:'true',east:'false',south:'false',west:'true',up:'true',down:'false'}}");
        BlockIdConverter.register(1586, "{Name:'minecraft:brown_mushroom_block',Properties:{north:'true',east:'false',south:'false',west:'false',up:'true',down:'false'}}");
        BlockIdConverter.register(1587, "{Name:'minecraft:brown_mushroom_block',Properties:{north:'true',east:'true',south:'false',west:'false',up:'true',down:'false'}}");
        BlockIdConverter.register(1588, "{Name:'minecraft:brown_mushroom_block',Properties:{north:'false',east:'false',south:'false',west:'true',up:'true',down:'false'}}");
        BlockIdConverter.register(1589, "{Name:'minecraft:brown_mushroom_block',Properties:{north:'false',east:'false',south:'false',west:'false',up:'true',down:'false'}}");
        BlockIdConverter.register(1590, "{Name:'minecraft:brown_mushroom_block',Properties:{north:'false',east:'true',south:'false',west:'false',up:'true',down:'false'}}");
        BlockIdConverter.register(1591, "{Name:'minecraft:brown_mushroom_block',Properties:{north:'false',east:'false',south:'true',west:'true',up:'true',down:'false'}}");
        BlockIdConverter.register(1592, "{Name:'minecraft:brown_mushroom_block',Properties:{north:'false',east:'false',south:'true',west:'false',up:'true',down:'false'}}");
        BlockIdConverter.register(1593, "{Name:'minecraft:brown_mushroom_block',Properties:{north:'false',east:'true',south:'true',west:'false',up:'true',down:'false'}}");
        BlockIdConverter.register(1594, "{Name:'minecraft:mushroom_stem',Properties:{north:'true',east:'true',south:'true',west:'true',up:'false',down:'false'}}");
        BlockIdConverter.register(1595, "{Name:'minecraft:brown_mushroom_block',Properties:{north:'false',east:'false',south:'false',west:'false',up:'false',down:'false'}}");
        BlockIdConverter.register(1596, "{Name:'minecraft:brown_mushroom_block',Properties:{north:'false',east:'false',south:'false',west:'false',up:'false',down:'false'}}");
        BlockIdConverter.register(1597, "{Name:'minecraft:brown_mushroom_block',Properties:{north:'false',east:'false',south:'false',west:'false',up:'false',down:'false'}}");
        BlockIdConverter.register(1598, "{Name:'minecraft:brown_mushroom_block',Properties:{north:'true',east:'true',south:'true',west:'true',up:'true',down:'true'}}");
        BlockIdConverter.register(1599, "{Name:'minecraft:mushroom_stem',Properties:{north:'true',east:'true',south:'true',west:'true',up:'true',down:'true'}}");
        BlockIdConverter.register(1600, "{Name:'minecraft:red_mushroom_block',Properties:{north:'false',east:'false',south:'false',west:'false',up:'false',down:'false'}}");
        BlockIdConverter.register(1601, "{Name:'minecraft:red_mushroom_block',Properties:{north:'true',east:'false',south:'false',west:'true',up:'true',down:'false'}}");
        BlockIdConverter.register(1602, "{Name:'minecraft:red_mushroom_block',Properties:{north:'true',east:'false',south:'false',west:'false',up:'true',down:'false'}}");
        BlockIdConverter.register(1603, "{Name:'minecraft:red_mushroom_block',Properties:{north:'true',east:'true',south:'false',west:'false',up:'true',down:'false'}}");
        BlockIdConverter.register(1604, "{Name:'minecraft:red_mushroom_block',Properties:{north:'false',east:'false',south:'false',west:'true',up:'true',down:'false'}}");
        BlockIdConverter.register(1605, "{Name:'minecraft:red_mushroom_block',Properties:{north:'false',east:'false',south:'false',west:'false',up:'true',down:'false'}}");
        BlockIdConverter.register(1606, "{Name:'minecraft:red_mushroom_block',Properties:{north:'false',east:'true',south:'false',west:'false',up:'true',down:'false'}}");
        BlockIdConverter.register(1607, "{Name:'minecraft:red_mushroom_block',Properties:{north:'false',east:'false',south:'true',west:'true',up:'true',down:'false'}}");
        BlockIdConverter.register(1608, "{Name:'minecraft:red_mushroom_block',Properties:{north:'false',east:'false',south:'true',west:'false',up:'true',down:'false'}}");
        BlockIdConverter.register(1609, "{Name:'minecraft:red_mushroom_block',Properties:{north:'false',east:'true',south:'true',west:'false',up:'true',down:'false'}}");
        BlockIdConverter.register(1610, "{Name:'minecraft:mushroom_stem',Properties:{north:'true',east:'true',south:'true',west:'true',up:'false',down:'false'}}");
        BlockIdConverter.register(1611, "{Name:'minecraft:red_mushroom_block',Properties:{north:'false',east:'false',south:'false',west:'false',up:'false',down:'false'}}");
        BlockIdConverter.register(1612, "{Name:'minecraft:red_mushroom_block',Properties:{north:'false',east:'false',south:'false',west:'false',up:'false',down:'false'}}");
        BlockIdConverter.register(1613, "{Name:'minecraft:red_mushroom_block',Properties:{north:'false',east:'false',south:'false',west:'false',up:'false',down:'false'}}");
        BlockIdConverter.register(1614, "{Name:'minecraft:red_mushroom_block',Properties:{north:'true',east:'true',south:'true',west:'true',up:'true',down:'true'}}");
        BlockIdConverter.register(1615, "{Name:'minecraft:mushroom_stem',Properties:{north:'true',east:'true',south:'true',west:'true',up:'true',down:'true'}}");
        BlockIdConverter.register(1616, "{Name:'minecraft:iron_bars',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(1632, "{Name:'minecraft:glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(1648, "{Name:'minecraft:melon_block'}");
        BlockIdConverter.register(1664, "{Name:'minecraft:pumpkin_stem',Properties:{age:'0'}}");
        BlockIdConverter.register(1665, "{Name:'minecraft:pumpkin_stem',Properties:{age:'1'}}");
        BlockIdConverter.register(1666, "{Name:'minecraft:pumpkin_stem',Properties:{age:'2'}}");
        BlockIdConverter.register(1667, "{Name:'minecraft:pumpkin_stem',Properties:{age:'3'}}");
        BlockIdConverter.register(1668, "{Name:'minecraft:pumpkin_stem',Properties:{age:'4'}}");
        BlockIdConverter.register(1669, "{Name:'minecraft:pumpkin_stem',Properties:{age:'5'}}");
        BlockIdConverter.register(1670, "{Name:'minecraft:pumpkin_stem',Properties:{age:'6'}}");
        BlockIdConverter.register(1671, "{Name:'minecraft:pumpkin_stem',Properties:{age:'7'}}");
        BlockIdConverter.register(1680, "{Name:'minecraft:melon_stem',Properties:{age:'0'}}");
        BlockIdConverter.register(1681, "{Name:'minecraft:melon_stem',Properties:{age:'1'}}");
        BlockIdConverter.register(1682, "{Name:'minecraft:melon_stem',Properties:{age:'2'}}");
        BlockIdConverter.register(1683, "{Name:'minecraft:melon_stem',Properties:{age:'3'}}");
        BlockIdConverter.register(1684, "{Name:'minecraft:melon_stem',Properties:{age:'4'}}");
        BlockIdConverter.register(1685, "{Name:'minecraft:melon_stem',Properties:{age:'5'}}");
        BlockIdConverter.register(1686, "{Name:'minecraft:melon_stem',Properties:{age:'6'}}");
        BlockIdConverter.register(1687, "{Name:'minecraft:melon_stem',Properties:{age:'7'}}");
        BlockIdConverter.register(1696, "{Name:'minecraft:vine',Properties:{east:'false',north:'false',south:'false',up:'true',west:'false'}}");
        BlockIdConverter.register(1697, "{Name:'minecraft:vine',Properties:{east:'false',north:'false',south:'true',up:'true',west:'false'}}");
        BlockIdConverter.register(1698, "{Name:'minecraft:vine',Properties:{east:'false',north:'false',south:'false',up:'true',west:'true'}}");
        BlockIdConverter.register(1699, "{Name:'minecraft:vine',Properties:{east:'false',north:'false',south:'true',up:'true',west:'true'}}");
        BlockIdConverter.register(1700, "{Name:'minecraft:vine',Properties:{east:'false',north:'true',south:'false',up:'true',west:'false'}}");
        BlockIdConverter.register(1701, "{Name:'minecraft:vine',Properties:{east:'false',north:'true',south:'true',up:'true',west:'false'}}");
        BlockIdConverter.register(1702, "{Name:'minecraft:vine',Properties:{east:'false',north:'true',south:'false',up:'true',west:'true'}}");
        BlockIdConverter.register(1703, "{Name:'minecraft:vine',Properties:{east:'false',north:'true',south:'true',up:'true',west:'true'}}");
        BlockIdConverter.register(1704, "{Name:'minecraft:vine',Properties:{east:'true',north:'false',south:'false',up:'true',west:'false'}}");
        BlockIdConverter.register(1705, "{Name:'minecraft:vine',Properties:{east:'true',north:'false',south:'true',up:'true',west:'false'}}");
        BlockIdConverter.register(1706, "{Name:'minecraft:vine',Properties:{east:'true',north:'false',south:'false',up:'true',west:'true'}}");
        BlockIdConverter.register(1707, "{Name:'minecraft:vine',Properties:{east:'true',north:'false',south:'true',up:'true',west:'true'}}");
        BlockIdConverter.register(1708, "{Name:'minecraft:vine',Properties:{east:'true',north:'true',south:'false',up:'true',west:'false'}}");
        BlockIdConverter.register(1709, "{Name:'minecraft:vine',Properties:{east:'true',north:'true',south:'true',up:'true',west:'false'}}");
        BlockIdConverter.register(1710, "{Name:'minecraft:vine',Properties:{east:'true',north:'true',south:'false',up:'true',west:'true'}}");
        BlockIdConverter.register(1711, "{Name:'minecraft:vine',Properties:{east:'true',north:'true',south:'true',up:'true',west:'true'}}");
        BlockIdConverter.register(1712, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'south',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(1713, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'west',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(1714, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'north',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(1715, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'east',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(1716, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'south',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(1717, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'west',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(1718, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'north',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(1719, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'east',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(1720, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'south',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(1721, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'west',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(1722, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'north',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(1723, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'east',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(1724, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'south',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(1725, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'west',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(1726, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'north',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(1727, "{Name:'minecraft:oak_fence_gate',Properties:{facing:'east',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(1728, "{Name:'minecraft:brick_stairs',Properties:{facing:'east',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1729, "{Name:'minecraft:brick_stairs',Properties:{facing:'west',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1730, "{Name:'minecraft:brick_stairs',Properties:{facing:'south',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1731, "{Name:'minecraft:brick_stairs',Properties:{facing:'north',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1732, "{Name:'minecraft:brick_stairs',Properties:{facing:'east',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1733, "{Name:'minecraft:brick_stairs',Properties:{facing:'west',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1734, "{Name:'minecraft:brick_stairs',Properties:{facing:'south',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1735, "{Name:'minecraft:brick_stairs',Properties:{facing:'north',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1744, "{Name:'minecraft:stone_brick_stairs',Properties:{facing:'east',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1745, "{Name:'minecraft:stone_brick_stairs',Properties:{facing:'west',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1746, "{Name:'minecraft:stone_brick_stairs',Properties:{facing:'south',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1747, "{Name:'minecraft:stone_brick_stairs',Properties:{facing:'north',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1748, "{Name:'minecraft:stone_brick_stairs',Properties:{facing:'east',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1749, "{Name:'minecraft:stone_brick_stairs',Properties:{facing:'west',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1750, "{Name:'minecraft:stone_brick_stairs',Properties:{facing:'south',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1751, "{Name:'minecraft:stone_brick_stairs',Properties:{facing:'north',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1760, "{Name:'minecraft:mycelium',Properties:{snowy:'false'}}");
        BlockIdConverter.register(1776, "{Name:'minecraft:lily_pad'}");
        BlockIdConverter.register(1792, "{Name:'minecraft:nether_bricks'}");
        BlockIdConverter.register(1808, "{Name:'minecraft:nether_brick_fence',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(1824, "{Name:'minecraft:nether_brick_stairs',Properties:{facing:'east',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1825, "{Name:'minecraft:nether_brick_stairs',Properties:{facing:'west',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1826, "{Name:'minecraft:nether_brick_stairs',Properties:{facing:'south',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1827, "{Name:'minecraft:nether_brick_stairs',Properties:{facing:'north',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(1828, "{Name:'minecraft:nether_brick_stairs',Properties:{facing:'east',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1829, "{Name:'minecraft:nether_brick_stairs',Properties:{facing:'west',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1830, "{Name:'minecraft:nether_brick_stairs',Properties:{facing:'south',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1831, "{Name:'minecraft:nether_brick_stairs',Properties:{facing:'north',half:'top',shape:'straight'}}");
        BlockIdConverter.register(1840, "{Name:'minecraft:nether_wart',Properties:{age:'0'}}");
        BlockIdConverter.register(1841, "{Name:'minecraft:nether_wart',Properties:{age:'1'}}");
        BlockIdConverter.register(1842, "{Name:'minecraft:nether_wart',Properties:{age:'2'}}");
        BlockIdConverter.register(1843, "{Name:'minecraft:nether_wart',Properties:{age:'3'}}");
        BlockIdConverter.register(1856, "{Name:'minecraft:enchanting_table'}");
        BlockIdConverter.register(1872, "{Name:'minecraft:brewing_stand',Properties:{has_bottle_0:'false',has_bottle_1:'false',has_bottle_2:'false'}}");
        BlockIdConverter.register(1873, "{Name:'minecraft:brewing_stand',Properties:{has_bottle_0:'true',has_bottle_1:'false',has_bottle_2:'false'}}");
        BlockIdConverter.register(1874, "{Name:'minecraft:brewing_stand',Properties:{has_bottle_0:'false',has_bottle_1:'true',has_bottle_2:'false'}}");
        BlockIdConverter.register(1875, "{Name:'minecraft:brewing_stand',Properties:{has_bottle_0:'true',has_bottle_1:'true',has_bottle_2:'false'}}");
        BlockIdConverter.register(1876, "{Name:'minecraft:brewing_stand',Properties:{has_bottle_0:'false',has_bottle_1:'false',has_bottle_2:'true'}}");
        BlockIdConverter.register(1877, "{Name:'minecraft:brewing_stand',Properties:{has_bottle_0:'true',has_bottle_1:'false',has_bottle_2:'true'}}");
        BlockIdConverter.register(1878, "{Name:'minecraft:brewing_stand',Properties:{has_bottle_0:'false',has_bottle_1:'true',has_bottle_2:'true'}}");
        BlockIdConverter.register(1879, "{Name:'minecraft:brewing_stand',Properties:{has_bottle_0:'true',has_bottle_1:'true',has_bottle_2:'true'}}");
        BlockIdConverter.register(1888, "{Name:'minecraft:cauldron',Properties:{level:'0'}}");
        BlockIdConverter.register(1889, "{Name:'minecraft:cauldron',Properties:{level:'1'}}");
        BlockIdConverter.register(1890, "{Name:'minecraft:cauldron',Properties:{level:'2'}}");
        BlockIdConverter.register(1891, "{Name:'minecraft:cauldron',Properties:{level:'3'}}");
        BlockIdConverter.register(1904, "{Name:'minecraft:end_portal'}");
        BlockIdConverter.register(1920, "{Name:'minecraft:end_portal_frame',Properties:{eye:'false',facing:'south'}}");
        BlockIdConverter.register(1921, "{Name:'minecraft:end_portal_frame',Properties:{eye:'false',facing:'west'}}");
        BlockIdConverter.register(1922, "{Name:'minecraft:end_portal_frame',Properties:{eye:'false',facing:'north'}}");
        BlockIdConverter.register(1923, "{Name:'minecraft:end_portal_frame',Properties:{eye:'false',facing:'east'}}");
        BlockIdConverter.register(1924, "{Name:'minecraft:end_portal_frame',Properties:{eye:'true',facing:'south'}}");
        BlockIdConverter.register(1925, "{Name:'minecraft:end_portal_frame',Properties:{eye:'true',facing:'west'}}");
        BlockIdConverter.register(1926, "{Name:'minecraft:end_portal_frame',Properties:{eye:'true',facing:'north'}}");
        BlockIdConverter.register(1927, "{Name:'minecraft:end_portal_frame',Properties:{eye:'true',facing:'east'}}");
        BlockIdConverter.register(1936, "{Name:'minecraft:end_stone'}");
        BlockIdConverter.register(1952, "{Name:'minecraft:dragon_egg'}");
        BlockIdConverter.register(1968, "{Name:'minecraft:redstone_lamp',Properties:{lit:'false'}}");
        BlockIdConverter.register(1984, "{Name:'minecraft:redstone_lamp',Properties:{lit:'true'}}");
        BlockIdConverter.register(2000, "{Name:'minecraft:oak_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(2001, "{Name:'minecraft:spruce_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(2002, "{Name:'minecraft:birch_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(2003, "{Name:'minecraft:jungle_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(2004, "{Name:'minecraft:acacia_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(2005, "{Name:'minecraft:dark_oak_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(2016, "{Name:'minecraft:oak_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(2017, "{Name:'minecraft:spruce_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(2018, "{Name:'minecraft:birch_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(2019, "{Name:'minecraft:jungle_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(2020, "{Name:'minecraft:acacia_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(2021, "{Name:'minecraft:dark_oak_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(2024, "{Name:'minecraft:oak_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(2025, "{Name:'minecraft:spruce_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(2026, "{Name:'minecraft:birch_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(2027, "{Name:'minecraft:jungle_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(2028, "{Name:'minecraft:acacia_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(2029, "{Name:'minecraft:dark_oak_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(2032, "{Name:'minecraft:cocoa',Properties:{age:'0',facing:'south'}}");
        BlockIdConverter.register(2033, "{Name:'minecraft:cocoa',Properties:{age:'0',facing:'west'}}");
        BlockIdConverter.register(2034, "{Name:'minecraft:cocoa',Properties:{age:'0',facing:'north'}}");
        BlockIdConverter.register(2035, "{Name:'minecraft:cocoa',Properties:{age:'0',facing:'east'}}");
        BlockIdConverter.register(2036, "{Name:'minecraft:cocoa',Properties:{age:'1',facing:'south'}}");
        BlockIdConverter.register(2037, "{Name:'minecraft:cocoa',Properties:{age:'1',facing:'west'}}");
        BlockIdConverter.register(2038, "{Name:'minecraft:cocoa',Properties:{age:'1',facing:'north'}}");
        BlockIdConverter.register(2039, "{Name:'minecraft:cocoa',Properties:{age:'1',facing:'east'}}");
        BlockIdConverter.register(2040, "{Name:'minecraft:cocoa',Properties:{age:'2',facing:'south'}}");
        BlockIdConverter.register(2041, "{Name:'minecraft:cocoa',Properties:{age:'2',facing:'west'}}");
        BlockIdConverter.register(2042, "{Name:'minecraft:cocoa',Properties:{age:'2',facing:'north'}}");
        BlockIdConverter.register(2043, "{Name:'minecraft:cocoa',Properties:{age:'2',facing:'east'}}");
        BlockIdConverter.register(2048, "{Name:'minecraft:sandstone_stairs',Properties:{facing:'east',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2049, "{Name:'minecraft:sandstone_stairs',Properties:{facing:'west',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2050, "{Name:'minecraft:sandstone_stairs',Properties:{facing:'south',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2051, "{Name:'minecraft:sandstone_stairs',Properties:{facing:'north',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2052, "{Name:'minecraft:sandstone_stairs',Properties:{facing:'east',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2053, "{Name:'minecraft:sandstone_stairs',Properties:{facing:'west',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2054, "{Name:'minecraft:sandstone_stairs',Properties:{facing:'south',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2055, "{Name:'minecraft:sandstone_stairs',Properties:{facing:'north',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2064, "{Name:'minecraft:emerald_ore'}");
        BlockIdConverter.register(2082, "{Name:'minecraft:ender_chest',Properties:{facing:'north'}}");
        BlockIdConverter.register(2083, "{Name:'minecraft:ender_chest',Properties:{facing:'south'}}");
        BlockIdConverter.register(2084, "{Name:'minecraft:ender_chest',Properties:{facing:'west'}}");
        BlockIdConverter.register(2085, "{Name:'minecraft:ender_chest',Properties:{facing:'east'}}");
        BlockIdConverter.register(2096, "{Name:'minecraft:tripwire_hook',Properties:{attached:'false',facing:'south',powered:'false'}}");
        BlockIdConverter.register(2097, "{Name:'minecraft:tripwire_hook',Properties:{attached:'false',facing:'west',powered:'false'}}");
        BlockIdConverter.register(2098, "{Name:'minecraft:tripwire_hook',Properties:{attached:'false',facing:'north',powered:'false'}}");
        BlockIdConverter.register(2099, "{Name:'minecraft:tripwire_hook',Properties:{attached:'false',facing:'east',powered:'false'}}");
        BlockIdConverter.register(2100, "{Name:'minecraft:tripwire_hook',Properties:{attached:'true',facing:'south',powered:'false'}}");
        BlockIdConverter.register(2101, "{Name:'minecraft:tripwire_hook',Properties:{attached:'true',facing:'west',powered:'false'}}");
        BlockIdConverter.register(2102, "{Name:'minecraft:tripwire_hook',Properties:{attached:'true',facing:'north',powered:'false'}}");
        BlockIdConverter.register(2103, "{Name:'minecraft:tripwire_hook',Properties:{attached:'true',facing:'east',powered:'false'}}");
        BlockIdConverter.register(2104, "{Name:'minecraft:tripwire_hook',Properties:{attached:'false',facing:'south',powered:'true'}}");
        BlockIdConverter.register(2105, "{Name:'minecraft:tripwire_hook',Properties:{attached:'false',facing:'west',powered:'true'}}");
        BlockIdConverter.register(2106, "{Name:'minecraft:tripwire_hook',Properties:{attached:'false',facing:'north',powered:'true'}}");
        BlockIdConverter.register(2107, "{Name:'minecraft:tripwire_hook',Properties:{attached:'false',facing:'east',powered:'true'}}");
        BlockIdConverter.register(2108, "{Name:'minecraft:tripwire_hook',Properties:{attached:'true',facing:'south',powered:'true'}}");
        BlockIdConverter.register(2109, "{Name:'minecraft:tripwire_hook',Properties:{attached:'true',facing:'west',powered:'true'}}");
        BlockIdConverter.register(2110, "{Name:'minecraft:tripwire_hook',Properties:{attached:'true',facing:'north',powered:'true'}}");
        BlockIdConverter.register(2111, "{Name:'minecraft:tripwire_hook',Properties:{attached:'true',facing:'east',powered:'true'}}");
        BlockIdConverter.register(2112, "{Name:'minecraft:tripwire',Properties:{attached:'false',disarmed:'false',east:'false',north:'false',powered:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2113, "{Name:'minecraft:tripwire',Properties:{attached:'false',disarmed:'false',east:'false',north:'false',powered:'true',south:'false',west:'false'}}");
        BlockIdConverter.register(2114, "{Name:'minecraft:tripwire',Properties:{attached:'false',disarmed:'false',east:'false',north:'false',powered:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2115, "{Name:'minecraft:tripwire',Properties:{attached:'false',disarmed:'false',east:'false',north:'false',powered:'true',south:'false',west:'false'}}");
        BlockIdConverter.register(2116, "{Name:'minecraft:tripwire',Properties:{attached:'true',disarmed:'false',east:'false',north:'false',powered:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2117, "{Name:'minecraft:tripwire',Properties:{attached:'true',disarmed:'false',east:'false',north:'false',powered:'true',south:'false',west:'false'}}");
        BlockIdConverter.register(2118, "{Name:'minecraft:tripwire',Properties:{attached:'true',disarmed:'false',east:'false',north:'false',powered:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2119, "{Name:'minecraft:tripwire',Properties:{attached:'true',disarmed:'false',east:'false',north:'false',powered:'true',south:'false',west:'false'}}");
        BlockIdConverter.register(2120, "{Name:'minecraft:tripwire',Properties:{attached:'false',disarmed:'true',east:'false',north:'false',powered:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2121, "{Name:'minecraft:tripwire',Properties:{attached:'false',disarmed:'true',east:'false',north:'false',powered:'true',south:'false',west:'false'}}");
        BlockIdConverter.register(2122, "{Name:'minecraft:tripwire',Properties:{attached:'false',disarmed:'true',east:'false',north:'false',powered:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2123, "{Name:'minecraft:tripwire',Properties:{attached:'false',disarmed:'true',east:'false',north:'false',powered:'true',south:'false',west:'false'}}");
        BlockIdConverter.register(2124, "{Name:'minecraft:tripwire',Properties:{attached:'true',disarmed:'true',east:'false',north:'false',powered:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2125, "{Name:'minecraft:tripwire',Properties:{attached:'true',disarmed:'true',east:'false',north:'false',powered:'true',south:'false',west:'false'}}");
        BlockIdConverter.register(2126, "{Name:'minecraft:tripwire',Properties:{attached:'true',disarmed:'true',east:'false',north:'false',powered:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2128, "{Name:'minecraft:emerald_block'}");
        BlockIdConverter.register(2144, "{Name:'minecraft:spruce_stairs',Properties:{facing:'east',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2145, "{Name:'minecraft:spruce_stairs',Properties:{facing:'west',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2146, "{Name:'minecraft:spruce_stairs',Properties:{facing:'south',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2147, "{Name:'minecraft:spruce_stairs',Properties:{facing:'north',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2148, "{Name:'minecraft:spruce_stairs',Properties:{facing:'east',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2149, "{Name:'minecraft:spruce_stairs',Properties:{facing:'west',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2150, "{Name:'minecraft:spruce_stairs',Properties:{facing:'south',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2151, "{Name:'minecraft:spruce_stairs',Properties:{facing:'north',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2160, "{Name:'minecraft:birch_stairs',Properties:{facing:'east',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2161, "{Name:'minecraft:birch_stairs',Properties:{facing:'west',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2162, "{Name:'minecraft:birch_stairs',Properties:{facing:'south',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2163, "{Name:'minecraft:birch_stairs',Properties:{facing:'north',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2164, "{Name:'minecraft:birch_stairs',Properties:{facing:'east',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2165, "{Name:'minecraft:birch_stairs',Properties:{facing:'west',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2166, "{Name:'minecraft:birch_stairs',Properties:{facing:'south',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2167, "{Name:'minecraft:birch_stairs',Properties:{facing:'north',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2176, "{Name:'minecraft:jungle_stairs',Properties:{facing:'east',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2177, "{Name:'minecraft:jungle_stairs',Properties:{facing:'west',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2178, "{Name:'minecraft:jungle_stairs',Properties:{facing:'south',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2179, "{Name:'minecraft:jungle_stairs',Properties:{facing:'north',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2180, "{Name:'minecraft:jungle_stairs',Properties:{facing:'east',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2181, "{Name:'minecraft:jungle_stairs',Properties:{facing:'west',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2182, "{Name:'minecraft:jungle_stairs',Properties:{facing:'south',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2183, "{Name:'minecraft:jungle_stairs',Properties:{facing:'north',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2192, "{Name:'minecraft:command_block',Properties:{conditional:'false',facing:'down'}}");
        BlockIdConverter.register(2193, "{Name:'minecraft:command_block',Properties:{conditional:'false',facing:'up'}}");
        BlockIdConverter.register(2194, "{Name:'minecraft:command_block',Properties:{conditional:'false',facing:'north'}}");
        BlockIdConverter.register(2195, "{Name:'minecraft:command_block',Properties:{conditional:'false',facing:'south'}}");
        BlockIdConverter.register(2196, "{Name:'minecraft:command_block',Properties:{conditional:'false',facing:'west'}}");
        BlockIdConverter.register(2197, "{Name:'minecraft:command_block',Properties:{conditional:'false',facing:'east'}}");
        BlockIdConverter.register(2200, "{Name:'minecraft:command_block',Properties:{conditional:'true',facing:'down'}}");
        BlockIdConverter.register(2201, "{Name:'minecraft:command_block',Properties:{conditional:'true',facing:'up'}}");
        BlockIdConverter.register(2202, "{Name:'minecraft:command_block',Properties:{conditional:'true',facing:'north'}}");
        BlockIdConverter.register(2203, "{Name:'minecraft:command_block',Properties:{conditional:'true',facing:'south'}}");
        BlockIdConverter.register(2204, "{Name:'minecraft:command_block',Properties:{conditional:'true',facing:'west'}}");
        BlockIdConverter.register(2205, "{Name:'minecraft:command_block',Properties:{conditional:'true',facing:'east'}}");
        BlockIdConverter.register(2208, "{Name:'minecraft:beacon'}");
        BlockIdConverter.register(2224, "{Name:'minecraft:cobblestone_wall',Properties:{east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(2225, "{Name:'minecraft:mossy_cobblestone_wall',Properties:{east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(2240, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2241, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2242, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2243, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2244, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2245, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2246, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2247, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2248, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2249, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2250, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2251, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2252, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2253, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2254, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2255, "{Name:'minecraft:potted_cactus'}");
        BlockIdConverter.register(2256, "{Name:'minecraft:carrots',Properties:{age:'0'}}");
        BlockIdConverter.register(2257, "{Name:'minecraft:carrots',Properties:{age:'1'}}");
        BlockIdConverter.register(2258, "{Name:'minecraft:carrots',Properties:{age:'2'}}");
        BlockIdConverter.register(2259, "{Name:'minecraft:carrots',Properties:{age:'3'}}");
        BlockIdConverter.register(2260, "{Name:'minecraft:carrots',Properties:{age:'4'}}");
        BlockIdConverter.register(2261, "{Name:'minecraft:carrots',Properties:{age:'5'}}");
        BlockIdConverter.register(2262, "{Name:'minecraft:carrots',Properties:{age:'6'}}");
        BlockIdConverter.register(2263, "{Name:'minecraft:carrots',Properties:{age:'7'}}");
        BlockIdConverter.register(2272, "{Name:'minecraft:potatoes',Properties:{age:'0'}}");
        BlockIdConverter.register(2273, "{Name:'minecraft:potatoes',Properties:{age:'1'}}");
        BlockIdConverter.register(2274, "{Name:'minecraft:potatoes',Properties:{age:'2'}}");
        BlockIdConverter.register(2275, "{Name:'minecraft:potatoes',Properties:{age:'3'}}");
        BlockIdConverter.register(2276, "{Name:'minecraft:potatoes',Properties:{age:'4'}}");
        BlockIdConverter.register(2277, "{Name:'minecraft:potatoes',Properties:{age:'5'}}");
        BlockIdConverter.register(2278, "{Name:'minecraft:potatoes',Properties:{age:'6'}}");
        BlockIdConverter.register(2279, "{Name:'minecraft:potatoes',Properties:{age:'7'}}");
        BlockIdConverter.register(2288, "{Name:'minecraft:oak_button',Properties:{face:'ceiling',facing:'north',powered:'false'}}");
        BlockIdConverter.register(2289, "{Name:'minecraft:oak_button',Properties:{face:'wall',facing:'east',powered:'false'}}");
        BlockIdConverter.register(2290, "{Name:'minecraft:oak_button',Properties:{face:'wall',facing:'west',powered:'false'}}");
        BlockIdConverter.register(2291, "{Name:'minecraft:oak_button',Properties:{face:'wall',facing:'south',powered:'false'}}");
        BlockIdConverter.register(2292, "{Name:'minecraft:oak_button',Properties:{face:'wall',facing:'north',powered:'false'}}");
        BlockIdConverter.register(2293, "{Name:'minecraft:oak_button',Properties:{face:'floor',facing:'north',powered:'false'}}");
        BlockIdConverter.register(2296, "{Name:'minecraft:oak_button',Properties:{face:'ceiling',facing:'north',powered:'true'}}");
        BlockIdConverter.register(2297, "{Name:'minecraft:oak_button',Properties:{face:'wall',facing:'east',powered:'true'}}");
        BlockIdConverter.register(2298, "{Name:'minecraft:oak_button',Properties:{face:'wall',facing:'west',powered:'true'}}");
        BlockIdConverter.register(2299, "{Name:'minecraft:oak_button',Properties:{face:'wall',facing:'south',powered:'true'}}");
        BlockIdConverter.register(2300, "{Name:'minecraft:oak_button',Properties:{face:'wall',facing:'north',powered:'true'}}");
        BlockIdConverter.register(2301, "{Name:'minecraft:oak_button',Properties:{face:'floor',facing:'north',powered:'true'}}");
        BlockIdConverter.register(2304, "{Name:'%%FILTER_ME%%',Properties:{facing:'down',nodrop:'false'}}");
        BlockIdConverter.register(2305, "{Name:'%%FILTER_ME%%',Properties:{facing:'up',nodrop:'false'}}");
        BlockIdConverter.register(2306, "{Name:'%%FILTER_ME%%',Properties:{facing:'north',nodrop:'false'}}");
        BlockIdConverter.register(2307, "{Name:'%%FILTER_ME%%',Properties:{facing:'south',nodrop:'false'}}");
        BlockIdConverter.register(2308, "{Name:'%%FILTER_ME%%',Properties:{facing:'west',nodrop:'false'}}");
        BlockIdConverter.register(2309, "{Name:'%%FILTER_ME%%',Properties:{facing:'east',nodrop:'false'}}");
        BlockIdConverter.register(2312, "{Name:'%%FILTER_ME%%',Properties:{facing:'down',nodrop:'true'}}");
        BlockIdConverter.register(2313, "{Name:'%%FILTER_ME%%',Properties:{facing:'up',nodrop:'true'}}");
        BlockIdConverter.register(2314, "{Name:'%%FILTER_ME%%',Properties:{facing:'north',nodrop:'true'}}");
        BlockIdConverter.register(2315, "{Name:'%%FILTER_ME%%',Properties:{facing:'south',nodrop:'true'}}");
        BlockIdConverter.register(2316, "{Name:'%%FILTER_ME%%',Properties:{facing:'west',nodrop:'true'}}");
        BlockIdConverter.register(2317, "{Name:'%%FILTER_ME%%',Properties:{facing:'east',nodrop:'true'}}");
        BlockIdConverter.register(2320, "{Name:'minecraft:anvil',Properties:{facing:'south'}}");
        BlockIdConverter.register(2321, "{Name:'minecraft:anvil',Properties:{facing:'west'}}");
        BlockIdConverter.register(2322, "{Name:'minecraft:anvil',Properties:{facing:'north'}}");
        BlockIdConverter.register(2323, "{Name:'minecraft:anvil',Properties:{facing:'east'}}");
        BlockIdConverter.register(2324, "{Name:'minecraft:chipped_anvil',Properties:{facing:'south'}}");
        BlockIdConverter.register(2325, "{Name:'minecraft:chipped_anvil',Properties:{facing:'west'}}");
        BlockIdConverter.register(2326, "{Name:'minecraft:chipped_anvil',Properties:{facing:'north'}}");
        BlockIdConverter.register(2327, "{Name:'minecraft:chipped_anvil',Properties:{facing:'east'}}");
        BlockIdConverter.register(2328, "{Name:'minecraft:damaged_anvil',Properties:{facing:'south'}}");
        BlockIdConverter.register(2329, "{Name:'minecraft:damaged_anvil',Properties:{facing:'west'}}");
        BlockIdConverter.register(2330, "{Name:'minecraft:damaged_anvil',Properties:{facing:'north'}}");
        BlockIdConverter.register(2331, "{Name:'minecraft:damaged_anvil',Properties:{facing:'east'}}");
        BlockIdConverter.register(2338, "{Name:'minecraft:trapped_chest',Properties:{facing:'north',type:'single'}}");
        BlockIdConverter.register(2339, "{Name:'minecraft:trapped_chest',Properties:{facing:'south',type:'single'}}");
        BlockIdConverter.register(2340, "{Name:'minecraft:trapped_chest',Properties:{facing:'west',type:'single'}}");
        BlockIdConverter.register(2341, "{Name:'minecraft:trapped_chest',Properties:{facing:'east',type:'single'}}");
        BlockIdConverter.register(2352, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'0'}}");
        BlockIdConverter.register(2353, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'1'}}");
        BlockIdConverter.register(2354, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'2'}}");
        BlockIdConverter.register(2355, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'3'}}");
        BlockIdConverter.register(2356, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'4'}}");
        BlockIdConverter.register(2357, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'5'}}");
        BlockIdConverter.register(2358, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'6'}}");
        BlockIdConverter.register(2359, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'7'}}");
        BlockIdConverter.register(2360, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'8'}}");
        BlockIdConverter.register(2361, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'9'}}");
        BlockIdConverter.register(2362, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'10'}}");
        BlockIdConverter.register(2363, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'11'}}");
        BlockIdConverter.register(2364, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'12'}}");
        BlockIdConverter.register(2365, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'13'}}");
        BlockIdConverter.register(2366, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'14'}}");
        BlockIdConverter.register(2367, "{Name:'minecraft:light_weighted_pressure_plate',Properties:{power:'15'}}");
        BlockIdConverter.register(2368, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'0'}}");
        BlockIdConverter.register(2369, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'1'}}");
        BlockIdConverter.register(2370, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'2'}}");
        BlockIdConverter.register(2371, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'3'}}");
        BlockIdConverter.register(2372, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'4'}}");
        BlockIdConverter.register(2373, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'5'}}");
        BlockIdConverter.register(2374, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'6'}}");
        BlockIdConverter.register(2375, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'7'}}");
        BlockIdConverter.register(2376, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'8'}}");
        BlockIdConverter.register(2377, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'9'}}");
        BlockIdConverter.register(2378, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'10'}}");
        BlockIdConverter.register(2379, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'11'}}");
        BlockIdConverter.register(2380, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'12'}}");
        BlockIdConverter.register(2381, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'13'}}");
        BlockIdConverter.register(2382, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'14'}}");
        BlockIdConverter.register(2383, "{Name:'minecraft:heavy_weighted_pressure_plate',Properties:{power:'15'}}");
        BlockIdConverter.register(2384, "{Name:'minecraft:comparator',Properties:{facing:'south',mode:'compare',powered:'false'}}");
        BlockIdConverter.register(2385, "{Name:'minecraft:comparator',Properties:{facing:'west',mode:'compare',powered:'false'}}");
        BlockIdConverter.register(2386, "{Name:'minecraft:comparator',Properties:{facing:'north',mode:'compare',powered:'false'}}");
        BlockIdConverter.register(2387, "{Name:'minecraft:comparator',Properties:{facing:'east',mode:'compare',powered:'false'}}");
        BlockIdConverter.register(2388, "{Name:'minecraft:comparator',Properties:{facing:'south',mode:'subtract',powered:'false'}}");
        BlockIdConverter.register(2389, "{Name:'minecraft:comparator',Properties:{facing:'west',mode:'subtract',powered:'false'}}");
        BlockIdConverter.register(2390, "{Name:'minecraft:comparator',Properties:{facing:'north',mode:'subtract',powered:'false'}}");
        BlockIdConverter.register(2391, "{Name:'minecraft:comparator',Properties:{facing:'east',mode:'subtract',powered:'false'}}");
        BlockIdConverter.register(2392, "{Name:'minecraft:comparator',Properties:{facing:'south',mode:'compare',powered:'true'}}");
        BlockIdConverter.register(2393, "{Name:'minecraft:comparator',Properties:{facing:'west',mode:'compare',powered:'true'}}");
        BlockIdConverter.register(2394, "{Name:'minecraft:comparator',Properties:{facing:'north',mode:'compare',powered:'true'}}");
        BlockIdConverter.register(2395, "{Name:'minecraft:comparator',Properties:{facing:'east',mode:'compare',powered:'true'}}");
        BlockIdConverter.register(2396, "{Name:'minecraft:comparator',Properties:{facing:'south',mode:'subtract',powered:'true'}}");
        BlockIdConverter.register(2397, "{Name:'minecraft:comparator',Properties:{facing:'west',mode:'subtract',powered:'true'}}");
        BlockIdConverter.register(2398, "{Name:'minecraft:comparator',Properties:{facing:'north',mode:'subtract',powered:'true'}}");
        BlockIdConverter.register(2399, "{Name:'minecraft:comparator',Properties:{facing:'east',mode:'subtract',powered:'true'}}");
        BlockIdConverter.register(2400, "{Name:'minecraft:comparator',Properties:{facing:'south',mode:'compare',powered:'false'}}");
        BlockIdConverter.register(2401, "{Name:'minecraft:comparator',Properties:{facing:'west',mode:'compare',powered:'false'}}");
        BlockIdConverter.register(2402, "{Name:'minecraft:comparator',Properties:{facing:'north',mode:'compare',powered:'false'}}");
        BlockIdConverter.register(2403, "{Name:'minecraft:comparator',Properties:{facing:'east',mode:'compare',powered:'false'}}");
        BlockIdConverter.register(2404, "{Name:'minecraft:comparator',Properties:{facing:'south',mode:'subtract',powered:'false'}}");
        BlockIdConverter.register(2405, "{Name:'minecraft:comparator',Properties:{facing:'west',mode:'subtract',powered:'false'}}");
        BlockIdConverter.register(2406, "{Name:'minecraft:comparator',Properties:{facing:'north',mode:'subtract',powered:'false'}}");
        BlockIdConverter.register(2407, "{Name:'minecraft:comparator',Properties:{facing:'east',mode:'subtract',powered:'false'}}");
        BlockIdConverter.register(2408, "{Name:'minecraft:comparator',Properties:{facing:'south',mode:'compare',powered:'true'}}");
        BlockIdConverter.register(2409, "{Name:'minecraft:comparator',Properties:{facing:'west',mode:'compare',powered:'true'}}");
        BlockIdConverter.register(2410, "{Name:'minecraft:comparator',Properties:{facing:'north',mode:'compare',powered:'true'}}");
        BlockIdConverter.register(2411, "{Name:'minecraft:comparator',Properties:{facing:'east',mode:'compare',powered:'true'}}");
        BlockIdConverter.register(2412, "{Name:'minecraft:comparator',Properties:{facing:'south',mode:'subtract',powered:'true'}}");
        BlockIdConverter.register(2413, "{Name:'minecraft:comparator',Properties:{facing:'west',mode:'subtract',powered:'true'}}");
        BlockIdConverter.register(2414, "{Name:'minecraft:comparator',Properties:{facing:'north',mode:'subtract',powered:'true'}}");
        BlockIdConverter.register(2415, "{Name:'minecraft:comparator',Properties:{facing:'east',mode:'subtract',powered:'true'}}");
        BlockIdConverter.register(2416, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'0'}}");
        BlockIdConverter.register(2417, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'1'}}");
        BlockIdConverter.register(2418, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'2'}}");
        BlockIdConverter.register(2419, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'3'}}");
        BlockIdConverter.register(2420, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'4'}}");
        BlockIdConverter.register(2421, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'5'}}");
        BlockIdConverter.register(2422, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'6'}}");
        BlockIdConverter.register(2423, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'7'}}");
        BlockIdConverter.register(2424, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'8'}}");
        BlockIdConverter.register(2425, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'9'}}");
        BlockIdConverter.register(2426, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'10'}}");
        BlockIdConverter.register(2427, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'11'}}");
        BlockIdConverter.register(2428, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'12'}}");
        BlockIdConverter.register(2429, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'13'}}");
        BlockIdConverter.register(2430, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'14'}}");
        BlockIdConverter.register(2431, "{Name:'minecraft:daylight_detector',Properties:{inverted:'false',power:'15'}}");
        BlockIdConverter.register(2432, "{Name:'minecraft:redstone_block'}");
        BlockIdConverter.register(2448, "{Name:'minecraft:nether_quartz_ore'}");
        BlockIdConverter.register(2464, "{Name:'minecraft:hopper',Properties:{enabled:'true',facing:'down'}}");
        BlockIdConverter.register(2466, "{Name:'minecraft:hopper',Properties:{enabled:'true',facing:'north'}}");
        BlockIdConverter.register(2467, "{Name:'minecraft:hopper',Properties:{enabled:'true',facing:'south'}}");
        BlockIdConverter.register(2468, "{Name:'minecraft:hopper',Properties:{enabled:'true',facing:'west'}}");
        BlockIdConverter.register(2469, "{Name:'minecraft:hopper',Properties:{enabled:'true',facing:'east'}}");
        BlockIdConverter.register(2472, "{Name:'minecraft:hopper',Properties:{enabled:'false',facing:'down'}}");
        BlockIdConverter.register(2474, "{Name:'minecraft:hopper',Properties:{enabled:'false',facing:'north'}}");
        BlockIdConverter.register(2475, "{Name:'minecraft:hopper',Properties:{enabled:'false',facing:'south'}}");
        BlockIdConverter.register(2476, "{Name:'minecraft:hopper',Properties:{enabled:'false',facing:'west'}}");
        BlockIdConverter.register(2477, "{Name:'minecraft:hopper',Properties:{enabled:'false',facing:'east'}}");
        BlockIdConverter.register(2480, "{Name:'minecraft:quartz_block'}");
        BlockIdConverter.register(2481, "{Name:'minecraft:chiseled_quartz_block'}");
        BlockIdConverter.register(2482, "{Name:'minecraft:quartz_pillar',Properties:{axis:'y'}}");
        BlockIdConverter.register(2483, "{Name:'minecraft:quartz_pillar',Properties:{axis:'x'}}");
        BlockIdConverter.register(2484, "{Name:'minecraft:quartz_pillar',Properties:{axis:'z'}}");
        BlockIdConverter.register(2496, "{Name:'minecraft:quartz_stairs',Properties:{facing:'east',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2497, "{Name:'minecraft:quartz_stairs',Properties:{facing:'west',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2498, "{Name:'minecraft:quartz_stairs',Properties:{facing:'south',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2499, "{Name:'minecraft:quartz_stairs',Properties:{facing:'north',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2500, "{Name:'minecraft:quartz_stairs',Properties:{facing:'east',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2501, "{Name:'minecraft:quartz_stairs',Properties:{facing:'west',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2502, "{Name:'minecraft:quartz_stairs',Properties:{facing:'south',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2503, "{Name:'minecraft:quartz_stairs',Properties:{facing:'north',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2512, "{Name:'minecraft:activator_rail',Properties:{powered:'false',shape:'north_south'}}");
        BlockIdConverter.register(2513, "{Name:'minecraft:activator_rail',Properties:{powered:'false',shape:'east_west'}}");
        BlockIdConverter.register(2514, "{Name:'minecraft:activator_rail',Properties:{powered:'false',shape:'ascending_east'}}");
        BlockIdConverter.register(2515, "{Name:'minecraft:activator_rail',Properties:{powered:'false',shape:'ascending_west'}}");
        BlockIdConverter.register(2516, "{Name:'minecraft:activator_rail',Properties:{powered:'false',shape:'ascending_north'}}");
        BlockIdConverter.register(2517, "{Name:'minecraft:activator_rail',Properties:{powered:'false',shape:'ascending_south'}}");
        BlockIdConverter.register(2520, "{Name:'minecraft:activator_rail',Properties:{powered:'true',shape:'north_south'}}");
        BlockIdConverter.register(2521, "{Name:'minecraft:activator_rail',Properties:{powered:'true',shape:'east_west'}}");
        BlockIdConverter.register(2522, "{Name:'minecraft:activator_rail',Properties:{powered:'true',shape:'ascending_east'}}");
        BlockIdConverter.register(2523, "{Name:'minecraft:activator_rail',Properties:{powered:'true',shape:'ascending_west'}}");
        BlockIdConverter.register(2524, "{Name:'minecraft:activator_rail',Properties:{powered:'true',shape:'ascending_north'}}");
        BlockIdConverter.register(2525, "{Name:'minecraft:activator_rail',Properties:{powered:'true',shape:'ascending_south'}}");
        BlockIdConverter.register(2528, "{Name:'minecraft:dropper',Properties:{facing:'down',triggered:'false'}}");
        BlockIdConverter.register(2529, "{Name:'minecraft:dropper',Properties:{facing:'up',triggered:'false'}}");
        BlockIdConverter.register(2530, "{Name:'minecraft:dropper',Properties:{facing:'north',triggered:'false'}}");
        BlockIdConverter.register(2531, "{Name:'minecraft:dropper',Properties:{facing:'south',triggered:'false'}}");
        BlockIdConverter.register(2532, "{Name:'minecraft:dropper',Properties:{facing:'west',triggered:'false'}}");
        BlockIdConverter.register(2533, "{Name:'minecraft:dropper',Properties:{facing:'east',triggered:'false'}}");
        BlockIdConverter.register(2536, "{Name:'minecraft:dropper',Properties:{facing:'down',triggered:'true'}}");
        BlockIdConverter.register(2537, "{Name:'minecraft:dropper',Properties:{facing:'up',triggered:'true'}}");
        BlockIdConverter.register(2538, "{Name:'minecraft:dropper',Properties:{facing:'north',triggered:'true'}}");
        BlockIdConverter.register(2539, "{Name:'minecraft:dropper',Properties:{facing:'south',triggered:'true'}}");
        BlockIdConverter.register(2540, "{Name:'minecraft:dropper',Properties:{facing:'west',triggered:'true'}}");
        BlockIdConverter.register(2541, "{Name:'minecraft:dropper',Properties:{facing:'east',triggered:'true'}}");
        BlockIdConverter.register(2544, "{Name:'minecraft:white_terracotta'}");
        BlockIdConverter.register(2545, "{Name:'minecraft:orange_terracotta'}");
        BlockIdConverter.register(2546, "{Name:'minecraft:magenta_terracotta'}");
        BlockIdConverter.register(2547, "{Name:'minecraft:light_blue_terracotta'}");
        BlockIdConverter.register(2548, "{Name:'minecraft:yellow_terracotta'}");
        BlockIdConverter.register(2549, "{Name:'minecraft:lime_terracotta'}");
        BlockIdConverter.register(2550, "{Name:'minecraft:pink_terracotta'}");
        BlockIdConverter.register(2551, "{Name:'minecraft:gray_terracotta'}");
        BlockIdConverter.register(2552, "{Name:'minecraft:light_gray_terracotta'}");
        BlockIdConverter.register(2553, "{Name:'minecraft:cyan_terracotta'}");
        BlockIdConverter.register(2554, "{Name:'minecraft:purple_terracotta'}");
        BlockIdConverter.register(2555, "{Name:'minecraft:blue_terracotta'}");
        BlockIdConverter.register(2556, "{Name:'minecraft:brown_terracotta'}");
        BlockIdConverter.register(2557, "{Name:'minecraft:green_terracotta'}");
        BlockIdConverter.register(2558, "{Name:'minecraft:red_terracotta'}");
        BlockIdConverter.register(2559, "{Name:'minecraft:black_terracotta'}");
        BlockIdConverter.register(2560, "{Name:'minecraft:white_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2561, "{Name:'minecraft:orange_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2562, "{Name:'minecraft:magenta_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2563, "{Name:'minecraft:light_blue_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2564, "{Name:'minecraft:yellow_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2565, "{Name:'minecraft:lime_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2566, "{Name:'minecraft:pink_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2567, "{Name:'minecraft:gray_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2568, "{Name:'minecraft:light_gray_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2569, "{Name:'minecraft:cyan_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2570, "{Name:'minecraft:purple_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2571, "{Name:'minecraft:blue_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2572, "{Name:'minecraft:brown_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2573, "{Name:'minecraft:green_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2574, "{Name:'minecraft:red_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2575, "{Name:'minecraft:black_stained_glass_pane',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(2576, "{Name:'minecraft:acacia_leaves',Properties:{check_decay:'false',decayable:'true'}}");
        BlockIdConverter.register(2577, "{Name:'minecraft:dark_oak_leaves',Properties:{check_decay:'false',decayable:'true'}}");
        BlockIdConverter.register(2580, "{Name:'minecraft:acacia_leaves',Properties:{check_decay:'false',decayable:'false'}}");
        BlockIdConverter.register(2581, "{Name:'minecraft:dark_oak_leaves',Properties:{check_decay:'false',decayable:'false'}}");
        BlockIdConverter.register(2584, "{Name:'minecraft:acacia_leaves',Properties:{check_decay:'true',decayable:'true'}}");
        BlockIdConverter.register(2585, "{Name:'minecraft:dark_oak_leaves',Properties:{check_decay:'true',decayable:'true'}}");
        BlockIdConverter.register(2588, "{Name:'minecraft:acacia_leaves',Properties:{check_decay:'true',decayable:'false'}}");
        BlockIdConverter.register(2589, "{Name:'minecraft:dark_oak_leaves',Properties:{check_decay:'true',decayable:'false'}}");
        BlockIdConverter.register(2592, "{Name:'minecraft:acacia_log',Properties:{axis:'y'}}");
        BlockIdConverter.register(2593, "{Name:'minecraft:dark_oak_log',Properties:{axis:'y'}}");
        BlockIdConverter.register(2596, "{Name:'minecraft:acacia_log',Properties:{axis:'x'}}");
        BlockIdConverter.register(2597, "{Name:'minecraft:dark_oak_log',Properties:{axis:'x'}}");
        BlockIdConverter.register(2600, "{Name:'minecraft:acacia_log',Properties:{axis:'z'}}");
        BlockIdConverter.register(2601, "{Name:'minecraft:dark_oak_log',Properties:{axis:'z'}}");
        BlockIdConverter.register(2604, "{Name:'minecraft:acacia_bark'}");
        BlockIdConverter.register(2605, "{Name:'minecraft:dark_oak_bark'}");
        BlockIdConverter.register(2608, "{Name:'minecraft:acacia_stairs',Properties:{facing:'east',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2609, "{Name:'minecraft:acacia_stairs',Properties:{facing:'west',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2610, "{Name:'minecraft:acacia_stairs',Properties:{facing:'south',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2611, "{Name:'minecraft:acacia_stairs',Properties:{facing:'north',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2612, "{Name:'minecraft:acacia_stairs',Properties:{facing:'east',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2613, "{Name:'minecraft:acacia_stairs',Properties:{facing:'west',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2614, "{Name:'minecraft:acacia_stairs',Properties:{facing:'south',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2615, "{Name:'minecraft:acacia_stairs',Properties:{facing:'north',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2624, "{Name:'minecraft:dark_oak_stairs',Properties:{facing:'east',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2625, "{Name:'minecraft:dark_oak_stairs',Properties:{facing:'west',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2626, "{Name:'minecraft:dark_oak_stairs',Properties:{facing:'south',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2627, "{Name:'minecraft:dark_oak_stairs',Properties:{facing:'north',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2628, "{Name:'minecraft:dark_oak_stairs',Properties:{facing:'east',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2629, "{Name:'minecraft:dark_oak_stairs',Properties:{facing:'west',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2630, "{Name:'minecraft:dark_oak_stairs',Properties:{facing:'south',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2631, "{Name:'minecraft:dark_oak_stairs',Properties:{facing:'north',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2640, "{Name:'minecraft:slime_block'}");
        BlockIdConverter.register(2656, "{Name:'minecraft:barrier'}");
        BlockIdConverter.register(2672, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'north',half:'bottom',open:'false'}}");
        BlockIdConverter.register(2673, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'south',half:'bottom',open:'false'}}");
        BlockIdConverter.register(2674, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'west',half:'bottom',open:'false'}}");
        BlockIdConverter.register(2675, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'east',half:'bottom',open:'false'}}");
        BlockIdConverter.register(2676, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'north',half:'bottom',open:'true'}}");
        BlockIdConverter.register(2677, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'south',half:'bottom',open:'true'}}");
        BlockIdConverter.register(2678, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'west',half:'bottom',open:'true'}}");
        BlockIdConverter.register(2679, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'east',half:'bottom',open:'true'}}");
        BlockIdConverter.register(2680, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'north',half:'top',open:'false'}}");
        BlockIdConverter.register(2681, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'south',half:'top',open:'false'}}");
        BlockIdConverter.register(2682, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'west',half:'top',open:'false'}}");
        BlockIdConverter.register(2683, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'east',half:'top',open:'false'}}");
        BlockIdConverter.register(2684, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'north',half:'top',open:'true'}}");
        BlockIdConverter.register(2685, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'south',half:'top',open:'true'}}");
        BlockIdConverter.register(2686, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'west',half:'top',open:'true'}}");
        BlockIdConverter.register(2687, "{Name:'minecraft:iron_trapdoor',Properties:{facing:'east',half:'top',open:'true'}}");
        BlockIdConverter.register(2688, "{Name:'minecraft:prismarine'}");
        BlockIdConverter.register(2689, "{Name:'minecraft:prismarine_bricks'}");
        BlockIdConverter.register(2690, "{Name:'minecraft:dark_prismarine'}");
        BlockIdConverter.register(2704, "{Name:'minecraft:sea_lantern'}");
        BlockIdConverter.register(2720, "{Name:'minecraft:hay_block',Properties:{axis:'y'}}");
        BlockIdConverter.register(2724, "{Name:'minecraft:hay_block',Properties:{axis:'x'}}");
        BlockIdConverter.register(2728, "{Name:'minecraft:hay_block',Properties:{axis:'z'}}");
        BlockIdConverter.register(2736, "{Name:'minecraft:white_carpet'}");
        BlockIdConverter.register(2737, "{Name:'minecraft:orange_carpet'}");
        BlockIdConverter.register(2738, "{Name:'minecraft:magenta_carpet'}");
        BlockIdConverter.register(2739, "{Name:'minecraft:light_blue_carpet'}");
        BlockIdConverter.register(2740, "{Name:'minecraft:yellow_carpet'}");
        BlockIdConverter.register(2741, "{Name:'minecraft:lime_carpet'}");
        BlockIdConverter.register(2742, "{Name:'minecraft:pink_carpet'}");
        BlockIdConverter.register(2743, "{Name:'minecraft:gray_carpet'}");
        BlockIdConverter.register(2744, "{Name:'minecraft:light_gray_carpet'}");
        BlockIdConverter.register(2745, "{Name:'minecraft:cyan_carpet'}");
        BlockIdConverter.register(2746, "{Name:'minecraft:purple_carpet'}");
        BlockIdConverter.register(2747, "{Name:'minecraft:blue_carpet'}");
        BlockIdConverter.register(2748, "{Name:'minecraft:brown_carpet'}");
        BlockIdConverter.register(2749, "{Name:'minecraft:green_carpet'}");
        BlockIdConverter.register(2750, "{Name:'minecraft:red_carpet'}");
        BlockIdConverter.register(2751, "{Name:'minecraft:black_carpet'}");
        BlockIdConverter.register(2752, "{Name:'minecraft:terracotta'}");
        BlockIdConverter.register(2768, "{Name:'minecraft:coal_block'}");
        BlockIdConverter.register(2784, "{Name:'minecraft:packed_ice'}");
        BlockIdConverter.register(2800, "{Name:'minecraft:sunflower',Properties:{half:'lower'}}");
        BlockIdConverter.register(2801, "{Name:'minecraft:lilac',Properties:{half:'lower'}}");
        BlockIdConverter.register(2802, "{Name:'minecraft:tall_grass',Properties:{half:'lower'}}");
        BlockIdConverter.register(2803, "{Name:'minecraft:large_fern',Properties:{half:'lower'}}");
        BlockIdConverter.register(2804, "{Name:'minecraft:rose_bush',Properties:{half:'lower'}}");
        BlockIdConverter.register(2805, "{Name:'minecraft:peony',Properties:{half:'lower'}}");
        BlockIdConverter.register(2808, "{Name:'minecraft:peony',Properties:{half:'upper'}}");
        BlockIdConverter.register(2809, "{Name:'minecraft:peony',Properties:{half:'upper'}}");
        BlockIdConverter.register(2810, "{Name:'minecraft:peony',Properties:{half:'upper'}}");
        BlockIdConverter.register(2811, "{Name:'minecraft:peony',Properties:{half:'upper'}}");
        BlockIdConverter.register(2816, "{Name:'minecraft:white_banner',Properties:{rotation:'0'}}");
        BlockIdConverter.register(2817, "{Name:'minecraft:white_banner',Properties:{rotation:'1'}}");
        BlockIdConverter.register(2818, "{Name:'minecraft:white_banner',Properties:{rotation:'2'}}");
        BlockIdConverter.register(2819, "{Name:'minecraft:white_banner',Properties:{rotation:'3'}}");
        BlockIdConverter.register(2820, "{Name:'minecraft:white_banner',Properties:{rotation:'4'}}");
        BlockIdConverter.register(2821, "{Name:'minecraft:white_banner',Properties:{rotation:'5'}}");
        BlockIdConverter.register(2822, "{Name:'minecraft:white_banner',Properties:{rotation:'6'}}");
        BlockIdConverter.register(2823, "{Name:'minecraft:white_banner',Properties:{rotation:'7'}}");
        BlockIdConverter.register(2824, "{Name:'minecraft:white_banner',Properties:{rotation:'8'}}");
        BlockIdConverter.register(2825, "{Name:'minecraft:white_banner',Properties:{rotation:'9'}}");
        BlockIdConverter.register(2826, "{Name:'minecraft:white_banner',Properties:{rotation:'10'}}");
        BlockIdConverter.register(2827, "{Name:'minecraft:white_banner',Properties:{rotation:'11'}}");
        BlockIdConverter.register(2828, "{Name:'minecraft:white_banner',Properties:{rotation:'12'}}");
        BlockIdConverter.register(2829, "{Name:'minecraft:white_banner',Properties:{rotation:'13'}}");
        BlockIdConverter.register(2830, "{Name:'minecraft:white_banner',Properties:{rotation:'14'}}");
        BlockIdConverter.register(2831, "{Name:'minecraft:white_banner',Properties:{rotation:'15'}}");
        BlockIdConverter.register(2834, "{Name:'minecraft:white_wall_banner',Properties:{facing:'north'}}");
        BlockIdConverter.register(2835, "{Name:'minecraft:white_wall_banner',Properties:{facing:'south'}}");
        BlockIdConverter.register(2836, "{Name:'minecraft:white_wall_banner',Properties:{facing:'west'}}");
        BlockIdConverter.register(2837, "{Name:'minecraft:white_wall_banner',Properties:{facing:'east'}}");
        BlockIdConverter.register(2848, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'0'}}");
        BlockIdConverter.register(2849, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'1'}}");
        BlockIdConverter.register(2850, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'2'}}");
        BlockIdConverter.register(2851, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'3'}}");
        BlockIdConverter.register(2852, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'4'}}");
        BlockIdConverter.register(2853, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'5'}}");
        BlockIdConverter.register(2854, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'6'}}");
        BlockIdConverter.register(2855, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'7'}}");
        BlockIdConverter.register(2856, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'8'}}");
        BlockIdConverter.register(2857, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'9'}}");
        BlockIdConverter.register(2858, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'10'}}");
        BlockIdConverter.register(2859, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'11'}}");
        BlockIdConverter.register(2860, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'12'}}");
        BlockIdConverter.register(2861, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'13'}}");
        BlockIdConverter.register(2862, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'14'}}");
        BlockIdConverter.register(2863, "{Name:'minecraft:daylight_detector',Properties:{inverted:'true',power:'15'}}");
        BlockIdConverter.register(2864, "{Name:'minecraft:red_sandstone'}");
        BlockIdConverter.register(2865, "{Name:'minecraft:chiseled_red_sandstone'}");
        BlockIdConverter.register(2866, "{Name:'minecraft:cut_red_sandstone'}");
        BlockIdConverter.register(2880, "{Name:'minecraft:red_sandstone_stairs',Properties:{facing:'east',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2881, "{Name:'minecraft:red_sandstone_stairs',Properties:{facing:'west',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2882, "{Name:'minecraft:red_sandstone_stairs',Properties:{facing:'south',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2883, "{Name:'minecraft:red_sandstone_stairs',Properties:{facing:'north',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(2884, "{Name:'minecraft:red_sandstone_stairs',Properties:{facing:'east',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2885, "{Name:'minecraft:red_sandstone_stairs',Properties:{facing:'west',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2886, "{Name:'minecraft:red_sandstone_stairs',Properties:{facing:'south',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2887, "{Name:'minecraft:red_sandstone_stairs',Properties:{facing:'north',half:'top',shape:'straight'}}");
        BlockIdConverter.register(2896, "{Name:'minecraft:red_sandstone_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(2904, "{Name:'minecraft:smooth_red_sandstone'}");
        BlockIdConverter.register(2912, "{Name:'minecraft:red_sandstone_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(2920, "{Name:'minecraft:red_sandstone_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(2928, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'south',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2929, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'west',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2930, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'north',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2931, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'east',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2932, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'south',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2933, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'west',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2934, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'north',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2935, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'east',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2936, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'south',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2937, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'west',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2938, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'north',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2939, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'east',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2940, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'south',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2941, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'west',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2942, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'north',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2943, "{Name:'minecraft:spruce_fence_gate',Properties:{facing:'east',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2944, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'south',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2945, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'west',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2946, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'north',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2947, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'east',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2948, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'south',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2949, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'west',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2950, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'north',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2951, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'east',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2952, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'south',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2953, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'west',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2954, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'north',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2955, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'east',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2956, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'south',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2957, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'west',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2958, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'north',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2959, "{Name:'minecraft:birch_fence_gate',Properties:{facing:'east',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2960, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'south',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2961, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'west',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2962, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'north',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2963, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'east',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2964, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'south',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2965, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'west',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2966, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'north',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2967, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'east',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2968, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'south',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2969, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'west',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2970, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'north',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2971, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'east',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2972, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'south',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2973, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'west',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2974, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'north',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2975, "{Name:'minecraft:jungle_fence_gate',Properties:{facing:'east',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2976, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'south',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2977, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'west',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2978, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'north',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2979, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'east',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2980, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'south',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2981, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'west',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2982, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'north',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2983, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'east',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2984, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'south',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2985, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'west',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2986, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'north',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2987, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'east',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(2988, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'south',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2989, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'west',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2990, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'north',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2991, "{Name:'minecraft:dark_oak_fence_gate',Properties:{facing:'east',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(2992, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'south',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2993, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'west',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2994, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'north',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2995, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'east',in_wall:'false',open:'false',powered:'false'}}");
        BlockIdConverter.register(2996, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'south',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2997, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'west',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2998, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'north',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(2999, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'east',in_wall:'false',open:'true',powered:'false'}}");
        BlockIdConverter.register(3000, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'south',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(3001, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'west',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(3002, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'north',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(3003, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'east',in_wall:'false',open:'false',powered:'true'}}");
        BlockIdConverter.register(3004, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'south',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(3005, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'west',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(3006, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'north',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(3007, "{Name:'minecraft:acacia_fence_gate',Properties:{facing:'east',in_wall:'false',open:'true',powered:'true'}}");
        BlockIdConverter.register(3008, "{Name:'minecraft:spruce_fence',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(3024, "{Name:'minecraft:birch_fence',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(3040, "{Name:'minecraft:jungle_fence',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(3056, "{Name:'minecraft:dark_oak_fence',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(3072, "{Name:'minecraft:acacia_fence',Properties:{east:'false',north:'false',south:'false',west:'false'}}");
        BlockIdConverter.register(3088, "{Name:'minecraft:spruce_door',Properties:{facing:'east',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3089, "{Name:'minecraft:spruce_door',Properties:{facing:'south',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3090, "{Name:'minecraft:spruce_door',Properties:{facing:'west',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3091, "{Name:'minecraft:spruce_door',Properties:{facing:'north',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3092, "{Name:'minecraft:spruce_door',Properties:{facing:'east',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3093, "{Name:'minecraft:spruce_door',Properties:{facing:'south',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3094, "{Name:'minecraft:spruce_door',Properties:{facing:'west',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3095, "{Name:'minecraft:spruce_door',Properties:{facing:'north',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3096, "{Name:'minecraft:spruce_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'false',powered:'false'}}");
        BlockIdConverter.register(3097, "{Name:'minecraft:spruce_door',Properties:{facing:'east',half:'upper',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3098, "{Name:'minecraft:spruce_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'false',powered:'true'}}");
        BlockIdConverter.register(3099, "{Name:'minecraft:spruce_door',Properties:{facing:'east',half:'upper',hinge:'right',open:'false',powered:'true'}}");
        BlockIdConverter.register(3104, "{Name:'minecraft:birch_door',Properties:{facing:'east',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3105, "{Name:'minecraft:birch_door',Properties:{facing:'south',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3106, "{Name:'minecraft:birch_door',Properties:{facing:'west',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3107, "{Name:'minecraft:birch_door',Properties:{facing:'north',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3108, "{Name:'minecraft:birch_door',Properties:{facing:'east',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3109, "{Name:'minecraft:birch_door',Properties:{facing:'south',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3110, "{Name:'minecraft:birch_door',Properties:{facing:'west',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3111, "{Name:'minecraft:birch_door',Properties:{facing:'north',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3112, "{Name:'minecraft:birch_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'false',powered:'false'}}");
        BlockIdConverter.register(3113, "{Name:'minecraft:birch_door',Properties:{facing:'east',half:'upper',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3114, "{Name:'minecraft:birch_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'false',powered:'true'}}");
        BlockIdConverter.register(3115, "{Name:'minecraft:birch_door',Properties:{facing:'east',half:'upper',hinge:'right',open:'false',powered:'true'}}");
        BlockIdConverter.register(3120, "{Name:'minecraft:jungle_door',Properties:{facing:'east',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3121, "{Name:'minecraft:jungle_door',Properties:{facing:'south',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3122, "{Name:'minecraft:jungle_door',Properties:{facing:'west',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3123, "{Name:'minecraft:jungle_door',Properties:{facing:'north',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3124, "{Name:'minecraft:jungle_door',Properties:{facing:'east',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3125, "{Name:'minecraft:jungle_door',Properties:{facing:'south',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3126, "{Name:'minecraft:jungle_door',Properties:{facing:'west',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3127, "{Name:'minecraft:jungle_door',Properties:{facing:'north',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3128, "{Name:'minecraft:jungle_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'false',powered:'false'}}");
        BlockIdConverter.register(3129, "{Name:'minecraft:jungle_door',Properties:{facing:'east',half:'upper',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3130, "{Name:'minecraft:jungle_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'false',powered:'true'}}");
        BlockIdConverter.register(3131, "{Name:'minecraft:jungle_door',Properties:{facing:'east',half:'upper',hinge:'right',open:'false',powered:'true'}}");
        BlockIdConverter.register(3136, "{Name:'minecraft:acacia_door',Properties:{facing:'east',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3137, "{Name:'minecraft:acacia_door',Properties:{facing:'south',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3138, "{Name:'minecraft:acacia_door',Properties:{facing:'west',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3139, "{Name:'minecraft:acacia_door',Properties:{facing:'north',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3140, "{Name:'minecraft:acacia_door',Properties:{facing:'east',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3141, "{Name:'minecraft:acacia_door',Properties:{facing:'south',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3142, "{Name:'minecraft:acacia_door',Properties:{facing:'west',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3143, "{Name:'minecraft:acacia_door',Properties:{facing:'north',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3144, "{Name:'minecraft:acacia_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'false',powered:'false'}}");
        BlockIdConverter.register(3145, "{Name:'minecraft:acacia_door',Properties:{facing:'east',half:'upper',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3146, "{Name:'minecraft:acacia_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'false',powered:'true'}}");
        BlockIdConverter.register(3147, "{Name:'minecraft:acacia_door',Properties:{facing:'east',half:'upper',hinge:'right',open:'false',powered:'true'}}");
        BlockIdConverter.register(3152, "{Name:'minecraft:dark_oak_door',Properties:{facing:'east',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3153, "{Name:'minecraft:dark_oak_door',Properties:{facing:'south',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3154, "{Name:'minecraft:dark_oak_door',Properties:{facing:'west',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3155, "{Name:'minecraft:dark_oak_door',Properties:{facing:'north',half:'lower',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3156, "{Name:'minecraft:dark_oak_door',Properties:{facing:'east',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3157, "{Name:'minecraft:dark_oak_door',Properties:{facing:'south',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3158, "{Name:'minecraft:dark_oak_door',Properties:{facing:'west',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3159, "{Name:'minecraft:dark_oak_door',Properties:{facing:'north',half:'lower',hinge:'right',open:'true',powered:'false'}}");
        BlockIdConverter.register(3160, "{Name:'minecraft:dark_oak_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'false',powered:'false'}}");
        BlockIdConverter.register(3161, "{Name:'minecraft:dark_oak_door',Properties:{facing:'east',half:'upper',hinge:'right',open:'false',powered:'false'}}");
        BlockIdConverter.register(3162, "{Name:'minecraft:dark_oak_door',Properties:{facing:'east',half:'upper',hinge:'left',open:'false',powered:'true'}}");
        BlockIdConverter.register(3163, "{Name:'minecraft:dark_oak_door',Properties:{facing:'east',half:'upper',hinge:'right',open:'false',powered:'true'}}");
        BlockIdConverter.register(3168, "{Name:'minecraft:end_rod',Properties:{facing:'down'}}");
        BlockIdConverter.register(3169, "{Name:'minecraft:end_rod',Properties:{facing:'up'}}");
        BlockIdConverter.register(3170, "{Name:'minecraft:end_rod',Properties:{facing:'north'}}");
        BlockIdConverter.register(3171, "{Name:'minecraft:end_rod',Properties:{facing:'south'}}");
        BlockIdConverter.register(3172, "{Name:'minecraft:end_rod',Properties:{facing:'west'}}");
        BlockIdConverter.register(3173, "{Name:'minecraft:end_rod',Properties:{facing:'east'}}");
        BlockIdConverter.register(3184, "{Name:'minecraft:chorus_plant',Properties:{down:'false',east:'false',north:'false',south:'false',up:'false',west:'false'}}");
        BlockIdConverter.register(3200, "{Name:'minecraft:chorus_flower',Properties:{age:'0'}}");
        BlockIdConverter.register(3201, "{Name:'minecraft:chorus_flower',Properties:{age:'1'}}");
        BlockIdConverter.register(3202, "{Name:'minecraft:chorus_flower',Properties:{age:'2'}}");
        BlockIdConverter.register(3203, "{Name:'minecraft:chorus_flower',Properties:{age:'3'}}");
        BlockIdConverter.register(3204, "{Name:'minecraft:chorus_flower',Properties:{age:'4'}}");
        BlockIdConverter.register(3205, "{Name:'minecraft:chorus_flower',Properties:{age:'5'}}");
        BlockIdConverter.register(3216, "{Name:'minecraft:purpur_block'}");
        BlockIdConverter.register(3232, "{Name:'minecraft:purpur_pillar',Properties:{axis:'y'}}");
        BlockIdConverter.register(3236, "{Name:'minecraft:purpur_pillar',Properties:{axis:'x'}}");
        BlockIdConverter.register(3240, "{Name:'minecraft:purpur_pillar',Properties:{axis:'z'}}");
        BlockIdConverter.register(3248, "{Name:'minecraft:purpur_stairs',Properties:{facing:'east',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(3249, "{Name:'minecraft:purpur_stairs',Properties:{facing:'west',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(3250, "{Name:'minecraft:purpur_stairs',Properties:{facing:'south',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(3251, "{Name:'minecraft:purpur_stairs',Properties:{facing:'north',half:'bottom',shape:'straight'}}");
        BlockIdConverter.register(3252, "{Name:'minecraft:purpur_stairs',Properties:{facing:'east',half:'top',shape:'straight'}}");
        BlockIdConverter.register(3253, "{Name:'minecraft:purpur_stairs',Properties:{facing:'west',half:'top',shape:'straight'}}");
        BlockIdConverter.register(3254, "{Name:'minecraft:purpur_stairs',Properties:{facing:'south',half:'top',shape:'straight'}}");
        BlockIdConverter.register(3255, "{Name:'minecraft:purpur_stairs',Properties:{facing:'north',half:'top',shape:'straight'}}");
        BlockIdConverter.register(3264, "{Name:'minecraft:purpur_slab',Properties:{type:'double'}}");
        BlockIdConverter.register(3280, "{Name:'minecraft:purpur_slab',Properties:{type:'bottom'}}");
        BlockIdConverter.register(3288, "{Name:'minecraft:purpur_slab',Properties:{type:'top'}}");
        BlockIdConverter.register(3296, "{Name:'minecraft:end_stone_bricks'}");
        BlockIdConverter.register(3312, "{Name:'minecraft:beetroots',Properties:{age:'0'}}");
        BlockIdConverter.register(3313, "{Name:'minecraft:beetroots',Properties:{age:'1'}}");
        BlockIdConverter.register(3314, "{Name:'minecraft:beetroots',Properties:{age:'2'}}");
        BlockIdConverter.register(3315, "{Name:'minecraft:beetroots',Properties:{age:'3'}}");
        BlockIdConverter.register(3328, "{Name:'minecraft:grass_path'}");
        BlockIdConverter.register(3344, "{Name:'minecraft:end_gateway'}");
        BlockIdConverter.register(3360, "{Name:'minecraft:repeating_command_block',Properties:{conditional:'false',facing:'down'}}");
        BlockIdConverter.register(3361, "{Name:'minecraft:repeating_command_block',Properties:{conditional:'false',facing:'up'}}");
        BlockIdConverter.register(3362, "{Name:'minecraft:repeating_command_block',Properties:{conditional:'false',facing:'north'}}");
        BlockIdConverter.register(3363, "{Name:'minecraft:repeating_command_block',Properties:{conditional:'false',facing:'south'}}");
        BlockIdConverter.register(3364, "{Name:'minecraft:repeating_command_block',Properties:{conditional:'false',facing:'west'}}");
        BlockIdConverter.register(3365, "{Name:'minecraft:repeating_command_block',Properties:{conditional:'false',facing:'east'}}");
        BlockIdConverter.register(3368, "{Name:'minecraft:repeating_command_block',Properties:{conditional:'true',facing:'down'}}");
        BlockIdConverter.register(3369, "{Name:'minecraft:repeating_command_block',Properties:{conditional:'true',facing:'up'}}");
        BlockIdConverter.register(3370, "{Name:'minecraft:repeating_command_block',Properties:{conditional:'true',facing:'north'}}");
        BlockIdConverter.register(3371, "{Name:'minecraft:repeating_command_block',Properties:{conditional:'true',facing:'south'}}");
        BlockIdConverter.register(3372, "{Name:'minecraft:repeating_command_block',Properties:{conditional:'true',facing:'west'}}");
        BlockIdConverter.register(3373, "{Name:'minecraft:repeating_command_block',Properties:{conditional:'true',facing:'east'}}");
        BlockIdConverter.register(3376, "{Name:'minecraft:chain_command_block',Properties:{conditional:'false',facing:'down'}}");
        BlockIdConverter.register(3377, "{Name:'minecraft:chain_command_block',Properties:{conditional:'false',facing:'up'}}");
        BlockIdConverter.register(3378, "{Name:'minecraft:chain_command_block',Properties:{conditional:'false',facing:'north'}}");
        BlockIdConverter.register(3379, "{Name:'minecraft:chain_command_block',Properties:{conditional:'false',facing:'south'}}");
        BlockIdConverter.register(3380, "{Name:'minecraft:chain_command_block',Properties:{conditional:'false',facing:'west'}}");
        BlockIdConverter.register(3381, "{Name:'minecraft:chain_command_block',Properties:{conditional:'false',facing:'east'}}");
        BlockIdConverter.register(3384, "{Name:'minecraft:chain_command_block',Properties:{conditional:'true',facing:'down'}}");
        BlockIdConverter.register(3385, "{Name:'minecraft:chain_command_block',Properties:{conditional:'true',facing:'up'}}");
        BlockIdConverter.register(3386, "{Name:'minecraft:chain_command_block',Properties:{conditional:'true',facing:'north'}}");
        BlockIdConverter.register(3387, "{Name:'minecraft:chain_command_block',Properties:{conditional:'true',facing:'south'}}");
        BlockIdConverter.register(3388, "{Name:'minecraft:chain_command_block',Properties:{conditional:'true',facing:'west'}}");
        BlockIdConverter.register(3389, "{Name:'minecraft:chain_command_block',Properties:{conditional:'true',facing:'east'}}");
        BlockIdConverter.register(3392, "{Name:'minecraft:frosted_ice',Properties:{age:'0'}}");
        BlockIdConverter.register(3393, "{Name:'minecraft:frosted_ice',Properties:{age:'1'}}");
        BlockIdConverter.register(3394, "{Name:'minecraft:frosted_ice',Properties:{age:'2'}}");
        BlockIdConverter.register(3395, "{Name:'minecraft:frosted_ice',Properties:{age:'3'}}");
        BlockIdConverter.register(3408, "{Name:'minecraft:magma_block'}");
        BlockIdConverter.register(3424, "{Name:'minecraft:nether_wart_block'}");
        BlockIdConverter.register(3440, "{Name:'minecraft:red_nether_bricks'}");
        BlockIdConverter.register(3456, "{Name:'minecraft:bone_block',Properties:{axis:'y'}}");
        BlockIdConverter.register(3460, "{Name:'minecraft:bone_block',Properties:{axis:'x'}}");
        BlockIdConverter.register(3464, "{Name:'minecraft:bone_block',Properties:{axis:'z'}}");
        BlockIdConverter.register(3472, "{Name:'minecraft:structure_void'}");
        BlockIdConverter.register(3488, "{Name:'minecraft:observer',Properties:{facing:'down',powered:'false'}}");
        BlockIdConverter.register(3489, "{Name:'minecraft:observer',Properties:{facing:'up',powered:'false'}}");
        BlockIdConverter.register(3490, "{Name:'minecraft:observer',Properties:{facing:'north',powered:'false'}}");
        BlockIdConverter.register(3491, "{Name:'minecraft:observer',Properties:{facing:'south',powered:'false'}}");
        BlockIdConverter.register(3492, "{Name:'minecraft:observer',Properties:{facing:'west',powered:'false'}}");
        BlockIdConverter.register(3493, "{Name:'minecraft:observer',Properties:{facing:'east',powered:'false'}}");
        BlockIdConverter.register(3496, "{Name:'minecraft:observer',Properties:{facing:'down',powered:'true'}}");
        BlockIdConverter.register(3497, "{Name:'minecraft:observer',Properties:{facing:'up',powered:'true'}}");
        BlockIdConverter.register(3498, "{Name:'minecraft:observer',Properties:{facing:'north',powered:'true'}}");
        BlockIdConverter.register(3499, "{Name:'minecraft:observer',Properties:{facing:'south',powered:'true'}}");
        BlockIdConverter.register(3500, "{Name:'minecraft:observer',Properties:{facing:'west',powered:'true'}}");
        BlockIdConverter.register(3501, "{Name:'minecraft:observer',Properties:{facing:'east',powered:'true'}}");
        BlockIdConverter.register(3504, "{Name:'minecraft:white_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3505, "{Name:'minecraft:white_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3506, "{Name:'minecraft:white_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3507, "{Name:'minecraft:white_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3508, "{Name:'minecraft:white_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3509, "{Name:'minecraft:white_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3520, "{Name:'minecraft:orange_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3521, "{Name:'minecraft:orange_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3522, "{Name:'minecraft:orange_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3523, "{Name:'minecraft:orange_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3524, "{Name:'minecraft:orange_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3525, "{Name:'minecraft:orange_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3536, "{Name:'minecraft:magenta_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3537, "{Name:'minecraft:magenta_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3538, "{Name:'minecraft:magenta_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3539, "{Name:'minecraft:magenta_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3540, "{Name:'minecraft:magenta_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3541, "{Name:'minecraft:magenta_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3552, "{Name:'minecraft:light_blue_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3553, "{Name:'minecraft:light_blue_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3554, "{Name:'minecraft:light_blue_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3555, "{Name:'minecraft:light_blue_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3556, "{Name:'minecraft:light_blue_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3557, "{Name:'minecraft:light_blue_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3568, "{Name:'minecraft:yellow_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3569, "{Name:'minecraft:yellow_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3570, "{Name:'minecraft:yellow_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3571, "{Name:'minecraft:yellow_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3572, "{Name:'minecraft:yellow_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3573, "{Name:'minecraft:yellow_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3584, "{Name:'minecraft:lime_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3585, "{Name:'minecraft:lime_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3586, "{Name:'minecraft:lime_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3587, "{Name:'minecraft:lime_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3588, "{Name:'minecraft:lime_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3589, "{Name:'minecraft:lime_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3600, "{Name:'minecraft:pink_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3601, "{Name:'minecraft:pink_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3602, "{Name:'minecraft:pink_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3603, "{Name:'minecraft:pink_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3604, "{Name:'minecraft:pink_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3605, "{Name:'minecraft:pink_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3616, "{Name:'minecraft:gray_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3617, "{Name:'minecraft:gray_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3618, "{Name:'minecraft:gray_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3619, "{Name:'minecraft:gray_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3620, "{Name:'minecraft:gray_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3621, "{Name:'minecraft:gray_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3632, "{Name:'minecraft:light_gray_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3633, "{Name:'minecraft:light_gray_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3634, "{Name:'minecraft:light_gray_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3635, "{Name:'minecraft:light_gray_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3636, "{Name:'minecraft:light_gray_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3637, "{Name:'minecraft:light_gray_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3648, "{Name:'minecraft:cyan_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3649, "{Name:'minecraft:cyan_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3650, "{Name:'minecraft:cyan_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3651, "{Name:'minecraft:cyan_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3652, "{Name:'minecraft:cyan_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3653, "{Name:'minecraft:cyan_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3664, "{Name:'minecraft:purple_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3665, "{Name:'minecraft:purple_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3666, "{Name:'minecraft:purple_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3667, "{Name:'minecraft:purple_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3668, "{Name:'minecraft:purple_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3669, "{Name:'minecraft:purple_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3680, "{Name:'minecraft:blue_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3681, "{Name:'minecraft:blue_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3682, "{Name:'minecraft:blue_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3683, "{Name:'minecraft:blue_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3684, "{Name:'minecraft:blue_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3685, "{Name:'minecraft:blue_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3696, "{Name:'minecraft:brown_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3697, "{Name:'minecraft:brown_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3698, "{Name:'minecraft:brown_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3699, "{Name:'minecraft:brown_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3700, "{Name:'minecraft:brown_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3701, "{Name:'minecraft:brown_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3712, "{Name:'minecraft:green_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3713, "{Name:'minecraft:green_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3714, "{Name:'minecraft:green_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3715, "{Name:'minecraft:green_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3716, "{Name:'minecraft:green_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3717, "{Name:'minecraft:green_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3728, "{Name:'minecraft:red_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3729, "{Name:'minecraft:red_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3730, "{Name:'minecraft:red_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3731, "{Name:'minecraft:red_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3732, "{Name:'minecraft:red_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3733, "{Name:'minecraft:red_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3744, "{Name:'minecraft:black_shulker_box',Properties:{facing:'down'}}");
        BlockIdConverter.register(3745, "{Name:'minecraft:black_shulker_box',Properties:{facing:'up'}}");
        BlockIdConverter.register(3746, "{Name:'minecraft:black_shulker_box',Properties:{facing:'north'}}");
        BlockIdConverter.register(3747, "{Name:'minecraft:black_shulker_box',Properties:{facing:'south'}}");
        BlockIdConverter.register(3748, "{Name:'minecraft:black_shulker_box',Properties:{facing:'west'}}");
        BlockIdConverter.register(3749, "{Name:'minecraft:black_shulker_box',Properties:{facing:'east'}}");
        BlockIdConverter.register(3760, "{Name:'minecraft:white_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(3761, "{Name:'minecraft:white_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(3762, "{Name:'minecraft:white_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(3763, "{Name:'minecraft:white_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(3776, "{Name:'minecraft:orange_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(3777, "{Name:'minecraft:orange_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(3778, "{Name:'minecraft:orange_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(3779, "{Name:'minecraft:orange_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(3792, "{Name:'minecraft:magenta_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(3793, "{Name:'minecraft:magenta_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(3794, "{Name:'minecraft:magenta_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(3795, "{Name:'minecraft:magenta_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(3808, "{Name:'minecraft:light_blue_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(3809, "{Name:'minecraft:light_blue_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(3810, "{Name:'minecraft:light_blue_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(3811, "{Name:'minecraft:light_blue_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(3824, "{Name:'minecraft:yellow_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(3825, "{Name:'minecraft:yellow_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(3826, "{Name:'minecraft:yellow_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(3827, "{Name:'minecraft:yellow_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(3840, "{Name:'minecraft:lime_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(3841, "{Name:'minecraft:lime_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(3842, "{Name:'minecraft:lime_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(3843, "{Name:'minecraft:lime_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(3856, "{Name:'minecraft:pink_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(3857, "{Name:'minecraft:pink_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(3858, "{Name:'minecraft:pink_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(3859, "{Name:'minecraft:pink_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(3872, "{Name:'minecraft:gray_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(3873, "{Name:'minecraft:gray_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(3874, "{Name:'minecraft:gray_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(3875, "{Name:'minecraft:gray_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(3888, "{Name:'minecraft:light_gray_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(3889, "{Name:'minecraft:light_gray_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(3890, "{Name:'minecraft:light_gray_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(3891, "{Name:'minecraft:light_gray_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(3904, "{Name:'minecraft:cyan_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(3905, "{Name:'minecraft:cyan_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(3906, "{Name:'minecraft:cyan_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(3907, "{Name:'minecraft:cyan_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(3920, "{Name:'minecraft:purple_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(3921, "{Name:'minecraft:purple_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(3922, "{Name:'minecraft:purple_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(3923, "{Name:'minecraft:purple_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(3936, "{Name:'minecraft:blue_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(3937, "{Name:'minecraft:blue_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(3938, "{Name:'minecraft:blue_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(3939, "{Name:'minecraft:blue_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(3952, "{Name:'minecraft:brown_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(3953, "{Name:'minecraft:brown_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(3954, "{Name:'minecraft:brown_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(3955, "{Name:'minecraft:brown_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(3968, "{Name:'minecraft:green_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(3969, "{Name:'minecraft:green_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(3970, "{Name:'minecraft:green_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(3971, "{Name:'minecraft:green_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(3984, "{Name:'minecraft:red_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(3985, "{Name:'minecraft:red_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(3986, "{Name:'minecraft:red_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(3987, "{Name:'minecraft:red_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(4000, "{Name:'minecraft:black_glazed_terracotta',Properties:{facing:'south'}}");
        BlockIdConverter.register(4001, "{Name:'minecraft:black_glazed_terracotta',Properties:{facing:'west'}}");
        BlockIdConverter.register(4002, "{Name:'minecraft:black_glazed_terracotta',Properties:{facing:'north'}}");
        BlockIdConverter.register(4003, "{Name:'minecraft:black_glazed_terracotta',Properties:{facing:'east'}}");
        BlockIdConverter.register(4016, "{Name:'minecraft:white_concrete'}");
        BlockIdConverter.register(4017, "{Name:'minecraft:orange_concrete'}");
        BlockIdConverter.register(4018, "{Name:'minecraft:magenta_concrete'}");
        BlockIdConverter.register(4019, "{Name:'minecraft:light_blue_concrete'}");
        BlockIdConverter.register(4020, "{Name:'minecraft:yellow_concrete'}");
        BlockIdConverter.register(4021, "{Name:'minecraft:lime_concrete'}");
        BlockIdConverter.register(4022, "{Name:'minecraft:pink_concrete'}");
        BlockIdConverter.register(4023, "{Name:'minecraft:gray_concrete'}");
        BlockIdConverter.register(4024, "{Name:'minecraft:light_gray_concrete'}");
        BlockIdConverter.register(4025, "{Name:'minecraft:cyan_concrete'}");
        BlockIdConverter.register(4026, "{Name:'minecraft:purple_concrete'}");
        BlockIdConverter.register(4027, "{Name:'minecraft:blue_concrete'}");
        BlockIdConverter.register(4028, "{Name:'minecraft:brown_concrete'}");
        BlockIdConverter.register(4029, "{Name:'minecraft:green_concrete'}");
        BlockIdConverter.register(4030, "{Name:'minecraft:red_concrete'}");
        BlockIdConverter.register(4031, "{Name:'minecraft:black_concrete'}");
        BlockIdConverter.register(4032, "{Name:'minecraft:white_concrete_powder'}");
        BlockIdConverter.register(4033, "{Name:'minecraft:orange_concrete_powder'}");
        BlockIdConverter.register(4034, "{Name:'minecraft:magenta_concrete_powder'}");
        BlockIdConverter.register(4035, "{Name:'minecraft:light_blue_concrete_powder'}");
        BlockIdConverter.register(4036, "{Name:'minecraft:yellow_concrete_powder'}");
        BlockIdConverter.register(4037, "{Name:'minecraft:lime_concrete_powder'}");
        BlockIdConverter.register(4038, "{Name:'minecraft:pink_concrete_powder'}");
        BlockIdConverter.register(4039, "{Name:'minecraft:gray_concrete_powder'}");
        BlockIdConverter.register(4040, "{Name:'minecraft:light_gray_concrete_powder'}");
        BlockIdConverter.register(4041, "{Name:'minecraft:cyan_concrete_powder'}");
        BlockIdConverter.register(4042, "{Name:'minecraft:purple_concrete_powder'}");
        BlockIdConverter.register(4043, "{Name:'minecraft:blue_concrete_powder'}");
        BlockIdConverter.register(4044, "{Name:'minecraft:brown_concrete_powder'}");
        BlockIdConverter.register(4045, "{Name:'minecraft:green_concrete_powder'}");
        BlockIdConverter.register(4046, "{Name:'minecraft:red_concrete_powder'}");
        BlockIdConverter.register(4047, "{Name:'minecraft:black_concrete_powder'}");
        BlockIdConverter.register(4080, "{Name:'minecraft:structure_block',Properties:{mode:'save'}}");
        BlockIdConverter.register(4081, "{Name:'minecraft:structure_block',Properties:{mode:'load'}}");
        BlockIdConverter.register(4082, "{Name:'minecraft:structure_block',Properties:{mode:'corner'}}");
        BlockIdConverter.register(4083, "{Name:'minecraft:structure_block',Properties:{mode:'data'}}");
        for (int i = 0; i < ID_MAP.length; ++i) {
            if (ID_MAP[i] != null) continue;
            BlockIdConverter.ID_MAP[i] = BLOCK_DEFAULTS[i >> 4];
        }
    }

    public static class IdMeta {
        public final int id;
        public final int meta;

        public IdMeta(int id, int meta) {
            this.id = id;
            this.meta = meta;
        }
    }
}

