/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.data;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.collection.FastStream;
import net.creeperhost.levelio.LevelIO;
import net.creeperhost.levelio.Utils;
import net.creeperhost.levelio.data.Block;
import net.creeperhost.levelio.data.Chunk;
import net.creeperhost.levelio.data.Player;
import net.creeperhost.levelio.data.Region;
import net.creeperhost.levelio.lib.BlockPos;
import net.creeperhost.levelio.lib.ChunkPos;
import net.creeperhost.levelio.loader.LevelInfo;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Level {
    private static final Logger LOGGER = LoggerFactory.getLogger(Level.class);
    public final LevelIO levelIO;
    public final LevelInfo levelInfo;
    public final boolean readOnly;
    private Map<ChunkPos, Region> regions = new HashMap<ChunkPos, Region>();

    public Level(LevelIO levelIO, LevelInfo levelInfo, boolean readOnly) {
        this.levelIO = levelIO;
        this.levelInfo = levelInfo;
        this.readOnly = readOnly;
    }

    public Chunk getChunk(BlockPos pos) {
        return this.getChunk(pos.toChunkPos());
    }

    @Nullable
    public Chunk getChunk(ChunkPos pos) {
        Region region = this.regions.get(pos.toRegionPos());
        if (region != null) {
            try {
                return region.loadChunk(pos);
            }
            catch (IOException e) {
                LOGGER.warn("An error occurred while attempting to load chunk at {}", (Object)pos, (Object)e);
                return null;
            }
        }
        return null;
    }

    public void unloadChunk(Chunk chunk) {
        ChunkPos pos = chunk.pos;
        this.regions.get(pos.toRegionPos()).unloadChunk(pos);
    }

    public Map<ChunkPos, Region> getRegions() {
        return Collections.unmodifiableMap(this.regions);
    }

    @Nullable
    public Block getBlock(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        return chunk == null ? null : chunk.getBlock(pos);
    }

    public boolean hasBlock(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        return chunk != null && chunk.hasBlock(pos);
    }

    @Nullable
    public BlockPos getTopBlock(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        if (chunk == null) {
            return null;
        }
        return chunk.getTopBlock(pos);
    }

    public List<Player> getPlayers() {
        return FastStream.of(this.levelIO.getPlayers().values()).filter(e -> this.levelInfo.identifier.equals(e.getDimension(this.levelIO.saveInfo))).toImmutableList();
    }

    public static Level create(LevelIO levelIO, LevelInfo levelInfo, boolean readOnly) {
        String fileName;
        Level level = new Level(levelIO, levelInfo, readOnly);
        Path regionsPath = levelInfo.dimFolder.resolve("region");
        Path entitiesPath = levelInfo.dimFolder.resolve("entities");
        HashMap<ChunkPos, Path> mccFiles = new HashMap<ChunkPos, Path>();
        if (!Files.isDirectory(regionsPath, new LinkOption[0])) {
            LOGGER.warn("Did not find a region folder for level: {}", (Object)levelInfo.dimFolder.toAbsolutePath());
        }
        HashSet<ChunkPos> emptyRegions = new HashSet<ChunkPos>();
        for (Path file : Utils.getFilesInFolder(regionsPath)) {
            fileName = file.getFileName().toString();
            if (Level.isRegionFile(fileName)) {
                Region region;
                try {
                    if (Files.size(file) == 0L) {
                        emptyRegions.add(ChunkPos.fromMCAorMCC(fileName));
                        continue;
                    }
                    region = new Region(levelIO, levelInfo, file, readOnly);
                }
                catch (IOException e) {
                    LOGGER.error("An error occurred loading region file: " + file, (Throwable)e);
                    continue;
                }
                if (level.regions.containsKey(region.pos)) {
                    LOGGER.error("Found more than one region at region pos: {}, This should not be possible! " + file, (Object)region.pos);
                    continue;
                }
                level.regions.put(region.pos, region);
                continue;
            }
            if (!Level.isChunkFile(fileName)) continue;
            mccFiles.put(ChunkPos.fromMCAorMCC(fileName), file);
        }
        for (Path file : Utils.getFilesInFolder(entitiesPath)) {
            fileName = file.getFileName().toString();
            if (Level.isRegionFile(fileName)) {
                ChunkPos pos = ChunkPos.fromMCAorMCC(fileName);
                if (emptyRegions.contains(pos)) continue;
                Region region = level.regions.get(pos);
                if (region == null) {
                    LOGGER.error("No region file found for the following entity file: {}", (Object)file.toAbsolutePath().toString());
                    continue;
                }
                try {
                    if (Files.size(file) == 0L) continue;
                    region.addEntityMCA(file);
                }
                catch (IOException e) {
                    LOGGER.error("An error occurred loading entity file: " + file, (Throwable)e);
                }
                continue;
            }
            if (!Level.isChunkFile(fileName)) continue;
            LOGGER.warn("Chunk entity files are not currently supported: {}", (Object)file.toAbsolutePath().toString());
        }
        mccFiles.forEach((chunkPos, path) -> {
            Region region = level.regions.get(chunkPos.toRegionPos());
            if (region == null) {
                LOGGER.error("Missing region file for MCC file! {}", (Object)path.toAbsolutePath());
            } else {
                region.addMCC((ChunkPos)chunkPos, (Path)path);
            }
        });
        return level;
    }

    private static boolean isRegionFile(String name) {
        return name.startsWith("r.") && name.endsWith(".mca");
    }

    private static boolean isChunkFile(String name) {
        return name.startsWith("c.") && name.endsWith(".mcc");
    }

    public void close() {
        this.regions.values().forEach(Region::close);
    }
}

