/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.net.DisplayRewardToastMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class XPLevelsReward
extends Reward {
    private int xpLevels;

    public XPLevelsReward(long id, Quest quest, int x) {
        super(id, quest);
        this.xpLevels = x;
    }

    public XPLevelsReward(long id, Quest quest) {
        this(id, quest, 5);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.XP_LEVELS;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128405_("xp_levels", this.xpLevels);
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.xpLevels = nbt.m_128451_("xp_levels");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130130_(this.xpLevels);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.xpLevels = buffer.m_130242_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addInt("xp_levels", this.xpLevels, v -> {
            this.xpLevels = v;
        }, 1, 1, Integer.MAX_VALUE).setNameKey("ftbquests.reward.ftbquests.xp_levels");
    }

    @Override
    public void claim(ServerPlayer player, boolean notify) {
        player.m_6749_(this.xpLevels);
        if (notify) {
            new DisplayRewardToastMessage(this.id, (Component)Component.m_237115_((String)"ftbquests.reward.ftbquests.xp_levels").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)("+" + this.xpLevels)).m_130940_(ChatFormatting.GREEN)), (Icon)Color4I.empty()).sendTo(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237115_((String)"ftbquests.reward.ftbquests.xp_levels").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)("+" + this.xpLevels)).m_130940_(ChatFormatting.GREEN));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getButtonText() {
        return "+" + this.xpLevels;
    }
}

