/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.integrations.jei;

import dev.ftb.packcompanion.PackCompanionExpectPlatform;
import dev.ftb.packcompanion.config.PCClientConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JeiRecipeCategoriesCustomSorter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JeiRecipeCategoriesCustomSorter.class);
    public static final JeiRecipeCategoriesCustomSorter INSTANCE = new JeiRecipeCategoriesCustomSorter();
    private final LinkedList<String> sortingOrder = new LinkedList();
    private boolean hasCustomSorting = false;

    public List<IRecipeCategory<?>> sort(List<IRecipeCategory<?>> recipeCategories) {
        if (!this.hasCustomSorting) {
            return recipeCategories;
        }
        LinkedList sortedCategories = new LinkedList(recipeCategories);
        sortedCategories.sort((a, b) -> {
            ResourceLocation aId = a.getRecipeType().getUid();
            ResourceLocation bId = b.getRecipeType().getUid();
            if (aId.m_135827_().equals("minecraft")) {
                return -1;
            }
            if (bId.m_135827_().equals("minecraft")) {
                return 1;
            }
            int aIndex = this.sortingOrder.indexOf(aId.toString());
            int bIndex = this.sortingOrder.indexOf(bId.toString());
            if (aIndex != -1 && bIndex != -1) {
                return Integer.compare(aIndex, bIndex);
            }
            if (aIndex != -1) {
                return -1;
            }
            if (bIndex != -1) {
                return 1;
            }
            return Integer.compare(recipeCategories.indexOf(a), recipeCategories.indexOf(b));
        });
        return recipeCategories;
    }

    private boolean loadSortingOrder() {
        Path sortingOrderPath = PackCompanionExpectPlatform.getGameDirectory().resolve("data/ftbpc/jei_recipe_category_sorting_order.txt");
        if (Files.notExists(sortingOrderPath, new LinkOption[0])) {
            return false;
        }
        try {
            List<String> lines = Files.readAllLines(sortingOrderPath);
            this.sortingOrder.addAll(lines);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to load custom JEI recipe category sorting order", (Throwable)e);
            return false;
        }
    }

    public void updateSorting() {
        if (!((Boolean)PCClientConfig.JEI_SORT_RECIPES.get()).booleanValue()) {
            LOGGER.info("JEI recipe sorting is disabled, not updating sorting");
            return;
        }
        LOGGER.info("Reloading JEI recipe category sorting order");
        this.sortingOrder.clear();
        this.hasCustomSorting = this.loadSortingOrder();
        if (this.sortingOrder.isEmpty()) {
            LOGGER.info("No custom JEI recipe category sorting order found within `jei_recipe_category_sorting_order.txt`, using default sorting");
            this.hasCustomSorting = false;
        }
    }
}

