/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.packs;

import dev.obscuria.fragmentum.packs.BuiltInPackRegistry;
import dev.obscuria.fragmentum.packs.PackSelectionConfig;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;

public final class BuiltInPackBuilder {
    private final PackType type;
    private final String directory;
    private Component displayName = Component.m_237113_((String)"Custom Pack");
    private PackSelectionConfig config = new PackSelectionConfig(false, Pack.Position.TOP, false);
    private PackSource source = PackSource.f_244201_;

    private BuiltInPackBuilder(PackType type, String directory) {
        this.type = type;
        this.directory = directory;
    }

    public static BuiltInPackBuilder resourcePack(String directory) {
        return new BuiltInPackBuilder(PackType.CLIENT_RESOURCES, directory);
    }

    public static BuiltInPackBuilder dataPack(String directory) {
        return new BuiltInPackBuilder(PackType.SERVER_DATA, directory);
    }

    public BuiltInPackBuilder displayName(Component displayName) {
        this.displayName = displayName;
        return this;
    }

    public BuiltInPackBuilder selectionConfig(PackSelectionConfig config) {
        this.config = config;
        return this;
    }

    public BuiltInPackBuilder packSource(PackSource source) {
        this.source = source;
        return this;
    }

    public void register(String modId) {
        if (this.type == PackType.CLIENT_RESOURCES) {
            BuiltInPackRegistry.registerResourcePack(modId, this.directory, this.displayName, this.config, this.source);
        } else {
            BuiltInPackRegistry.registerDataPack(modId, this.directory, this.displayName, this.config, this.source);
        }
    }
}

