/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.server.music.ringer;

import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.server.music.ringer.MusicRing;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MusicRingManager {
    private static final MusicRingManager INSTANCE = new MusicRingManager();
    private final Map<ServerLevel, MusicRing> musicRings = new HashMap<ServerLevel, MusicRing>();

    public static MusicRingManager getInstance() {
        return INSTANCE;
    }

    public void tick(ServerLevel level) {
        this.getMusicRing(level).tick();
    }

    public Map<ServerLevel, MusicRing> getMusicRingers() {
        return this.musicRings;
    }

    public void restartRinger(ServerLevel level, UUID uuid) {
        this.getMusicRing(level).restart(uuid);
    }

    public void addRinger(ServerLevel level, IMusicRinger ringer) {
        this.getMusicRing(level).addRinger(ringer);
    }

    public boolean isWaitRinger(UUID uuid, ServerLevel level) {
        return this.getMusicRing(level).isWaitRinger(uuid);
    }

    public void onUpdate(ServerPlayer player, UUID uuid, UUID waitUUID, IMPPackets.MusicRingResponseStateType state) {
        this.getMusicRing(player.m_284548_()).onUpdate(player, uuid, waitUUID, state);
    }

    public void addReadyPlayer(ServerPlayer player, UUID uuid, UUID waitUUID, boolean result, boolean retry, long elapsed) {
        this.getMusicRing(player.m_284548_()).addReadyPlayer(player, uuid, waitUUID, result, retry, elapsed);
    }

    @NotNull
    public MusicRing getMusicRing(ServerLevel level) {
        return this.musicRings.computeIfAbsent(level, MusicRing::new);
    }

    public boolean hasRinger(UUID uuid) {
        for (ServerLevel serverLevel : this.musicRings.keySet()) {
            if (!this.hasRinger(serverLevel, uuid)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRinger(ServerLevel level, UUID uuid) {
        return this.getMusicRing(level).hasRinger(uuid);
    }

    public IMusicRinger getRinger(UUID uuid) {
        for (Map.Entry<ServerLevel, MusicRing> entry : this.musicRings.entrySet()) {
            MusicRing mr = entry.getValue();
            IMusicRinger r = mr.getRingers().get(uuid);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    @Nullable
    public ServerLevel getLevel(MusicRing ring) {
        for (Map.Entry<ServerLevel, MusicRing> entry : this.musicRings.entrySet()) {
            if (entry.getValue() != ring) continue;
            return entry.getKey();
        }
        return null;
    }

    public void pause() {
        this.musicRings.forEach((n, m) -> m.pause());
    }

    public void resume() {
        this.musicRings.forEach((n, m) -> m.resume());
    }

    public void clear() {
        this.musicRings.forEach((n, m) -> m.depose());
        this.musicRings.clear();
    }
}

