/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.server.music.ringer;

import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.server.music.MusicManager;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IBoomboxRinger
extends IMusicRinger {
    public static final Random rand = new Random();

    @NotNull
    public BoomboxData getRingerBoomboxData();

    @Override
    default public boolean isRingerPlaying() {
        return this.getRingerBoomboxData().isPlaying();
    }

    @Override
    default public void setRingerPlaying(boolean playing) {
        this.getRingerBoomboxData().setPlaying(playing);
    }

    @Override
    @Nullable
    default public MusicSource getRingerMusicSource() {
        if (this.isRingerStream()) {
            return this.getRingerBoomboxData().getRadioSource();
        }
        if (this.getRingerBoomboxData().isRadioRemote()) {
            Music m = this.getRingerBoomboxData().getSelectedMusic();
            if (m != null) {
                return m.getSource();
            }
        } else {
            return this.getRingerBoomboxData().getMusicSource();
        }
        return null;
    }

    @Override
    default public boolean isRingerLoop() {
        return this.getRingerBoomboxData().isLoop();
    }

    @Override
    default public long getRingerPosition() {
        return this.getRingerBoomboxData().getMusicPosition();
    }

    @Override
    default public void setRingerPosition(long position) {
        this.getRingerBoomboxData().setMusicPosition(position);
    }

    @Override
    default public float getRingerVolume() {
        if (this.isRingerMute()) {
            return 0.0f;
        }
        return this.getRingerBoomboxData().getRawVolume();
    }

    @Override
    default public float getRingerRange() {
        if (this.isRingerMute()) {
            return 0.0f;
        }
        return 90.0f * this.getRingerBoomboxData().getRawVolume();
    }

    @Override
    default public boolean isRingerStream() {
        return this.getRingerBoomboxData().isRadioStream();
    }

    @Override
    default public void ringerEnd() {
        BoomboxData.ContinuousType con;
        if (this.getRingerBoomboxData().isRadioRemote() && (con = this.getRingerBoomboxData().getContinuousType()) != BoomboxData.ContinuousType.NONE) {
            Music m = this.getRingerBoomboxData().getSelectedMusic();
            if (m == null) {
                return;
            }
            MusicManager mm = MusicManager.getInstance();
            MusicPlayList pl = mm.getPlaylistByMusic(this.getRingerLevel().m_7654_(), m.getUuid());
            if (pl == null) {
                return;
            }
            ArrayList<UUID> ml = new ArrayList<UUID>(pl.getMusicList());
            if (ml.isEmpty() || ml.size() == 1) {
                return;
            }
            Music nm = null;
            if (con == BoomboxData.ContinuousType.ORDER) {
                UUID nmi = ml.get((ml.indexOf(m.getUuid()) + 1) % ml.size());
                nm = mm.getSaveData(this.getRingerLevel().m_7654_()).getMusics().get(nmi);
            } else if (con == BoomboxData.ContinuousType.RANDOM) {
                ml.remove(m.getUuid());
                UUID nmi = ml.get(rand.nextInt(ml.size()));
                nm = mm.getSaveData(this.getRingerLevel().m_7654_()).getMusics().get(nmi);
            }
            if (nm != null) {
                this.getRingerBoomboxData().setSelectedMusic(nm);
            }
        }
    }

    @Override
    default public boolean isRingerMute() {
        return this.getRingerBoomboxData().isMute();
    }

    @Override
    default public boolean isRingerRemote() {
        return this.getRingerBoomboxData().isRadioRemote();
    }

    @Override
    @Nullable
    default public String getRingerMusicAuthor() {
        BoomboxData data = this.getRingerBoomboxData();
        if (data.isRadioRemote() && data.getSelectedMusic() != null) {
            return data.getSelectedMusic().getAuthor();
        }
        if (data.getCassetteTapeMusic() != null) {
            return data.getCassetteTapeMusic().getAuthor();
        }
        return null;
    }

    @Override
    @NotNull
    default public ItemStack getRingerAntenna() {
        return this.getRingerBoomboxData().getAntenna();
    }
}

