/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.org.apache.http.client.protocol;

import dev.felnull.imp.include.org.apache.http.HttpEntity;
import dev.felnull.imp.include.org.apache.http.HttpEntityEnclosingRequest;
import dev.felnull.imp.include.org.apache.http.HttpException;
import dev.felnull.imp.include.org.apache.http.HttpRequest;
import dev.felnull.imp.include.org.apache.http.HttpRequestInterceptor;
import dev.felnull.imp.include.org.apache.http.HttpVersion;
import dev.felnull.imp.include.org.apache.http.ProtocolVersion;
import dev.felnull.imp.include.org.apache.http.annotation.Contract;
import dev.felnull.imp.include.org.apache.http.annotation.ThreadingBehavior;
import dev.felnull.imp.include.org.apache.http.client.config.RequestConfig;
import dev.felnull.imp.include.org.apache.http.client.protocol.HttpClientContext;
import dev.felnull.imp.include.org.apache.http.protocol.HttpContext;
import dev.felnull.imp.include.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

