/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.dev.felnull.fnjl.debug;

public class ProcessTimeMeasure {
    private long elapsedTime;
    private long lastElapsedTime;
    private int sampleCount;
    private long lastPrintTime;
    private long lastResetTime;

    public void process(Runnable runnable) {
        long st = System.nanoTime();
        runnable.run();
        this.lap(System.nanoTime() - st);
    }

    public void lap(long elapsed) {
        this.elapsedTime += elapsed;
        this.lastElapsedTime = elapsed;
        ++this.sampleCount;
    }

    public void reset() {
        this.elapsedTime = 0L;
        this.sampleCount = 0;
        this.lastResetTime = System.currentTimeMillis();
    }

    public MeasureResult getResult() {
        if (this.elapsedTime <= 0L || this.sampleCount <= 0) {
            throw new IllegalStateException("Unmeasured");
        }
        return new MeasureResult(this.elapsedTime, this.sampleCount, this.lastElapsedTime);
    }

    public void printResult(long time) {
        if (System.currentTimeMillis() - this.lastPrintTime >= time) {
            System.out.println(this.getResult());
            this.lastPrintTime = System.currentTimeMillis();
        }
    }

    public void printResult(long time, long resetTime) {
        this.printResult(time);
        if (System.currentTimeMillis() - this.lastResetTime >= resetTime) {
            this.reset();
            this.lastResetTime = System.currentTimeMillis();
        }
    }

    public static class MeasureResult {
        private final long elapsed;
        private final long sampleCount;
        private final long lastElapsedTime;

        public MeasureResult(long elapsed, long sampleCount, long lastElapsedTime) {
            this.elapsed = elapsed;
            this.sampleCount = sampleCount;
            this.lastElapsedTime = lastElapsedTime;
        }

        public double getAverage() {
            return (double)this.elapsed / (double)this.sampleCount;
        }

        public String toString() {
            double avg = this.getAverage();
            return String.format("Elapsed Time: %.3f\u03bcs %06dns, Average Time: %.3f\u03bcs %.3fns, Count %s, Last Lap: %.3f\u03bcs %06dns", (double)this.elapsed / 1000000.0, this.elapsed, avg / 1000000.0, avg, this.sampleCount, (double)this.lastElapsedTime / 1000000.0, this.lastElapsedTime);
        }

        public long getElapsed() {
            return this.elapsed;
        }

        public long getSampleCount() {
            return this.sampleCount;
        }

        public long getLapTime() {
            return this.lastElapsedTime;
        }
    }
}

