/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.filter;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.filter.UniversalPcmAudioFilter;
import java.nio.ShortBuffer;

public class ChannelCountPcmAudioFilter
implements UniversalPcmAudioFilter {
    private final UniversalPcmAudioFilter downstream;
    private final int outputChannels;
    private final ShortBuffer outputBuffer;
    private final int inputChannels;
    private final int commonChannels;
    private final int channelsToAdd;
    private final short[] inputSet;
    private final float[][] splitFloatOutput;
    private final short[][] splitShortOutput;
    private int inputIndex;

    public ChannelCountPcmAudioFilter(int inputChannels, int outputChannels, UniversalPcmAudioFilter downstream) {
        this.downstream = downstream;
        this.inputChannels = inputChannels;
        this.outputChannels = outputChannels;
        this.outputBuffer = ShortBuffer.allocate(2048 * inputChannels);
        this.commonChannels = Math.min(outputChannels, inputChannels);
        this.channelsToAdd = outputChannels - this.commonChannels;
        this.inputSet = new short[inputChannels];
        this.splitFloatOutput = new float[outputChannels][];
        this.splitShortOutput = new short[outputChannels][];
        this.inputIndex = 0;
    }

    @Override
    public void process(short[] input, int offset, int length) throws InterruptedException {
        if (this.canPassThrough(length)) {
            this.downstream.process(input, offset, length);
        } else if (this.inputChannels == 1 && this.outputChannels == 2) {
            this.processMonoToStereo(ShortBuffer.wrap(input, offset, length));
        } else {
            this.processNormalizer(ShortBuffer.wrap(input, offset, length));
        }
    }

    @Override
    public void process(ShortBuffer buffer) throws InterruptedException {
        if (this.canPassThrough(buffer.remaining())) {
            this.downstream.process(buffer);
        } else if (this.inputChannels == 1 && this.outputChannels == 2) {
            this.processMonoToStereo(buffer);
        } else {
            this.processNormalizer(buffer);
        }
    }

    private void processNormalizer(ShortBuffer buffer) throws InterruptedException {
        while (buffer.hasRemaining()) {
            this.inputSet[this.inputIndex++] = buffer.get();
            if (this.inputIndex != this.inputChannels) continue;
            this.outputBuffer.put(this.inputSet, 0, this.commonChannels);
            for (int i = 0; i < this.channelsToAdd; ++i) {
                this.outputBuffer.put(this.inputSet[0]);
            }
            if (!this.outputBuffer.hasRemaining()) {
                this.outputBuffer.flip();
                this.downstream.process(this.outputBuffer);
                this.outputBuffer.clear();
            }
            this.inputIndex = 0;
        }
    }

    private void processMonoToStereo(ShortBuffer buffer) throws InterruptedException {
        while (buffer.hasRemaining()) {
            short sample = buffer.get();
            this.outputBuffer.put(sample);
            this.outputBuffer.put(sample);
            if (this.outputBuffer.hasRemaining()) continue;
            this.outputBuffer.flip();
            this.downstream.process(this.outputBuffer);
            this.outputBuffer.clear();
        }
    }

    private boolean canPassThrough(int length) {
        return this.inputIndex == 0 && this.inputChannels == this.outputChannels && length % this.inputChannels == 0;
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        int i;
        for (i = 0; i < this.commonChannels; ++i) {
            this.splitFloatOutput[i] = input[i];
        }
        for (i = this.commonChannels; i < this.outputChannels; ++i) {
            this.splitFloatOutput[i] = input[0];
        }
        this.downstream.process(this.splitFloatOutput, offset, length);
    }

    @Override
    public void process(short[][] input, int offset, int length) throws InterruptedException {
        int i;
        for (i = 0; i < this.commonChannels; ++i) {
            this.splitShortOutput[i] = input[i];
        }
        for (i = this.commonChannels; i < this.outputChannels; ++i) {
            this.splitShortOutput[i] = input[0];
        }
        this.downstream.process(this.splitShortOutput, offset, length);
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
        this.outputBuffer.clear();
    }

    @Override
    public void flush() throws InterruptedException {
    }

    @Override
    public void close() {
    }
}

