/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.github.kiulian.downloader.downloader.request;

import dev.felnull.imp.include.com.github.kiulian.downloader.downloader.YoutubeCallback;
import dev.felnull.imp.include.com.github.kiulian.downloader.downloader.client.ClientType;
import dev.felnull.imp.include.com.github.kiulian.downloader.downloader.client.Clients;
import dev.felnull.imp.include.com.github.kiulian.downloader.downloader.proxy.ProxyAuthenticator;
import dev.felnull.imp.include.com.github.kiulian.downloader.downloader.proxy.ProxyCredentialsImpl;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;

public abstract class Request<T extends Request<T, S>, S> {
    protected Map<String, String> headers;
    private YoutubeCallback<S> callback;
    private boolean async;
    private Integer maxRetries;
    private Proxy proxy;
    private ClientType clientType = Clients.highestPriorityClientType();

    public T proxy(String host, int port) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        return (T)this;
    }

    public T proxy(String host, int port, String userName, String password) {
        if (ProxyAuthenticator.getDefault() == null) {
            ProxyAuthenticator.setDefault(new ProxyAuthenticator(new ProxyCredentialsImpl()));
        }
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        ProxyAuthenticator.addAuthentication(host, port, userName, password);
        return (T)this;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public T maxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return (T)this;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public T callback(YoutubeCallback<S> callback) {
        this.callback = callback;
        return (T)this;
    }

    public YoutubeCallback<S> getCallback() {
        return this.callback;
    }

    public T header(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        return (T)this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public T async() {
        this.async = true;
        return (T)this;
    }

    public boolean isAsync() {
        return this.async;
    }

    public T clientType(ClientType client) {
        this.clientType = client;
        return (T)this;
    }

    public ClientType getClientType() {
        return this.clientType;
    }
}

