/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.speaker;

import dev.felnull.imp.client.music.AudioInfo;
import dev.felnull.imp.client.music.speaker.MusicSpeaker;
import dev.felnull.imp.client.util.MusicUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.openal.AL11;

public class MusicBuffer {
    private final List<MusicSpeaker> insertedSpeakers = new ArrayList<MusicSpeaker>();
    private final int buffer;

    public MusicBuffer(ByteBuffer buffer, boolean relative, AudioInfo audioData) {
        MusicUtils.assertOnMusicTick();
        this.buffer = AL11.alGenBuffers();
        AL11.alBufferData((int)this.buffer, (int)this.getFormat(relative ? audioData.channel() : 1, audioData.bit()), (ByteBuffer)buffer, (int)audioData.sampleRate());
        MusicUtils.checkALError();
    }

    public boolean canRelease() {
        return this.insertedSpeakers.isEmpty();
    }

    public void release() {
        if (!this.canRelease()) {
            throw new RuntimeException("Cannot be released because it is in use");
        }
        MusicUtils.assertOnMusicTick();
        AL11.alDeleteBuffers((int)this.buffer);
        MusicUtils.checkALError();
    }

    private int getFormat(int channel, int bit) {
        if (channel == 1) {
            if (bit == 8) {
                return 4352;
            }
            if (bit == 16) {
                return 4353;
            }
        } else if (channel == 2) {
            if (bit == 8) {
                return 4354;
            }
            if (bit == 16) {
                return 4355;
            }
        }
        throw new RuntimeException("Unsupported format");
    }

    public int getBufferId() {
        return this.buffer;
    }

    protected void addSpeaker(MusicSpeaker speaker) {
        this.insertedSpeakers.add(speaker);
    }

    protected void removeSpeaker(MusicSpeaker speaker) {
        this.insertedSpeakers.remove(speaker);
    }
}

