/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.player;

import dev.felnull.imp.client.lava.LavaPlayerManager;
import dev.felnull.imp.client.music.AudioInfo;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.imp.client.music.player.BaseMusicPlayer;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.format.AudioPlayerInputStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import dev.felnull.imp.music.resource.MusicSource;
import java.util.UUID;
import javax.sound.sampled.AudioInputStream;

public class LavaMusicPlayer
extends BaseMusicPlayer {
    private final AudioTrack audioTrack;
    private AudioPlayer audioPlayer;

    public LavaMusicPlayer(UUID musicPlayerId, AudioTrack audioTrack, MusicSource musicSource) {
        super(musicPlayerId, new AudioInfo(LavaPlayerManager.getInstance().getChannel(), LavaPlayerManager.getInstance().getSampleRate(), LavaPlayerManager.getInstance().getBit()), musicSource, audioTrack.getInfo().isStream ? 5 : 16);
        this.audioTrack = audioTrack;
    }

    @Override
    protected AudioInputStream openAudioStream(long position) throws Exception {
        LavaPlayerManager lm = LavaPlayerManager.getInstance();
        this.audioPlayer = lm.getAudioPlayerManager().createPlayer();
        this.audioTrack.setPosition(position);
        this.audioPlayer.addListener(new AudioEventAdapter(){

            @Override
            public void onTrackEnd(AudioPlayer player, AudioTrack track, AudioTrackEndReason endReason) {
                LavaMusicPlayer.this.stopReadStream();
            }

            @Override
            public void onTrackException(AudioPlayer player, AudioTrack track, FriendlyException exception) {
                MusicEngine.getInstance().getLogger().error("Audio track error: " + track.getInfo().identifier, (Throwable)exception);
                LavaMusicPlayer.this.stopReadStream();
            }

            @Override
            public void onTrackStuck(AudioPlayer player, AudioTrack track, long thresholdMs) {
                LavaMusicPlayer.this.stopReadStream();
            }
        });
        AudioInputStream stream = AudioPlayerInputStream.createStream(this.audioPlayer, lm.getAudioDataFormat(), 3000L, true);
        this.audioPlayer.playTrack(this.audioTrack);
        return stream;
    }

    @Override
    protected void closeAudioStream() throws Exception {
        if (this.audioPlayer != null) {
            this.audioPlayer.destroy();
        }
    }
}

