/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.media;

import com.google.common.collect.ImmutableMap;
import dev.felnull.imp.client.music.media.HttpMusicMedia;
import dev.felnull.imp.client.music.media.MusicMedia;
import dev.felnull.imp.client.music.media.SoundCloudMusicMedia;
import dev.felnull.imp.client.music.media.YoutubeMusicMedia;
import java.util.Map;
import java.util.TreeMap;

public class IMPMusicMedias {
    protected static final Map<String, MusicMedia> MEDIAS = new TreeMap<String, MusicMedia>();
    public static final YoutubeMusicMedia YOUTUBE = new YoutubeMusicMedia("youtube");
    public static final SoundCloudMusicMedia SOUNDCLOUD = new SoundCloudMusicMedia("soundcloud");
    public static final HttpMusicMedia HTTP = new HttpMusicMedia("http");

    public static void init() {
        IMPMusicMedias.register("youtube", YOUTUBE);
        IMPMusicMedias.register("soundcloud", SOUNDCLOUD);
        IMPMusicMedias.register("http", HTTP);
    }

    public static void register(String name, MusicMedia media) {
        MEDIAS.put(name, media);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MusicMedia getMedia(String name) {
        Map<String, MusicMedia> map = MEDIAS;
        synchronized (map) {
            return MEDIAS.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, MusicMedia> getAllMedia() {
        Map<String, MusicMedia> map = MEDIAS;
        synchronized (map) {
            return ImmutableMap.copyOf(MEDIAS);
        }
    }
}

