/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.forge;

import com.mojang.blaze3d.platform.InputConstants;
import io.github.kosmx.emotes.arch.gui.EmoteMenuImpl;
import io.github.kosmx.emotes.arch.gui.screen.ingame.FastChosseScreen;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.forge.executor.ForgeClientMethods;
import io.github.kosmx.emotes.forge.network.ClientNetworkInstance;
import io.github.kosmx.emotes.main.MainClientInit;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientInit {
    static KeyMapping openMenuKey;
    static KeyMapping stopEmote;
    static KeyMapping debugKey;
    static Consumer<Minecraft> keyBindingFunction;

    static void initClient() {
        ClientInit.initKeyBinding();
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ClientInit());
    }

    static void setupClient() {
        ClientNetworkInstance.networkInstance.init();
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> new EmoteMenuImpl((Screen)screen)));
    }

    @SubscribeEvent
    public static void endClientTick(TickEvent.ClientTickEvent event) {
        ++ForgeClientMethods.tick;
    }

    @SubscribeEvent
    public static void keyListenerEvent(InputEvent.Key event) {
        keyBindingFunction.accept(null);
    }

    @SubscribeEvent
    public void keyBindingRegister(RegisterKeyMappingsEvent event) {
        event.register(openMenuKey);
        event.register(stopEmote);
        if (debugKey != null) {
            event.register(debugKey);
        }
    }

    private static void initKeyBinding() {
        openMenuKey = new KeyMapping("key.emotecraft.fastchoose", InputConstants.Type.KEYSYM, 66, "category.emotecraft.keybinding");
        stopEmote = new KeyMapping("key.emotecraft.stop", InputConstants.Type.KEYSYM, -1, "category.emotecraft.keybinding");
        if (FMLLoader.getGamePath().resolve("emote.json").toFile().isFile()) {
            debugKey = new KeyMapping("key.emotecraft.debug", InputConstants.Type.KEYSYM, 79, "category.emotecraft.keybinding");
        }
        keyBindingFunction = client -> {
            if (openMenuKey.m_90859_() && (((ClientConfig)EmoteInstance.config).alwaysOpenEmoteScreen.get().booleanValue() || Minecraft.m_91087_().f_91074_ == Minecraft.m_91087_().m_91288_())) {
                Minecraft.m_91087_().m_91152_((Screen)new FastChosseScreen(null));
            }
            if (stopEmote.m_90859_()) {
                ClientEmotePlay.clientStopLocalEmote();
            }
            if (debugKey != null && debugKey.m_90859_()) {
                MainClientInit.playDebugEmote();
            }
        };
    }

    static {
        debugKey = null;
    }
}

