/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.world.structure;

import com.eeeab.eeeabsmobs.sever.entity.guling.EntityGulingSentinel;
import com.eeeab.eeeabsmobs.sever.entity.guling.EntityGulingSentinelHeavy;
import com.eeeab.eeeabsmobs.sever.entity.guling.EntityNamelessGuardian;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.StructuresInit;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class StructureGuling
extends Structure {
    public static final Codec<StructureGuling> CODEC = StructureGuling.m_226607_(StructureGuling::new);
    private static final ResourceLocation ANCIENT_TOMB_1 = new ResourceLocation("eeeabsmobs", "guling_1");
    private static final ResourceLocation ANCIENT_TOMB_2 = new ResourceLocation("eeeabsmobs", "guling_2");
    private static final ResourceLocation ANCIENT_TOMB_3 = new ResourceLocation("eeeabsmobs", "guling_3");
    private static final ResourceLocation ANCIENT_TOMB_4 = new ResourceLocation("eeeabsmobs", "guling_4");
    private static final Map<ResourceLocation, BlockPos> OFFSET = new ImmutableMap.Builder().put((Object)ANCIENT_TOMB_1, (Object)new BlockPos(0, 1, 0)).put((Object)ANCIENT_TOMB_2, (Object)new BlockPos(0, 1, 0)).put((Object)ANCIENT_TOMB_3, (Object)new BlockPos(0, 1, 0)).put((Object)ANCIENT_TOMB_4, (Object)new BlockPos(0, 1, 0)).build();

    protected StructureGuling(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        BlockPos blockPos = new BlockPos(context.f_226628_().m_45604_(), -32, context.f_226628_().m_45605_());
        return Optional.of(new Structure.GenerationStub(blockPos, value -> StructureGuling.generatePieces(value, context, blockPos)));
    }

    private static void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context, BlockPos blockpos) {
        Rotation rotation = Rotation.NONE;
        StructureGuling.start(context.f_226625_(), blockpos, rotation, builder, context.f_226626_());
    }

    private static void start(StructureTemplateManager manager, BlockPos pos, Rotation rotation, StructurePiecesBuilder builder, WorldgenRandom random) {
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        BlockPos rotationOffset = new BlockPos(27, 1, 27).m_7954_(rotation);
        BlockPos blockPos = rotationOffset.m_7918_(x, pos.m_123342_(), z);
        builder.m_142679_((StructurePiece)new Piece(manager, ANCIENT_TOMB_1, rotation, blockPos));
        rotationOffset = new BlockPos(1, 1, 27).m_7954_(rotation);
        blockPos = rotationOffset.m_7918_(x, pos.m_123342_(), z);
        builder.m_142679_((StructurePiece)new Piece(manager, ANCIENT_TOMB_2, rotation, blockPos));
        rotationOffset = new BlockPos(1, 1, 1).m_7954_(rotation);
        blockPos = rotationOffset.m_7918_(x, pos.m_123342_(), z);
        builder.m_142679_((StructurePiece)new Piece(manager, ANCIENT_TOMB_3, rotation, blockPos));
        rotationOffset = new BlockPos(27, 1, 1).m_7954_(rotation);
        blockPos = rotationOffset.m_7918_(x, pos.m_123342_(), z);
        builder.m_142679_((StructurePiece)new Piece(manager, ANCIENT_TOMB_4, rotation, blockPos));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)StructuresInit.GULING_STRUCTURE.get();
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static class Piece
    extends TemplateStructurePiece {
        public Piece(StructureTemplateManager manager, ResourceLocation location, Rotation rotation, BlockPos blockPos) {
            super((StructurePieceType)StructuresInit.GUL.get(), 0, manager, location, location.toString(), Piece.makeSettings(rotation), Piece.makePosition(location, blockPos));
        }

        public Piece(StructureTemplateManager templateManagerIn, CompoundTag tagCompound) {
            super((StructurePieceType)StructuresInit.GUL.get(), tagCompound, templateManagerIn, location -> Piece.makeSettings(Rotation.valueOf((String)tagCompound.m_128461_("Rot"))));
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tag) {
            this(context.f_226956_(), tag);
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation) {
            BlockIgnoreProcessor blockignoreprocessor = BlockIgnoreProcessor.f_74046_;
            return new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)blockignoreprocessor).m_74383_((StructureProcessor)new ProtectedBlockProcessor(BlockTags.f_144287_)).m_163782_(false);
        }

        private static BlockPos makePosition(ResourceLocation location, BlockPos blockPos) {
            return blockPos.m_121955_((Vec3i)OFFSET.get(location));
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag compoundTag) {
            super.m_183620_(context, compoundTag);
            compoundTag.m_128359_("Rot", this.f_73657_.m_74404_().name());
        }

        protected void m_213704_(String function, BlockPos blockPos, ServerLevelAccessor levelAccessor, RandomSource source, BoundingBox box) {
            if ("boss_spawn".equals(function)) {
                levelAccessor.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
                EntityNamelessGuardian guardian = (EntityNamelessGuardian)((EntityType)EntityInit.NAMELESS_GUARDIAN.get()).m_20615_((Level)levelAccessor.m_6018_());
                if (guardian != null) {
                    guardian.m_20035_(blockPos, 0.0f, 0.0f);
                    guardian.m_6518_(levelAccessor, levelAccessor.m_6436_(blockPos), MobSpawnType.STRUCTURE, null, null);
                    levelAccessor.m_7967_((Entity)guardian);
                }
            }
            if ("elite_spawn".equals(function)) {
                levelAccessor.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
                EntityGulingSentinelHeavy heavy = (EntityGulingSentinelHeavy)((EntityType)EntityInit.GULING_SENTINEL_HEAVY.get()).m_20615_((Level)levelAccessor.m_6018_());
                if (heavy != null) {
                    heavy.m_20035_(blockPos, 0.0f, 0.0f);
                    heavy.m_6518_(levelAccessor, levelAccessor.m_6436_(blockPos), MobSpawnType.STRUCTURE, null, null);
                    levelAccessor.m_7967_((Entity)heavy);
                }
            }
            if ("normal_spawn".equals(function)) {
                levelAccessor.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
                EntityGulingSentinel sentinel = (EntityGulingSentinel)((EntityType)EntityInit.GULING_SENTINEL.get()).m_20615_((Level)levelAccessor.m_6018_());
                if (sentinel != null) {
                    sentinel.m_20035_(blockPos, 0.0f, 0.0f);
                    sentinel.m_6518_(levelAccessor, levelAccessor.m_6436_(blockPos), MobSpawnType.STRUCTURE, null, null);
                    levelAccessor.m_7967_((Entity)sentinel);
                }
            }
        }
    }
}

