/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.projectile;

import com.eeeab.eeeabsmobs.client.util.ControlledAnimation;
import com.eeeab.eeeabsmobs.sever.entity.IEntity;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityCameraShake;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityExplode;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class EntityBloodBall
extends Projectile
implements IEntity {
    private int duration;
    private boolean locating;
    private final boolean isHeal;
    private static final int MAX_ACTIVE = 400;
    private static final EntityDataAccessor<Integer> DATA_POWER = SynchedEntityData.m_135353_(EntityBloodBall.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TARGET_UUID = SynchedEntityData.m_135353_(EntityBloodBall.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final BlockParticleOption REDSTONE_PARTICLE = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50330_.m_49966_());
    public final ControlledAnimation scaleControlled = new ControlledAnimation(20);

    public EntityBloodBall(EntityType<? extends EntityBloodBall> entityType, Level level) {
        super(entityType, level);
        this.isHeal = false;
    }

    public EntityBloodBall(Level level, int duration, boolean isHeal, int power) {
        super((EntityType)EntityInit.BLOOD_BALL.get(), level);
        this.duration = duration;
        this.isHeal = isHeal;
        this.setPower(Mth.m_14045_((int)power, (int)0, (int)10));
    }

    public void m_8119_() {
        this.scaleControlled.updatePrevTimer();
        Entity entity = this.m_19749_();
        if (this.m_9236_().f_46443_ || (entity == null || !entity.m_213877_()) && this.m_9236_().m_46805_(this.m_20183_())) {
            super.m_8119_();
            this.m_6478_(MoverType.SELF, this.m_20184_());
            HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
            if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
            this.m_20101_();
            if (this.f_19797_ >= 400) {
                this.m_146870_();
            } else {
                Entity owner = this.m_19749_();
                if (this.f_19797_ < this.duration && owner != null && owner.m_6084_()) {
                    this.m_146884_(owner.m_20182_().m_82520_(0.0, 5.0, 0.0));
                } else if (this.m_9236_().f_46443_) {
                    for (int i = 0; i < 2; ++i) {
                        double dx = this.m_20185_() + this.f_19796_.m_188583_() * 0.15;
                        double dy = this.m_20227_(1.0) - this.f_19796_.m_188583_() * 0.15;
                        double dz = this.m_20189_() + this.f_19796_.m_188583_() * 0.15;
                        this.m_9236_().m_7106_((ParticleOptions)REDSTONE_PARTICLE, dx, dy, dz, -this.m_20184_().m_7096_() * 0.25, -this.m_20184_().m_7098_() * 0.25, -this.m_20184_().m_7094_() * 0.25);
                    }
                }
                this.scaleControlled.increaseTimer();
            }
            if (!this.m_9236_().f_46443_ && this.f_19797_ >= this.duration && !this.locating) {
                this.locating = true;
                if (this.getSavedTargetByUUID() != null && this.getSavedTargetByUUID().m_6084_() && !this.isHeal) {
                    this.shoot(this.getSavedTargetByUUID(), -0.1f, 1.5f);
                } else {
                    this.shoot(this.m_19749_(), 0.2f, 0.5f);
                }
            }
        } else {
            this.m_146870_();
        }
    }

    private void shoot(Entity target, float yOffset, float velocity) {
        if (target != null) {
            double x = target.m_20185_() - this.m_20185_();
            double y = target.m_20227_(0.3333333333333333) - this.m_20186_();
            double z = target.m_20189_() - this.m_20189_();
            this.m_6686_(x, y + Math.sqrt(x * x + z * z) * (double)yOffset, z, velocity, 1.0f);
        }
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        this.preDestroy(hitResult.m_82443_());
    }

    protected void m_8060_(BlockHitResult hitResult) {
        super.m_8060_(hitResult);
        this.preDestroy(null);
    }

    private void preDestroy(@Nullable Entity entity) {
        if (!this.m_9236_().f_46443_) {
            if (this.m_19749_() == entity && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.isHeal) {
                    livingEntity.m_5634_(Math.min(livingEntity.m_21233_() * 0.05f * (float)this.getPower(), livingEntity.m_21233_() * 0.5f));
                    this.m_9236_().m_7605_((Entity)livingEntity, (byte)14);
                }
            } else {
                EntityExplode.explode(this.m_9236_(), this.m_20182_(), this.m_269291_().m_269036_((Entity)this, entity), null, Math.min((float)(this.getPower() + 1), 5.0f), 30.0f);
                EntityCameraShake.cameraShake(this.m_9236_(), this.m_20182_(), 16.0f, 0.125f, 5, 15);
            }
        }
        this.m_146870_();
    }

    public boolean isHeal() {
        return this.isHeal;
    }

    public float m_213856_() {
        return 1.0f;
    }

    public boolean m_20069_() {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6087_() {
        return !this.locating;
    }

    public float m_6143_() {
        return 1.0f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (this.locating) {
            return false;
        }
        this.m_5834_();
        Entity entity = source.m_7639_();
        if (entity != null) {
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity2;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.VERTIGO_EFFECT.get(), 50, 0, false, false));
            }
            this.preDestroy(null);
            return true;
        }
        return false;
    }

    public void setTargetUUID(UUID uuid) {
        this.f_19804_.m_135381_(DATA_TARGET_UUID, Optional.of(uuid));
    }

    public UUID getTargetUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_TARGET_UUID)).orElse(null);
    }

    @Nullable
    public Entity getSavedTargetByUUID() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.getTargetUUID() != null) {
                return level2.m_8791_(this.getTargetUUID());
            }
        }
        return null;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TARGET_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_POWER, (Object)0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.getTargetUUID() != null) {
            nbt.m_128362_("target_uuid", this.getTargetUUID());
        }
        nbt.m_128379_("locating", this.locating);
        nbt.m_128405_("power", this.getPower());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128403_("target_uuid")) {
            this.setTargetUUID(nbt.m_128342_("target_uuid"));
        }
        this.locating = nbt.m_128471_("locating");
        this.setPower(nbt.m_128451_("power"));
    }

    public int getPower() {
        return (Integer)this.f_19804_.m_135370_(DATA_POWER);
    }

    public void setPower(int power) {
        this.f_19804_.m_135381_(DATA_POWER, (Object)power);
    }
}

