/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.effects;

import com.eeeab.eeeabsmobs.sever.entity.effects.EntityMagicEffects;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityExplode
extends EntityMagicEffects {
    private DamageSource damageSource;
    private float maxDamage;
    private static final EntityDataAccessor<Boolean> DATA_EXPLODE = SynchedEntityData.m_135353_(EntityExplode.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(EntityExplode.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public EntityExplode(EntityType<EntityExplode> type, Level level) {
        super(type, level);
    }

    public EntityExplode(Level level, DamageSource damageSource, @Nullable LivingEntity caster, float radius, float maxDamage) {
        this((EntityType<EntityExplode>)((EntityType)EntityInit.EXPLODE.get()), level);
        this.setRadius(radius);
        this.damageSource = damageSource;
        this.maxDamage = maxDamage;
        this.caster = caster;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isExplode()) {
            this.m_146870_();
        } else {
            this.f_19804_.m_135381_(DATA_EXPLODE, (Object)true);
            this.explode(this.damageSource, this, this.maxDamage);
            this.doExplodeEffect(this.m_20182_(), this.getRadius());
        }
    }

    private void explode(DamageSource damageSource, @Nullable Entity entity, float maxDamage) {
        Vec3 vec3 = this.m_20182_();
        float f2 = this.getRadius() * 2.0f;
        int k1 = Mth.m_14107_((double)(vec3.f_82479_ - (double)f2 - 1.0));
        int l1 = Mth.m_14107_((double)(vec3.f_82479_ + (double)f2 + 1.0));
        int i2 = Mth.m_14107_((double)(vec3.f_82480_ - (double)f2 - 1.0));
        int i1 = Mth.m_14107_((double)(vec3.f_82480_ + (double)f2 + 1.0));
        int j2 = Mth.m_14107_((double)(vec3.f_82481_ - (double)f2 - 1.0));
        int j1 = Mth.m_14107_((double)(vec3.f_82481_ + (double)f2 + 1.0));
        List list = this.m_9236_().m_45933_(entity, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        for (Entity hit : list) {
            double d11;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            if (this.caster != null && hit == this.caster || hit.m_6128_() || !((d12 = Math.sqrt(hit.m_20238_(vec3)) / (double)f2) <= 1.0) || (d13 = Math.sqrt((d5 = hit.m_20185_() - vec3.f_82479_) * d5 + (d7 = (hit instanceof PrimedTnt ? hit.m_20186_() : hit.m_20188_()) - vec3.f_82480_) * d7 + (d9 = hit.m_20189_() - vec3.f_82481_) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = Explosion.m_46064_((Vec3)vec3, (Entity)hit);
            double d10 = (1.0 - d12) * d14;
            float damage = Math.min((float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0)), maxDamage);
            if (damageSource == null) {
                damageSource = this.m_269291_().m_269036_((Entity)this, (Entity)this);
            }
            hit.m_6469_(damageSource, damage);
            if (hit instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)hit;
                d11 = ProtectionEnchantment.m_45135_((LivingEntity)livingEntity, (double)d10);
            } else {
                d11 = d10;
            }
            Vec3 vec31 = new Vec3(d5 *= d11, d7 *= d11, d9 *= d11);
            hit.m_20256_(hit.m_20184_().m_82549_(vec31));
        }
    }

    private void doExplodeEffect(Vec3 vec3, float radius) {
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7785_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
            if (!(radius < 2.0f)) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0, 0.0, 0.0);
            } else {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0, 0.0, 0.0);
            }
        }
    }

    public void m_20334_(double x, double y, double z) {
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_EXPLODE, (Object)false);
        this.f_19804_.m_135372_(DATA_RADIUS, (Object)Float.valueOf(1.0f));
    }

    public boolean isExplode() {
        return (Boolean)this.f_19804_.m_135370_(DATA_EXPLODE);
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(DATA_RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        this.f_19804_.m_135381_(DATA_RADIUS, (Object)Float.valueOf(radius));
    }

    public static void explode(Level world, Vec3 vec3, DamageSource damageSource, @Nullable LivingEntity caster, float radius, float maxDamage) {
        if (!world.f_46443_) {
            EntityExplode explode = new EntityExplode(world, damageSource, caster, radius, maxDamage);
            explode.m_146884_(vec3);
            world.m_7967_((Entity)explode);
        }
    }
}

