/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleImmortalExplosion
extends TextureSheetParticle {
    private final float rotSpeed;
    private final SpriteSet sprites;
    private final boolean invert;

    public ParticleImmortalExplosion(ClientLevel level, double x, double y, double z, double quadSizeMultiplier, SpriteSet sprites) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_107225_ = 6 + this.f_107223_.m_188503_(5);
        float f = this.f_107223_.m_188501_() * 0.2f;
        this.invert = this.f_107223_.m_188499_();
        this.f_107227_ = 0.6f + f;
        this.f_107228_ = 0.8f + f;
        this.f_107229_ = 1.0f;
        this.f_107663_ = 2.0f * (1.0f - (float)quadSizeMultiplier * 0.5f);
        this.rotSpeed = ((float)Math.random() - 0.5f) * 0.1f;
        this.f_107231_ = this.f_107204_ = (float)Math.toRadians(this.f_107223_.m_188503_(360));
        this.sprites = sprites;
        this.m_108339_(sprites);
    }

    public int m_6355_(float partialTick) {
        return 0xF000F0;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.f_107204_ = this.f_107231_;
            float arc = (float)Math.PI * this.rotSpeed * 2.0f;
            this.f_107231_ = this.invert ? (this.f_107231_ -= arc) : (this.f_107231_ += arc);
            this.m_108339_(this.sprites);
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107432_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ImmortalExplosionFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public ImmortalExplosionFactory(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleImmortalExplosion(level, x, y, z, xSpeed, this.sprites);
        }
    }
}

