/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.model.entity;

import com.eeeab.animate.client.model.EMHierarchicalModel;
import com.eeeab.eeeabsmobs.client.model.animation.AnimationCommon;
import com.eeeab.eeeabsmobs.client.model.animation.AnimationImmortalShaman;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityImmortalShaman;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.HumanoidArm;

public class ModelImmortalShaman
extends EMHierarchicalModel<EntityImmortalShaman>
implements ArmedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart upper;
    private final ModelPart rightArm;
    private final ModelPart rightHand;
    private final ModelPart leftArm;
    private final ModelPart leftHand;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public ModelImmortalShaman(ModelPart root) {
        this.root = root.m_171324_("root");
        this.upper = this.root.m_171324_("upper");
        this.head = this.upper.m_171324_("head");
        this.leftArm = this.upper.m_171324_("leftArm");
        this.leftHand = this.leftArm.m_171324_("leftArmUnder");
        this.rightArm = this.upper.m_171324_("rightArm");
        this.rightHand = this.rightArm.m_171324_("rightArmUnder");
        ModelPart lower = this.root.m_171324_("lower");
        this.rightLeg = lower.m_171324_("rightLeg");
        this.leftLeg = lower.m_171324_("leftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)24.0f, (float)0.0f));
        PartDefinition upper = root.m_171599_("upper", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)-21.0f, (float)0.0f));
        PartDefinition head = upper.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -3.7f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.8f)), PartPose.m_171419_((float)0.0f, (float)-10.5f, (float)-0.3f));
        PartDefinition cube_r1 = head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 70).m_171488_(-10.5f, -0.1f, -9.5116f, 20.0f, 0.1f, 20.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)0.0f, (float)-4.9406f, (float)-0.1884f, (float)1.0353f, (float)0.4718f, (float)0.6537f));
        PartDefinition cube_r2 = head.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 33).m_171488_(-4.0f, -5.8f, -4.1f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.3807f, (float)0.6939f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = head.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.45f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)-0.2f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition body = upper.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(18, 17).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(16, 51).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition leftArm = upper.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(9, 16).m_171488_(-0.1038f, -1.4128f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.1f, (float)-8.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        PartDefinition leftArmUnder = leftArm.m_171599_("leftArmUnder", CubeListBuilder.m_171558_().m_171514_(9, 16).m_171488_(-1.1038f, 0.5872f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)8.0f, (float)0.0f));
        PartDefinition rightArm = upper.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(9, 16).m_171480_().m_171488_(-1.8962f, -1.4128f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.1f, (float)-8.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition rightArmUnder = rightArm.m_171599_("rightArmUnder", CubeListBuilder.m_171558_().m_171514_(9, 16).m_171480_().m_171488_(-0.8962f, 0.5872f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)8.0f, (float)0.0f));
        PartDefinition lower = root.m_171599_("lower", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)-21.0f, (float)0.0f));
        PartDefinition leftLeg = lower.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.2f, 0.0f, -1.0f, 2.0f, 20.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 51).m_171488_(-2.2f, -0.2f, -2.0f, 4.0f, 20.0f, 4.0f, new CubeDeformation(0.22f)), PartPose.m_171419_((float)2.2f, (float)1.0f, (float)0.0f));
        PartDefinition rightLeg = lower.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 20.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 51).m_171480_().m_171488_(-2.0f, -0.2f, -2.0f, 4.0f, 20.0f, 4.0f, new CubeDeformation(0.22f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)1.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(EntityImmortalShaman entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        ModelImmortalShaman.lookAtAnimation(netHeadYaw, headPitch, 1.0f, this.head);
        float delta = ageInTicks - (float)entity.f_19797_;
        float frame = (float)entity.frame + delta;
        if (entity.m_6084_() && entity.isWeakness()) {
            this.setStaticRotationAngle(this.head, ModelImmortalShaman.toRadians(1.5), 0.0f, 0.0f);
            this.walk(this.head, 0.2f, 0.15f, false, 0.0f, 0.0f, frame, 1.0f);
            this.walk(this.root, 0.1f, 0.1f, false, 0.0f, 0.0f, frame, 1.0f);
        }
        float walkSpeed = 0.6f;
        float walkDegree = 0.6f;
        this.walk(this.leftLeg, walkSpeed, walkDegree * 1.2f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.rightLeg, walkSpeed, walkDegree * 1.2f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.leftArm, walkSpeed, walkDegree * 1.2f, false, 0.0f, -0.05f, limbSwing, limbSwingAmount);
        this.walk(this.rightArm, walkSpeed, walkDegree * 1.2f, true, 0.0f, -0.05f, limbSwing, limbSwingAmount);
        float speed = 0.16f;
        float degree = 0.04f;
        if (entity.m_6084_() && !entity.isWeakness()) {
            this.walk(this.head, speed, degree, false, 0.5f, -0.05f, frame, 1.0f);
            this.flap(this.rightArm, speed, degree * 0.5f, true, 0.0f, 0.0f, frame, 1.0f);
            this.swing(this.rightArm, speed, degree, true, 0.0f, 0.0f, frame, 1.0f);
            this.flap(this.leftArm, speed, degree * 0.5f, false, 0.0f, 0.0f, frame, 1.0f);
            this.swing(this.leftArm, speed, degree, false, 0.0f, 0.0f, frame, 1.0f);
        }
        this.animate(entity.spellCastingBombAnimation, AnimationImmortalShaman.BOMB, ageInTicks);
        this.animate(entity.spellCastingHealAnimation, AnimationImmortalShaman.HEAL, ageInTicks);
        this.animate(entity.spellCastingFRAnimation, AnimationImmortalShaman.ATTACK, ageInTicks);
        this.animate(entity.spellCastingSummonAnimation, AnimationImmortalShaman.SUMMON, ageInTicks);
        this.animate(entity.spellCastingWololoAnimation, AnimationImmortalShaman.SUMMON, ageInTicks);
        this.animate(entity.avoidAnimation, AnimationImmortalShaman.AVOID, ageInTicks);
        this.animate(entity.dieAnimation, AnimationCommon.DIE, ageInTicks);
        int tick = entity.getAnimationTick();
        if (entity.getAnimation() == entity.spellCastingSummonAnimation || entity.getAnimation() == entity.spellCastingWololoAnimation) {
            if (tick < 34) {
                this.generalShake(frame);
            }
        } else if (entity.getAnimation() == entity.spellCastingHealAnimation) {
            if (tick < 50) {
                this.generalShake(frame);
            }
        } else if (entity.getAnimation() == entity.spellCastingFRAnimation) {
            if (tick < 12) {
                this.walk(this.root, 2.5f, 0.125f - (float)tick * 0.01f, false, 0.0f, 0.0f, frame, 1.0f);
                this.flap(this.root, 1.5f, 0.1f - (float)tick * 0.01f, false, 0.0f, 0.0f, frame, 1.0f);
            }
        } else if (entity.getAnimation() == entity.spellCastingBombAnimation && tick < 15) {
            this.walk(this.head, 1.2f, 0.08f, false, 0.0f, 0.0f, frame, 1.0f);
            this.swing(this.head, 1.4f, 0.1f, false, 0.0f, 0.0f, frame, 1.0f);
        }
    }

    public void m_6002_(HumanoidArm humanoidArm, PoseStack poseStack) {
        boolean isRightArm = humanoidArm == HumanoidArm.RIGHT;
        ModelPart model$part = isRightArm ? this.rightHand : this.leftHand;
        this.root.m_104299_(poseStack);
        this.upper.m_104299_(poseStack);
        if (isRightArm) {
            this.rightArm.m_104299_(poseStack);
        } else {
            this.leftArm.m_104299_(poseStack);
        }
        model$part.m_104299_(poseStack);
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        this.offsetStackPosition(poseStack, isRightArm);
    }

    private void offsetStackPosition(PoseStack translate, boolean isRightArm) {
        if (isRightArm) {
            translate.m_85837_(0.125, -0.125, 0.0);
        } else {
            translate.m_85837_(-0.125, -0.125, 0.0);
        }
    }

    private void generalShake(float frame) {
        this.walk(this.head, 1.4f, 0.04f, false, 0.0f, 0.0f, frame, 1.0f);
        this.swing(this.head, 1.6f, 0.08f, false, 0.0f, 0.0f, frame, 1.0f);
        this.walk(this.leftArm, 0.45f, 0.2f, false, 0.0f, 0.0f, frame, 1.0f);
        this.walk(this.rightArm, 0.45f, 0.2f, false, 0.0f, 0.0f, frame, 1.0f);
        this.bob(this.root, 0.4f, 1.2f, false, frame, 1.0f);
    }
}

