/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.animate.server.message;

import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.animation.EMAnimatedEntity;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class StopAnimationMessage {
    private int entityID;
    private boolean onlyStopSuperposition;

    public StopAnimationMessage() {
    }

    public StopAnimationMessage(int entityID, boolean onlyStopSuperposition) {
        this.entityID = entityID;
        this.onlyStopSuperposition = onlyStopSuperposition;
    }

    public static void serialize(StopAnimationMessage message, FriendlyByteBuf buf) {
        buf.m_130130_(message.entityID);
        buf.writeBoolean(message.onlyStopSuperposition);
    }

    public static StopAnimationMessage deserialize(FriendlyByteBuf buf) {
        StopAnimationMessage message = new StopAnimationMessage();
        message.entityID = buf.m_130242_();
        message.onlyStopSuperposition = buf.readBoolean();
        return message;
    }

    public static class Handler
    implements BiConsumer<StopAnimationMessage, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(StopAnimationMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                EMAnimatedEntity animationEntity;
                Entity entity;
                if (Minecraft.m_91087_().f_91073_ != null && (entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityID)) instanceof EMAnimatedEntity && (animationEntity = (EMAnimatedEntity)entity).getAnimations() != null) {
                    Stream<Animation> stream = Arrays.stream(animationEntity.getAnimations());
                    if (message.onlyStopSuperposition) {
                        stream.filter(Animation::isSuperposition).forEach(AnimationState::m_216973_);
                    } else {
                        stream.forEach(AnimationState::m_216973_);
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

