/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class Checkbox
extends AbstractButton {
    private static final ResourceLocation TEXTURE = new ResourceLocation("easy_npc", "textures/gui/checkbox.png");
    protected final OnChange onChange;
    private final boolean showLabel;
    private final Font font;
    private boolean selected;

    public Checkbox(int left, int top, String label, boolean selected, OnChange onChange) {
        this(left, top, (Component)TextComponent.getTextComponent(label), selected, true, onChange);
    }

    public Checkbox(int left, int top, String label, Component data, boolean selected, OnChange onChange) {
        this(left, top, (Component)TextComponent.getTextComponent(label, data), selected, true, onChange);
    }

    public Checkbox(int left, int top, String label, String data, boolean selected, OnChange onChange) {
        this(left, top, (Component)TextComponent.getTextComponent(label, data), selected, true, onChange);
    }

    public Checkbox(int left, int top, String label, boolean selected) {
        this(left, top, (Component)TextComponent.getTranslatedConfigText(label), selected, true);
    }

    public Checkbox(int left, int top, Component component, boolean selected, boolean showLabel) {
        this(left, top, component, selected, showLabel, null);
    }

    public Checkbox(int left, int top, Component component, boolean selected, boolean showLabel, OnChange onChange) {
        super(left, top, 16, 16, component);
        this.selected = selected;
        this.showLabel = showLabel;
        Minecraft minecraft = Minecraft.m_91087_();
        this.font = minecraft.f_91062_;
        this.onChange = onChange;
    }

    public void m_5691_() {
        boolean bl = this.selected = !this.selected;
        if (this.onChange != null) {
            this.onChange.onChange(this);
        }
    }

    public boolean selected() {
        return this.selected;
    }

    public void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.f_93623_) {
            if (this.m_93696_()) {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)TextComponent.getTranslatedTextRaw("narration.checkbox.usage.focused"));
            } else {
                narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)TextComponent.getTranslatedTextRaw("narration.checkbox.usage.hovered"));
            }
        }
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderButton(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderButton(GuiGraphics guiGraphics, int left, int top, float partialTicks) {
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.m_280163_(TEXTURE, this.m_252754_(), this.m_252907_(), this.f_93623_ ? (float)(this.m_198029_() ? 16 : 0) : 32.0f, this.selected ? 16.0f : 0.0f, 16, 16, 64, 64);
        if (this.showLabel) {
            Text.drawString(guiGraphics, this.font, this.m_6035_(), this.m_252754_() + 18, this.m_252907_() + (this.f_93619_ - 8) / 2);
        }
    }

    public static interface OnChange {
        public void onChange(Checkbox var1);
    }
}

