/*
 * Decompiled with CFR 0.152.
 */
package com.razz.essentialpartnermod;

import com.razz.essentialpartnermod.EssentialPartner;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class PartnerModConfig {
    public static final Path CONFIG_FOLDER = Paths.get("config", "essential-mod-partner");
    private static final Path CONFIG_FILE = CONFIG_FOLDER.resolve("config.json");
    private static final Path HIDE_BUTTONS_FILE = CONFIG_FOLDER.resolve("hide_buttons.txt");
    private boolean buttonsHidden;
    private final transient boolean buttonsHiddenByFile = Files.exists(HIDE_BUTTONS_FILE, new LinkOption[0]);

    public static PartnerModConfig load() {
        if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
            PartnerModConfig partnerModConfig;
            block9: {
                BufferedReader reader = Files.newBufferedReader(CONFIG_FILE);
                try {
                    partnerModConfig = (PartnerModConfig)EssentialPartner.GSON.fromJson((Reader)reader, PartnerModConfig.class);
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        EssentialPartner.LOGGER.error("Failed to read config", (Throwable)e);
                    }
                }
                reader.close();
            }
            return partnerModConfig;
        }
        PartnerModConfig config = new PartnerModConfig();
        config.write();
        return config;
    }

    public void write() {
        try {
            if (!Files.exists(CONFIG_FOLDER, new LinkOption[0])) {
                Files.createDirectories(CONFIG_FOLDER, new FileAttribute[0]);
            }
            Files.write(CONFIG_FILE, EssentialPartner.GSON.toJson((Object)this).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            EssentialPartner.LOGGER.info("Failed to write config", (Throwable)e);
        }
    }

    public boolean shouldHideButtons() {
        return this.buttonsHidden || this.buttonsHiddenByFile;
    }

    public void hideButtons() {
        this.buttonsHidden = true;
        this.write();
    }
}

