/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.models.bbmodel;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelLoader;
import com.razz.decocraft.models.bbmodel.BlockbenchModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryLoader;

public class BlockbenchLoader
implements IGeometryLoader<BlockbenchModel>,
ResourceManagerReloadListener {
    public static BlockbenchLoader INSTANCE = new BlockbenchLoader();
    private final Map<BlockbenchSetting, BlockbenchModel> modelCache = Maps.newHashMap();
    private ResourceManager manager = Minecraft.m_91087_().m_91098_();

    public void m_6213_(ResourceManager resourceManager) {
        this.modelCache.clear();
        this.manager = resourceManager;
    }

    public BlockbenchModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
        if (!jsonObject.has("model")) {
            throw new RuntimeException("Blockbench Loader requires a 'model' key that points to a valid .BBModel.");
        }
        String modelLocation = jsonObject.get("model").getAsString();
        float scale = jsonObject.has("scale") ? GsonHelper.m_13915_((JsonObject)jsonObject, (String)"scale") : 1.0f;
        boolean flipV = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"flip-v", (boolean)false);
        String material = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"material", (String)"UNKNOWN");
        BlockbenchSetting settings = new BlockbenchSetting(new ResourceLocation(modelLocation), scale, flipV, material);
        Optional resource = this.manager.m_213713_(settings.modelLocation);
        if (resource.isPresent()) {
            try {
                InputStreamReader lineStream = new InputStreamReader(((Resource)resource.get()).m_215507_(), Charsets.UTF_8);
                BufferedReader lineReader = new BufferedReader(lineStream);
                BBModel model = new BBModelLoader().loadModel(lineReader);
                return new BlockbenchModel(settings, model);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Could not find BBModel");
    }

    public static class BlockbenchSetting {
        public final ResourceLocation modelLocation;
        public final float scale;
        public final boolean flipV;
        public final String material;

        public BlockbenchSetting(ResourceLocation modelLocation, float scale, boolean flipV, String material) {
            this.modelLocation = modelLocation;
            this.scale = scale;
            this.flipV = flipV;
            this.material = material;
        }
    }
}

