/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.contraption.storage.item.simple;

import com.mojang.serialization.Codec;
import com.simibubi.create.AllMountedStorageTypes;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.simibubi.create.foundation.utility.CreateCodecs;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SimpleMountedStorage
extends WrapperMountedItemStorage<ItemStackHandler> {
    public static final Codec<SimpleMountedStorage> CODEC = SimpleMountedStorage.codec(SimpleMountedStorage::new);

    public SimpleMountedStorage(MountedItemStorageType<?> type, IItemHandler handler) {
        super(type, SimpleMountedStorage.copyToItemStackHandler(handler));
    }

    public SimpleMountedStorage(IItemHandler handler) {
        this((MountedItemStorageType)AllMountedStorageTypes.SIMPLE.get(), handler);
    }

    @Override
    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (be == null) {
            return;
        }
        be.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().flatMap(this::validate).ifPresent(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                handler.setStackInSlot(i, this.getStackInSlot(i));
            }
        });
    }

    protected Optional<IItemHandlerModifiable> validate(IItemHandler handler) {
        if (handler.getSlots() == this.getSlots() && handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)handler;
            return Optional.of(modifiable);
        }
        return Optional.empty();
    }

    public static <T extends SimpleMountedStorage> Codec<T> codec(Function<IItemHandler, T> factory) {
        return CreateCodecs.ITEM_STACK_HANDLER.xmap(factory, storage -> (ItemStackHandler)storage.wrapped);
    }
}

