/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xylonity.companions.common.blockentity.SoulFurnaceBlockEntity;
import dev.xylonity.companions.common.recipe.SoulFurnaceEntityRecipe;
import dev.xylonity.companions.registry.CompanionsBlocks;
import java.util.Map;
import java.util.WeakHashMap;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public final class SoulFurnaceEntityRecipeCategory
implements IRecipeCategory<SoulFurnaceEntityRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("companions", "soul_furnace_entity_interaction");
    public static final RecipeType<SoulFurnaceEntityRecipe> TYPE = new RecipeType(UID, SoulFurnaceEntityRecipe.class);
    public static final ResourceLocation SHADOW = new ResourceLocation("companions", "textures/gui/sprites.png");
    private final IDrawable icon;
    private SoulFurnaceBlockEntity cachedBlockEntity;
    private long lastUpdateTime = 0L;
    private static long GLOBAL_LAST_TIME = 0L;
    private static int GLOBAL_TICK = 0;
    private final Map<SoulFurnaceEntityRecipe, Entity> entityCache = new WeakHashMap<SoulFurnaceEntityRecipe, Entity>();

    public SoulFurnaceEntityRecipeCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CompanionsBlocks.SOUL_FURNACE.get()));
    }

    @NotNull
    public RecipeType<SoulFurnaceEntityRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.companions.soul_furnace_entity_interaction.title");
    }

    public int getHeight() {
        return 80;
    }

    public int getWidth() {
        return 160;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SoulFurnaceEntityRecipe rec, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 5).addItemStack(rec.input);
    }

    private SoulFurnaceBlockEntity getOrCreateBlockEntity() {
        if (this.cachedBlockEntity == null) {
            this.cachedBlockEntity = new SoulFurnaceBlockEntity(BlockPos.f_121853_, CompanionsBlocks.SOUL_FURNACE.get().m_49966_());
        }
        return this.cachedBlockEntity;
    }

    private Entity getOrCreateEntity(SoulFurnaceEntityRecipe rec) {
        Entity entity = this.entityCache.get(rec);
        if ((entity == null || entity.m_6095_() != rec.entityType) && Minecraft.m_91087_().f_91073_ != null) {
            entity = rec.entityType.m_20615_((Level)Minecraft.m_91087_().f_91073_);
            this.entityCache.put(rec, entity);
        }
        return entity;
    }

    private void updateAnimation() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        if (currentTime - this.lastUpdateTime >= 50L) {
            this.lastUpdateTime = currentTime;
        }
        long nowTicks = Minecraft.m_91087_().f_91073_ != null ? Minecraft.m_91087_().f_91073_.m_46467_() : currentTime / 50L;
        if (currentTime - GLOBAL_LAST_TIME >= 50L) {
            GLOBAL_LAST_TIME = currentTime;
            GLOBAL_TICK = (int)nowTicks;
        }
    }

    public void draw(@NotNull SoulFurnaceEntityRecipe recipe, @NotNull IRecipeSlotsView slots, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        GeoBlockRenderer renderer;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SHADOW);
        guiGraphics.m_280218_(SHADOW, 11, 60, 0, 41, 38, 18);
        guiGraphics.m_280218_(SHADOW, 32, 10, 56, 30, 24, 22);
        guiGraphics.m_280218_(SHADOW, 80, 48, 142, 6, 24, 12);
        guiGraphics.m_280218_(SHADOW, 9, 4, 120, 0, 19, 19);
        guiGraphics.m_280218_(SHADOW, 112, 60, 216, 5, 38, 16);
        this.updateAnimation();
        SoulFurnaceBlockEntity be = this.getOrCreateBlockEntity();
        Entity maw = this.getOrCreateEntity(recipe);
        if (maw != null) {
            maw.f_19797_ = GLOBAL_TICK;
        }
        if ((renderer = (GeoBlockRenderer)Minecraft.m_91087_().m_167982_().m_112265_((BlockEntity)be)) == null) {
            return;
        }
        PoseStack pose = guiGraphics.m_280168_();
        MultiBufferSource.BufferSource buffer = guiGraphics.m_280091_();
        pose.m_85836_();
        pose.m_252880_(30.0f, 68.0f, 10.0f);
        pose.m_85841_(24.0f, 24.0f, 24.0f);
        pose.m_252781_(Axis.f_252529_.m_252977_(-25.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(145.0f));
        pose.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        Matrix3f normalMat = pose.m_85850_().m_252943_();
        Vector3f up = new Vector3f(-1.0f, 10.0f, -1.0f);
        Vector3f front = new Vector3f(-1.0f, 3.0f, -1.0f);
        normalMat.transform(up).normalize();
        normalMat.transform(front).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up, (Vector3f)front);
        try {
            float partialTicks = 0.0f;
            renderer.m_6922_((BlockEntity)be, partialTicks, pose, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_);
        }
        catch (Exception e) {
            renderer.m_6922_((BlockEntity)be, 0.0f, pose, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_);
        }
        pose.m_85849_();
        EntityRenderer entityRenderer = null;
        if (maw != null) {
            entityRenderer = Minecraft.m_91087_().m_91290_().m_114382_(maw);
        }
        if (entityRenderer == null) {
            return;
        }
        pose.m_85836_();
        pose.m_252880_(132.0f, 65.0f, 20.0f);
        pose.m_85841_(28.0f, 28.0f, 28.0f);
        pose.m_252781_(Axis.f_252529_.m_252977_(-25.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(45.0f));
        pose.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        Matrix3f normalMat2 = pose.m_85850_().m_252943_();
        Vector3f up2 = new Vector3f(-1.0f, 10.0f, -1.0f);
        Vector3f front2 = new Vector3f(-1.0f, 3.0f, -1.0f);
        normalMat2.transform(up2).normalize();
        normalMat2.transform(front2).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up2, (Vector3f)front2);
        try {
            float partialTicks = 0.0f;
            entityRenderer.m_7392_(maw, 0.0f, partialTicks, pose, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15));
        }
        catch (Exception e) {
            entityRenderer.m_7392_(maw, 0.0f, 0.0f, pose, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15));
        }
        pose.m_85849_();
        buffer.m_109911_();
    }
}

