/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xylonity.companions.common.blockentity.RespawnTotemBlockEntity;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.projectile.RespawnTotemRingProjectile;
import dev.xylonity.companions.common.recipe.HourglassRecipe;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class RespawnTotemRecipeCategory
implements IRecipeCategory<HourglassRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("companions", "respawn_totem_interaction");
    public static final RecipeType<HourglassRecipe> TYPE = new RecipeType(UID, HourglassRecipe.class);
    public static final ResourceLocation SHADOW = new ResourceLocation("companions", "textures/gui/sprites.png");
    private RespawnTotemBlockEntity cachedBlockEntity;
    private RespawnTotemRingProjectile cachedEntity;
    private long lastUpdateTime = 0L;
    private final IDrawable icon;
    private long lastEntityAppearTime = 0L;

    public RespawnTotemRecipeCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CompanionsBlocks.RESPAWN_TOTEM.get()));
    }

    @NotNull
    public RecipeType<HourglassRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.companions.respawn_totem_interaction.title");
    }

    public int getWidth() {
        return 120;
    }

    public int getHeight() {
        return 100;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HourglassRecipe rec, @NotNull IFocusGroup focuses) {
        this.cachedEntity = null;
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 5).addItemStack(rec.input);
    }

    private RespawnTotemBlockEntity getOrCreateBlockEntity() {
        if (this.cachedBlockEntity == null) {
            this.cachedBlockEntity = new RespawnTotemBlockEntity(BlockPos.f_121853_, CompanionsBlocks.RESPAWN_TOTEM.get().m_49966_());
            this.cachedBlockEntity.setCharges(1);
        }
        return this.cachedBlockEntity;
    }

    private RespawnTotemRingProjectile getOrCreateEntity() {
        if (this.cachedEntity == null) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null) {
                this.cachedEntity = new RespawnTotemRingProjectile((EntityType<? extends BaseProjectile>)((EntityType)CompanionsEntities.RESPAWN_TOTEM_RING_PROJECTILE.get()), (Level)mc.f_91073_);
                this.cachedEntity.m_20242_(true);
            }
        }
        return this.cachedEntity;
    }

    private void updateAnimation() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        if (currentTime - this.lastEntityAppearTime >= 3900L) {
            this.lastEntityAppearTime = currentTime;
            RespawnTotemRingProjectile entity = this.getOrCreateEntity();
            if (entity != null) {
                entity.f_19797_ = 0;
            }
        }
        this.lastUpdateTime = currentTime;
        if (this.cachedEntity != null) {
            this.cachedEntity.f_19797_ = (int)(System.currentTimeMillis() / 50L);
        }
    }

    public void draw(@NotNull HourglassRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        GeoEntityRenderer entityRenderer;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SHADOW);
        guiGraphics.m_280218_(SHADOW, 21, 69, 170, 0, 42, 25);
        guiGraphics.m_280218_(SHADOW, 33, 10, 46, 3, 33, 22);
        guiGraphics.m_280218_(SHADOW, 9, 4, 120, 0, 19, 19);
        this.updateAnimation();
        RespawnTotemBlockEntity blockEntity = this.getOrCreateBlockEntity();
        RespawnTotemRingProjectile entity = this.getOrCreateEntity();
        GeoBlockRenderer blockRenderer = (GeoBlockRenderer)Minecraft.m_91087_().m_167982_().m_112265_((BlockEntity)blockEntity);
        GeoEntityRenderer geoEntityRenderer = entityRenderer = entity != null ? (GeoEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)entity) : null;
        if (blockRenderer == null) {
            return;
        }
        PoseStack pose = guiGraphics.m_280168_();
        MultiBufferSource.BufferSource buffer = guiGraphics.m_280091_();
        pose.m_85836_();
        pose.m_252880_(44.0f, 80.0f, 120.0f);
        pose.m_85841_(24.0f, 24.0f, 24.0f);
        pose.m_252781_(Axis.f_252529_.m_252977_(-25.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(145.0f));
        pose.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        Matrix3f normalMat = pose.m_85850_().m_252943_();
        Vector3f up = new Vector3f(-1.0f, 10.0f, -1.0f);
        Vector3f front = new Vector3f(-1.0f, 3.0f, -1.0f);
        normalMat.transform(up).normalize();
        normalMat.transform(front).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up, (Vector3f)front);
        try {
            float partialTicks = (float)((double)(System.currentTimeMillis() - this.lastUpdateTime) / 50.0);
            blockRenderer.m_6922_((BlockEntity)blockEntity, partialTicks, pose, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_);
        }
        catch (Exception e) {
            blockRenderer.m_6922_((BlockEntity)blockEntity, Minecraft.m_91087_().m_91296_(), pose, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_);
        }
        pose.m_85849_();
        if (entity != null) {
            pose.m_85836_();
            pose.m_252880_(60.0f, 80.0f, 100.0f);
            pose.m_85841_(5.0f, 5.0f, 5.0f);
            pose.m_252781_(Axis.f_252529_.m_252977_(-25.0f));
            pose.m_252781_(Axis.f_252436_.m_252977_(45.0f));
            pose.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            entityRenderer.m_7392_((Entity)entity, 0.0f, Minecraft.m_91087_().m_91296_(), pose, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15));
            pose.m_85849_();
        }
        buffer.m_109911_();
    }
}

