/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.xylonity.companions.registry.CompanionsRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulFurnaceRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient input;
    private final int requiredCharges;
    private final int processTime;
    @Nullable
    private final Item resultItem;
    private final int resultCount;
    @Nullable
    private final EntityType<?> resultEntity;
    @Nullable
    private final Block resultBlock;

    public SoulFurnaceRecipe(ResourceLocation id, Ingredient input, int requiredCharges, int processTime, @Nullable Item resultItem, int resultCount, @Nullable EntityType<?> resultEntity, @Nullable Block resultBlock) {
        this.id = id;
        this.input = input;
        this.requiredCharges = requiredCharges;
        this.processTime = processTime;
        this.resultItem = resultItem;
        this.resultCount = resultCount;
        this.resultEntity = resultEntity;
        this.resultBlock = resultBlock;
    }

    public Ingredient input() {
        return this.input;
    }

    public int requiredCharges() {
        return this.requiredCharges;
    }

    public int processTime() {
        return this.processTime;
    }

    @Nullable
    public Item resultItem() {
        return this.resultItem;
    }

    public int resultCount() {
        return this.resultCount;
    }

    @Nullable
    public EntityType<?> resultEntity() {
        return this.resultEntity;
    }

    @Nullable
    public Block resultBlock() {
        return this.resultBlock;
    }

    public boolean outputsItem() {
        return this.resultItem != null;
    }

    public boolean outputsEntity() {
        return this.resultEntity != null;
    }

    public boolean outputsBlock() {
        return this.resultBlock != null;
    }

    public boolean m_5818_(@NotNull Container container, @NotNull Level level) {
        return this.input.test(container.m_8020_(0));
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container container, @NotNull RegistryAccess access) {
        return this.outputsItem() ? new ItemStack((ItemLike)this.resultItem, Math.max(1, this.resultCount)) : ItemStack.f_41583_;
    }

    public boolean m_8004_(int w, int h) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess access) {
        return this.outputsItem() ? new ItemStack((ItemLike)this.resultItem, Math.max(1, this.resultCount)) : ItemStack.f_41583_;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input});
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CompanionsRecipes.SOUL_FURNACE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)CompanionsRecipes.SOUL_FURNACE_TYPE.get();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public static class Serializer
    implements RecipeSerializer<SoulFurnaceRecipe> {
        @NotNull
        public SoulFurnaceRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            ResourceLocation rl;
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            int required = GsonHelper.m_13824_((JsonObject)json, (String)"required_charges", (int)0);
            int time = GsonHelper.m_13824_((JsonObject)json, (String)"process_time", (int)200);
            Item item = null;
            int count = GsonHelper.m_13824_((JsonObject)json, (String)"result_count", (int)1);
            EntityType entity = null;
            Block block = null;
            if (json.has("result_item") && (item = (Item)BuiltInRegistries.f_257033_.m_7745_(rl = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"result_item")))) == Items.f_41852_) {
                item = null;
            }
            if (json.has("result_entity")) {
                rl = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"result_entity"));
                entity = (EntityType)BuiltInRegistries.f_256780_.m_7745_(rl);
            }
            if (json.has("result_block")) {
                rl = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"result_block"));
                block = (Block)BuiltInRegistries.f_256975_.m_7745_(rl);
            }
            if ((item != null ? 1 : 0) + (entity != null ? 1 : 0) + (block != null ? 1 : 0) != 1) {
                throw new JsonParseException("soul_furnace must define exactly one of result_item, result_entity, result_block");
            }
            return new SoulFurnaceRecipe(id, input, required, time, item, Math.max(1, count), entity, block);
        }

        @NotNull
        public SoulFurnaceRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            int required = buf.m_130242_();
            int time = buf.m_130242_();
            byte kind = buf.readByte();
            Item item = null;
            int count = 1;
            EntityType entity = null;
            Block block = null;
            if (kind == 1) {
                ResourceLocation rl = buf.m_130281_();
                item = (Item)BuiltInRegistries.f_257033_.m_7745_(rl);
                count = buf.m_130242_();
                if (item == Items.f_41852_) {
                    item = null;
                }
            } else if (kind == 2) {
                ResourceLocation rl = buf.m_130281_();
                entity = (EntityType)BuiltInRegistries.f_256780_.m_7745_(rl);
            } else if (kind == 3) {
                ResourceLocation rl = buf.m_130281_();
                block = (Block)BuiltInRegistries.f_256975_.m_7745_(rl);
            }
            return new SoulFurnaceRecipe(id, input, required, time, item, Math.max(1, count), entity, block);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull SoulFurnaceRecipe r) {
            r.input.m_43923_(buf);
            buf.m_130130_(r.requiredCharges);
            buf.m_130130_(r.processTime);
            if (r.resultItem != null) {
                buf.writeByte(1);
                ResourceLocation key = BuiltInRegistries.f_257033_.m_7981_((Object)r.resultItem);
                if (key == null) {
                    key = new ResourceLocation("minecraft", "air");
                }
                buf.m_130085_(key);
                buf.m_130130_(Math.max(1, r.resultCount));
            } else if (r.resultEntity != null) {
                buf.writeByte(2);
                ResourceLocation key = BuiltInRegistries.f_256780_.m_7981_(r.resultEntity);
                if (key == null) {
                    key = new ResourceLocation("minecraft", "pig");
                }
                buf.m_130085_(key);
            } else if (r.resultBlock != null) {
                buf.writeByte(3);
                ResourceLocation key = BuiltInRegistries.f_256975_.m_7981_((Object)r.resultBlock);
                if (key == null) {
                    key = new ResourceLocation("minecraft", "air");
                }
                buf.m_130085_(key);
            } else {
                buf.writeByte(0);
            }
        }
    }
}

