/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import dev.xylonity.knightlib.client.particle.AbstractRibbonTrailParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class ElectricArcParticle
extends AbstractRibbonTrailParticle {
    private static final ResourceLocation TEXTURE = new ResourceLocation("companions", "textures/particle/trail.png");
    private static final int TRAIL_SEGMS = 12;
    private final Vec3 start;
    private final Vec3 end;
    private final double arcY;
    private final Vec3[] noiseOffsets;
    private static final float RED_ = 0.61f;
    private static final float GREEN_ = 0.853f;
    private static final float BLUE_ = 1.0f;

    public ElectricArcParticle(ClientLevel level, Vec3 start, Vec3 end, double arcHeight, double amp) {
        super(level, start.f_82479_, start.f_82480_, start.f_82481_, 0.0, 0.0, 0.0, 1.0f, 1.0f, 1.0f);
        this.start = start;
        this.end = end;
        this.arcY = arcHeight;
        this.noiseOffsets = new Vec3[12];
        for (int i = 0; i < 12; ++i) {
            long h = level.f_46441_.m_188505_() ^ (long)i * 2654435769L;
            h ^= h >>> 33;
            h *= -49064778989728563L;
            h ^= h >>> 33;
            h *= -4265267296055464877L;
            h ^= h >>> 33;
            double ox = ((double)(h >> 42 & 0x3FFL) / 1023.0 - 0.5) * amp;
            double oy = ((double)(h >> 21 & 0x3FFL) / 1023.0 - 0.5) * amp;
            double oz = ((double)(h & 0x3FFL) / 1023.0 - 0.5) * amp;
            this.noiseOffsets[i] = new Vec3(ox, oy, oz);
        }
        this.f_107226_ = 0.0f;
        this.f_107225_ = 8;
        this.ribbonAlpha = 1.0f;
    }

    protected ResourceLocation getRibbonSprite() {
        return TEXTURE;
    }

    protected int totalSegments() {
        return Math.min(12, (this.f_107224_ + 1) * 2);
    }

    public void m_5989_() {
        super.m_5989_();
        int rem = this.f_107225_;
        int dWhite = Math.min(2, rem);
        int dFadeIn = Math.min(3, rem -= dWhite);
        int dDarken = Math.min(5, rem -= dFadeIn);
        int fadein = dWhite + dFadeIn;
        int toDarken = fadein + dDarken;
        if (this.f_107224_ < dWhite) {
            this.r = 1.0f;
            this.g = 1.0f;
            this.b = 1.0f;
        } else if (this.f_107224_ < fadein) {
            float p = (float)(this.f_107224_ - dWhite) / (float)dFadeIn;
            this.r = 1.0f - p * 0.39f;
            this.g = 1.0f - p * 0.14700001f;
            this.b = 1.0f - p * 0.0f;
        } else if (this.f_107224_ < toDarken) {
            factor = 1.0f - (float)(this.f_107224_ - fadein) / (float)dDarken * 0.4f;
            this.r = 0.61f * factor;
            this.g = 0.853f * factor;
            this.b = 1.0f * factor;
        } else {
            factor = 0.3f;
            this.r = 0.61f * factor;
            this.g = 0.853f * factor;
            this.b = 1.0f * factor;
        }
        int fade = Math.min(6, this.f_107225_);
        this.ribbonAlpha = this.f_107224_ >= this.f_107225_ - fade ? Math.max(0.0f, 1.0f - (float)(this.f_107224_ - (this.f_107225_ - fade)) / (float)fade) : 1.0f;
    }

    protected int m_6355_(float $$0) {
        return 0xF000F0;
    }

    protected Vec3 sampleTrailPoint(int idx, float tick) {
        float t = (float)idx / 10.0f;
        Vec3 base = this.start.m_165921_(this.end, (double)t).m_82520_(0.0, Math.sin(Math.PI * (double)t) * this.arcY, 0.0);
        Vec3 noise = this.noiseOffsets[idx];
        return base.m_82520_(noise.f_82479_, noise.f_82480_, noise.f_82481_);
    }

    protected float getRibbonHeight() {
        return 0.28f;
    }
}

