/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.material;

import dev.xylonity.companions.config.CompanionsConfig;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public enum ArmorMaterials implements ArmorMaterial
{
    MAGE("mage", () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_}), () -> new ArmorStats(CompanionsConfig.MAGE_SET_STATS)),
    HOLY_ROBE("holy_robe", () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_}), () -> new ArmorStats(CompanionsConfig.HOLY_ROBE_SET_STATS)),
    CRYSTALLIZED_BLOOD("crystallized_blood", () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_}), () -> new ArmorStats(CompanionsConfig.CRYSTALLIZED_BLOOD_SET_STATS));

    private final String name;
    private final Supplier<Ingredient> repairIngredient;
    private final Supplier<ArmorStats> statsSupplier;
    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;

    private ArmorMaterials(String name, Supplier<Ingredient> repairIngredient, Supplier<ArmorStats> sup) {
        this.name = name;
        this.repairIngredient = repairIngredient;
        this.statsSupplier = sup;
    }

    private ArmorStats stats() {
        return this.statsSupplier.get();
    }

    public int m_266425_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ArmorItem.Type type) {
        return HEALTH_FUNCTION_FOR_TYPE.get(type) * (int)this.stats().durabilityMultiplier;
    }

    public int m_7366_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ArmorItem.Type type) {
        return ArmorMaterials.toProtectionMap(this.stats().prot).get(type);
    }

    public int m_6646_() {
        return 20;
    }

    @NotNull
    public SoundEvent m_7344_() {
        return SoundEvents.f_11673_;
    }

    @NotNull
    public Ingredient m_6230_() {
        return this.repairIngredient.get();
    }

    @NotNull
    public String m_6082_() {
        return "companions:" + this.name;
    }

    public float m_6651_() {
        return (float)this.stats().toughness;
    }

    public float m_6649_() {
        return (float)this.stats().knockbackResistance;
    }

    private static EnumMap<ArmorItem.Type, Integer> toProtectionMap(int[] prot) {
        EnumMap<ArmorItem.Type, Integer> map = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        map.put(ArmorItem.Type.HELMET, prot[0]);
        map.put(ArmorItem.Type.CHESTPLATE, prot[1]);
        map.put(ArmorItem.Type.LEGGINGS, prot[2]);
        map.put(ArmorItem.Type.BOOTS, prot[3]);
        return map;
    }

    static {
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), m -> {
            m.put(ArmorItem.Type.BOOTS, 13);
            m.put(ArmorItem.Type.LEGGINGS, 15);
            m.put(ArmorItem.Type.CHESTPLATE, 16);
            m.put(ArmorItem.Type.HELMET, 11);
        });
    }

    private static class ArmorStats {
        final int[] prot;
        final double toughness;
        final double knockbackResistance;
        final double durabilityMultiplier;

        ArmorStats(String s) {
            String[] parts = s.trim().split("\\s*,\\s*");
            if (parts.length != 7) {
                throw new IllegalArgumentException("[Companions!] Invalid armor stats format! Expected 7 values for " + s);
            }
            this.prot = new int[]{ArmorStats.parse(parts[0]), ArmorStats.parse(parts[1]), ArmorStats.parse(parts[2]), ArmorStats.parse(parts[3])};
            this.toughness = Double.parseDouble(parts[4]);
            this.knockbackResistance = Double.parseDouble(parts[5]);
            this.durabilityMultiplier = Double.parseDouble(parts[6]);
        }

        private static int parse(String s) {
            return Integer.parseInt(s.trim());
        }
    }
}

