/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item.weapon;

import dev.xylonity.companions.common.entity.projectile.BloodTornadoProjectile;
import dev.xylonity.companions.common.item.generic.GenericGeckoAxeItem;
import dev.xylonity.companions.common.material.ItemMaterials;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BloodAxeItem
extends GenericGeckoAxeItem {
    public BloodAxeItem(Item.Properties properties, String resourceKey, ItemMaterials material, float extraDamage, float extraSpeed) {
        super(properties, resourceKey, material, extraDamage, extraSpeed);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!pLevel.f_46443_) {
            for (int i = 0; i < 4; ++i) {
                double angleRad = Math.toRadians(player.m_146908_() + (float)(i * 90));
                BloodTornadoProjectile tornado = (BloodTornadoProjectile)((EntityType)CompanionsEntities.BLOOD_TORNADO_PROJECTILE.get()).m_20615_(pLevel);
                if (tornado == null) continue;
                tornado.m_6034_(player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() * 0.4f), player.m_20189_());
                tornado.m_5602_((Entity)player);
                tornado.setAlpha((float)angleRad);
                tornado.m_6686_(-Math.sin(angleRad), 0.0, Math.cos(angleRad), 1.2525f, 0.0f);
                pLevel.m_7967_((Entity)tornado);
            }
            pLevel.m_247517_(null, player.m_20183_(), CompanionsSounds.SPELL_RELEASE_DARK_HOLE.get(), SoundSource.PLAYERS);
            player.m_36335_().m_41524_((Item)this, CompanionsConfig.CRYSTALLIZED_BLOOD_AXE_COOLDOWN);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)pLevel.m_5776_());
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.icon.companions.star").m_7220_((Component)Component.m_237115_((String)"tooltip.item.companions.key.blood_weapon").m_130940_(ChatFormatting.YELLOW)));
        pTooltipComponents.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"tooltip.item.companions.key.abilities").m_130940_(ChatFormatting.DARK_GRAY)));
        pTooltipComponents.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"tooltip.item.companions.crystallized_blood_axe").m_130940_(ChatFormatting.WHITE)));
        pTooltipComponents.add((Component)Component.m_237113_((String)"   ").m_7220_((Component)Component.m_237115_((String)"tooltip.item.companions.crystallized_blood_axe_desc_1").m_130940_(ChatFormatting.GRAY)));
        pTooltipComponents.add((Component)Component.m_237113_((String)"   ").m_7220_((Component)Component.m_237115_((String)"tooltip.item.companions.crystallized_blood_axe_desc_2").m_130940_(ChatFormatting.GRAY)));
        pTooltipComponents.add((Component)Component.m_237113_((String)"   ").m_7220_((Component)Component.m_237115_((String)"tooltip.item.companions.crystallized_blood_axe_desc_3").m_130940_(ChatFormatting.GRAY)));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

