/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class MagicRayPieceProjectile
extends BaseProjectile {
    private static final RawAnimation APPEAR = RawAnimation.begin().thenPlay("appear");
    private static final RawAnimation DISAPPEAR = RawAnimation.begin().thenPlay("disappear");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final EntityDataAccessor<Float> YAW = SynchedEntityData.m_135353_(MagicRayPieceProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> PITCH = SynchedEntityData.m_135353_(MagicRayPieceProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public MagicRayPieceProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = false;
    }

    protected boolean m_5603_(@NotNull Entity entity) {
        if (Util.areEntitiesLinked((Entity)this, entity)) {
            return false;
        }
        return super.m_5603_(entity);
    }

    @Override
    public void m_8119_() {
        List hitEntities;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && !(hitEntities = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(0.75), this::m_5603_)).isEmpty()) {
            LivingEntity hit = (LivingEntity)hitEntities.get(0);
            hit.m_6469_(this.m_269291_().m_269425_(), (float)CompanionsConfig.MAGIC_PIECE_DAMAGE);
        }
    }

    public float getYaw() {
        return ((Float)this.f_19804_.m_135370_(YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(yaw));
    }

    public float getPitch() {
        return ((Float)this.f_19804_.m_135370_(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(pitch));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PITCH, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "extraController", this::extraPredicate)});
    }

    @Override
    protected int baseLifetime() {
        return 18;
    }

    private <T extends GeoAnimatable> PlayState extraPredicate(AnimationState<T> event) {
        if (this.f_19797_ >= this.getLifetime() - 6) {
            event.getController().setAnimation(DISAPPEAR);
        } else if (this.f_19797_ <= 4) {
            event.getController().setAnimation(APPEAR);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }
}

