/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BraceProjectile
extends BaseProjectile {
    private static final double BOUNCE_DAMPING_VERTICAL = 0.6;
    private static final double BOUNCE_DAMPING_HORIZONTAL = 0.7;
    private static final int MAX_BOUNCES = 5;
    private static final double MIN_UPWARD = 0.4;
    private final List<Integer> hitEntities = new ArrayList<Integer>();
    private int entityBounces = 0;
    private int blockBounces = 0;

    public BraceProjectile(EntityType<? extends BaseProjectile> type, Level level) {
        super(type, level);
        this.f_19794_ = false;
    }

    @Override
    public void m_8119_() {
        double blockDist;
        super.m_8119_();
        if (this.f_19797_ > this.getLifetime() || this.entityBounces >= 5) {
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_7605_((Entity)this, (byte)3);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        Vec3 vel = this.m_20184_().m_82520_(0.0, -0.03, 0.0).m_82490_(0.98);
        Vec3 start = this.m_20182_();
        Vec3 end = start.m_82549_(vel);
        HitResult entityHit = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
        BlockHitResult blockHit = this.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        double entityDist = entityHit.m_6662_() == HitResult.Type.ENTITY ? entityHit.m_82450_().m_82557_(start) : Double.MAX_VALUE;
        double d = blockDist = blockHit.m_6662_() != HitResult.Type.MISS ? blockHit.m_82450_().m_82557_(start) : Double.MAX_VALUE;
        if (entityDist < blockDist) {
            this.handleEntityHit((EntityHitResult)entityHit);
        } else if (blockDist < Double.MAX_VALUE) {
            this.handleBlockHit(blockHit);
        } else {
            this.move(vel);
        }
        if (this.f_19797_ % 3 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)CompanionsParticles.EMBER.get(), this.m_20185_(), this.m_20186_() - (double)this.m_20206_() * 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.m_9236_().f_46443_ && (this.f_19797_ % 50 == 0 || this.f_19797_ == 1)) {
            float r = 0.98039216f;
            float g = (float)(203 + this.m_9236_().f_46441_.m_188503_(10)) / 255.0f;
            float b = (float)(138 + this.m_9236_().f_46441_.m_188503_(10)) / 255.0f;
            Companions.PROXY.spawnGenericRibbonTrail((Entity)this, this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), r, g, b, 0.0f, 0.35f);
        }
    }

    private void handleEntityHit(EntityHitResult hit) {
        LivingEntity target;
        Entity entity = hit.m_82443_();
        if (!(entity instanceof LivingEntity) || Util.areEntitiesLinked((Entity)(target = (LivingEntity)entity), (Entity)this) || this.hitEntities.contains(entity.m_19879_())) {
            this.move(this.m_20184_());
            return;
        }
        target.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), (float)CompanionsConfig.BRACE_PROJECTILE_DAMAGE);
        target.m_20254_(this.f_19796_.m_216339_(1, 10));
        this.hitEntities.add(target.m_19879_());
        ++this.entityBounces;
        this.m_146884_(hit.m_82450_());
        Vec3 bouncePos = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
        this.m_146884_(bouncePos);
        this.m_20256_(Vec3.f_82478_);
        if (this.entityBounces >= 5) {
            this.spawnParticles();
            this.m_146870_();
            return;
        }
        LivingEntity next = this.findNextTarget();
        if (next == null) {
            this.spawnParticles();
            this.m_146870_();
            return;
        }
        Vec3 direction = next.m_20182_().m_82520_(0.0, (double)next.m_20206_() * 0.5, 0.0).m_82546_(this.m_20182_()).m_82541_();
        if (direction.f_82480_ < 0.4) {
            direction = new Vec3(direction.f_82479_, 0.4, direction.f_82481_).m_82541_();
        }
        this.m_20256_(direction.m_82490_(0.6));
    }

    private void handleBlockHit(BlockHitResult hit) {
        Direction face = hit.m_82434_();
        Vec3 normal = new Vec3((double)face.m_122429_(), (double)face.m_122430_(), (double)face.m_122431_());
        Vec3 reflected = this.m_20184_().m_82546_(normal.m_82490_(2.0 * this.m_20184_().m_82526_(normal)));
        reflected = face.m_122434_().m_122478_() ? new Vec3(reflected.f_82479_, reflected.f_82480_ * 0.6, reflected.f_82481_) : new Vec3(reflected.f_82479_ * 0.7, reflected.f_82480_, reflected.f_82481_ * 0.7);
        ++this.blockBounces;
        if (this.blockBounces >= 5) {
            reflected = Vec3.f_82478_;
        }
        this.m_146884_(hit.m_82450_().m_82549_(normal.m_82490_(0.02)));
        this.move(reflected);
    }

    private void spawnSmokeParticles() {
        for (int i = 0; i < 6; ++i) {
            double speedX = (this.f_19796_.m_188500_() - 0.5) * 0.1;
            double speedY = (this.f_19796_.m_188500_() - 0.5) * 0.1;
            double speedZ = (this.f_19796_.m_188500_() - 0.5) * 0.1;
            this.m_9236_().m_7106_((ParticleOptions)CompanionsParticles.EMBER.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), speedX, speedY, speedZ);
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 3) {
            this.spawnSmokeParticles();
        } else {
            super.m_7822_(pId);
        }
    }

    private void spawnParticles() {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            float speed = 0.1f;
            this.m_9236_().m_7106_((ParticleOptions)CompanionsParticles.EMBER.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (this.f_19796_.m_188500_() - 0.5) * (double)speed, (this.f_19796_.m_188500_() - 0.5) * (double)speed, (this.f_19796_.m_188500_() - 0.5) * (double)speed);
        }
    }

    private LivingEntity findNextTarget() {
        return this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(10.0), e -> e.m_6084_() && !Util.areEntitiesLinked((Entity)this, (Entity)e) && !this.hitEntities.contains(e.m_19879_())).stream().min(Comparator.comparingDouble(e -> e.m_20280_((Entity)this))).orElse(null);
    }

    private void move(Vec3 vel) {
        if (this.m_20096_() && Math.abs(vel.f_82480_) < 0.001 && vel.m_165925_() < 9.0E-4) {
            vel = Vec3.f_82478_;
        }
        this.m_20256_(vel);
        this.m_6478_(MoverType.SELF, vel);
    }

    protected boolean m_5603_(@NotNull Entity e) {
        if (Util.areEntitiesLinked((Entity)this, e)) {
            return false;
        }
        if (e == this.m_19749_() || e == this) {
            return false;
        }
        if (this.hitEntities.contains(e.m_19879_())) {
            return false;
        }
        return e instanceof LivingEntity;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_6123_(@NotNull Player player) {
    }

    @Override
    protected int baseLifetime() {
        return 200;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return super.m_5654_();
    }
}

