/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsLookAtPlayerGoal;
import dev.xylonity.companions.common.entity.ai.minion.tamable.gargoyle.GargoyleHealAttackGoal;
import dev.xylonity.companions.common.entity.ai.minion.tamable.gargoyle.GargoyleSpellAttackGoal;
import dev.xylonity.companions.common.entity.ai.minion.tamable.imp.ImpBraceAttackGoal;
import dev.xylonity.companions.common.entity.ai.minion.tamable.imp.ImpFireMarkAttackGoal;
import dev.xylonity.companions.common.entity.ai.minion.tamable.minion.MinionTornadoAttackGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class MinionEntity
extends CompanionEntity {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation FLY = RawAnimation.begin().thenPlay("fly");
    private final RawAnimation SPELL = RawAnimation.begin().thenPlay("spell");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    private final RawAnimation THROW = RawAnimation.begin().thenPlay("throw");
    private final RawAnimation RING = RawAnimation.begin().thenPlay("ring");
    private final RawAnimation HEAL = RawAnimation.begin().thenPlay("idle2");
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.m_135353_(MinionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> IS_LOCKED = SynchedEntityData.m_135353_(MinionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FLYING = SynchedEntityData.m_135353_(MinionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(MinionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private ResourceKey<Level> lastDimension = null;

    public MinionEntity(EntityType<? extends CompanionEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, CompanionsConfig.MINION_MAX_LIFE).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MinionTornadoAttackGoal(this, 20, 80));
        this.f_21345_.m_25352_(1, (Goal)new ImpBraceAttackGoal(this, 20, 80));
        this.f_21345_.m_25352_(1, (Goal)new ImpFireMarkAttackGoal(this, 20, 80));
        this.f_21345_.m_25352_(1, (Goal)new GargoyleSpellAttackGoal(this, 20, 80));
        this.f_21345_.m_25352_(1, (Goal)new GargoyleHealAttackGoal(this, 20, 80));
        this.f_21345_.m_25352_(3, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.f_21345_.m_25352_(3, (Goal)new CompanionRandomStrollGoal(this, 0.43));
        this.f_21345_.m_25352_(6, (Goal)new CompanionsLookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    private void updateVariantByDimension() {
        if (this.isPhaseLocked()) {
            return;
        }
        ResourceKey currentDim = this.m_9236_().m_46472_();
        if (currentDim.equals(this.lastDimension)) {
            return;
        }
        this.lastDimension = currentDim;
        Variant newVariant = currentDim.equals((Object)Level.f_46429_) ? Variant.NETHER : (currentDim.equals((Object)Level.f_46430_) ? Variant.END : Variant.OVERWORLD);
        this.setVariant(newVariant.getName());
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && player == this.m_269323_() && player.m_21120_(hand).m_41720_() == CompanionsItems.NETHERITE_CHAINS.get() && !this.isPhaseLocked()) {
            if (!player.m_150110_().f_35937_) {
                player.m_21120_(hand).m_41774_(1);
            }
            this.tameParticles();
            this.m_216990_(CompanionsSounds.SPELL_RELEASE_MARK.get());
            this.setIsPhaseLocked(true);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && player == this.m_269323_()) {
            if (Variant.NETHER.getName().equals(this.getVariant()) && player.m_21120_(hand).m_41720_() == CompanionsBlocks.NETHER_COIN.get().m_5456_()) {
                if (!player.m_150110_().f_35937_) {
                    player.m_21120_(hand).m_41774_(1);
                }
                if (this.m_217043_().m_188501_() < 0.45f) {
                    MinionEntity.popResource(this.m_9236_(), new BlockPos(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() + 1, this.m_20183_().m_123343_()), new ItemStack(this.m_217043_().m_188499_() ? (ItemLike)CompanionsItems.BOOK_FIRE_MARK.get() : (ItemLike)CompanionsItems.BOOK_BRACE.get()));
                    this.rewardParticles();
                } else {
                    this.failureParticles();
                }
                return InteractionResult.SUCCESS;
            }
            if (Variant.END.getName().equals(this.getVariant()) && player.m_21120_(hand).m_41720_() == CompanionsBlocks.END_COIN.get().m_5456_()) {
                if (!player.m_150110_().f_35937_) {
                    player.m_21120_(hand).m_41774_(1);
                }
                if (this.m_217043_().m_188501_() < 0.55f) {
                    MinionEntity.popResource(this.m_9236_(), new BlockPos(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() + 1, this.m_20183_().m_123343_()), new ItemStack(this.m_217043_().m_188499_() ? (ItemLike)CompanionsItems.BOOK_HEAL_RING.get() : (ItemLike)CompanionsItems.BOOK_STONE_SPIKES.get()));
                    this.rewardParticles();
                } else {
                    this.failureParticles();
                }
                return InteractionResult.SUCCESS;
            }
            if (Variant.OVERWORLD.getName().equals(this.getVariant()) && player.m_21120_(hand).m_41720_() == CompanionsBlocks.COPPER_COIN.get().m_5456_()) {
                if (!player.m_150110_().f_35937_) {
                    player.m_21120_(hand).m_41774_(1);
                }
                if (this.m_217043_().m_188501_() < 0.25f) {
                    MinionEntity.popResource(this.m_9236_(), new BlockPos(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() + 1, this.m_20183_().m_123343_()), new ItemStack(this.m_217043_().m_188499_() ? (ItemLike)CompanionsItems.BOOK_ICE_SHARD.get() : (ItemLike)CompanionsItems.BOOK_ICE_TORNADO.get()));
                    this.rewardParticles();
                } else {
                    this.failureParticles();
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private static void popResource(Level pLevel, BlockPos pPos, ItemStack pStack) {
        double d0 = EntityType.f_20461_.m_20679_() / 2.0f;
        double d1 = (double)pPos.m_123341_() + 0.5;
        double d2 = (double)pPos.m_123342_() + 1.5 + Mth.m_216263_((RandomSource)pLevel.f_46441_, (double)-0.25, (double)0.25) - d0;
        double d3 = (double)pPos.m_123343_() + 0.5;
        MinionEntity.popResource(pLevel, () -> new ItemEntity(pLevel, d1, d2, d3, pStack, -0.25 + Math.random() * 0.25, -0.35 + Math.random() * (double)0.35f, -0.25 + Math.random() * 0.25), pStack);
    }

    private static void popResource(Level pLevel, Supplier<ItemEntity> pItemEntitySupplier, ItemStack pStack) {
        if (!pLevel.f_46443_ && !pStack.m_41619_()) {
            ItemEntity itementity = pItemEntitySupplier.get();
            itementity.m_32060_();
            pLevel.m_7967_((Entity)itementity);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.updateVariantByDimension();
        }
    }

    public boolean m_5825_() {
        return this.getVariant().equals(Variant.NETHER.getName());
    }

    private void rewardParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (!(level2.f_46441_.m_188501_() < 0.65f)) continue;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.1);
        }
    }

    private void failureParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (!(level2.f_46441_.m_188501_() < 0.65f)) continue;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.025);
        }
    }

    @Nullable
    protected SoundEvent m_5592_() {
        if (this.getVariant().equals(Variant.END.getName())) {
            return CompanionsSounds.END_MINION_DEATH.get();
        }
        if (this.getVariant().equals(Variant.NETHER.getName())) {
            return CompanionsSounds.NETHER_MINION_DEATH.get();
        }
        return CompanionsSounds.OVERWORLD_MINION_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        if (this.getVariant().equals(Variant.END.getName())) {
            return CompanionsSounds.END_MINION_HURT.get();
        }
        if (this.getVariant().equals(Variant.NETHER.getName())) {
            return CompanionsSounds.NETHER_MINION_HURT.get();
        }
        return CompanionsSounds.OVERWORLD_MINION_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.getVariant().equals(Variant.END.getName())) {
            return super.m_7515_();
        }
        if (this.getVariant().equals(Variant.NETHER.getName())) {
            return CompanionsSounds.NETHER_MINION_IDLE.get();
        }
        return CompanionsSounds.OVERWORLD_MINION_IDLE.get();
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
        if (this.getVariant().equals(Variant.END.getName())) {
            this.m_5496_(CompanionsSounds.END_MINION_STEP.get(), 0.5f, 1.0f);
        } else {
            super.m_7355_(pPos, pState);
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setIsPhaseLocked(pCompound.m_128471_("IsVariantLocked"));
        if (pCompound.m_128425_("Variant", 8)) {
            this.setVariant(pCompound.m_128461_("Variant"));
        } else {
            ResourceKey dim = this.m_9236_().m_46472_();
            if (dim.equals((Object)Level.f_46429_)) {
                this.setVariant(Variant.NETHER.getName());
            } else if (dim.equals((Object)Level.f_46430_)) {
                this.setVariant(Variant.END.getName());
            } else {
                this.setVariant(Variant.OVERWORLD.getName());
            }
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsVariantLocked", this.isPhaseLocked());
        pCompound.m_128359_("Variant", this.getVariant());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)Variant.OVERWORLD.getName());
        this.f_19804_.m_135372_(IS_LOCKED, (Object)false);
        this.f_19804_.m_135372_(IS_FLYING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.MINION_KEEP_CHUNK_LOADED;
    }

    public boolean isPhaseLocked() {
        return (Boolean)this.f_19804_.m_135370_(IS_LOCKED);
    }

    public void setIsPhaseLocked(boolean phase) {
        this.f_19804_.m_135381_(IS_LOCKED, (Object)phase);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(IS_FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(IS_FLYING, (Object)flying);
    }

    public String getVariant() {
        return (String)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(String variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int attacking) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)attacking);
    }

    @NotNull
    public Component m_7755_() {
        if (this.m_8077_()) {
            return super.m_7755_();
        }
        if (Variant.NETHER.getName().equals(this.getVariant())) {
            return Component.m_237115_((String)"entity.companions.imp");
        }
        if (Variant.END.getName().equals(this.getVariant())) {
            return Component.m_237115_((String)"entity.companions.gargoyle");
        }
        return Component.m_237115_((String)"entity.companions.minion");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getVariant().equals(Variant.OVERWORLD.getName())) {
            if (this.getMainAction() == 0) {
                event.getController().setAnimation(this.SIT);
            } else if (this.getAttackType() == 1) {
                event.getController().setAnimation(this.ATTACK);
            } else {
                event.getController().setAnimation(this.FLY);
            }
        } else if (this.getVariant().equals(Variant.END.getName())) {
            if (this.getMainAction() == 0) {
                event.getController().setAnimation(this.SIT);
            } else if (this.getAttackType() == 1) {
                event.getController().setAnimation(this.SPELL);
            } else if (this.getAttackType() == 2) {
                event.getController().setAnimation(this.HEAL);
            } else if (event.isMoving()) {
                event.getController().setAnimation(this.WALK);
            } else {
                event.getController().setAnimation(this.IDLE);
            }
        } else if (this.getMainAction() == 0) {
            event.getController().setAnimation(this.SIT);
        } else if (this.getAttackType() == 1) {
            event.getController().setAnimation(this.THROW);
        } else if (this.getAttackType() == 2) {
            event.getController().setAnimation(this.RING);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    private void tameParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (level2.f_46441_.m_188501_() < 0.65f) {
                level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.1);
            }
            if (!(level2.f_46441_.m_188501_() < 0.25f)) continue;
            level2.m_8767_((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.2);
        }
    }

    public static enum Variant {
        OVERWORLD("minion"),
        NETHER("imp"),
        END("gargoyle");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

