/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.teddy.goal;

import dev.xylonity.companions.common.entity.companion.TeddyEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class MutatedTeddyFollowTargetGoal
extends Goal {
    private static final double RADIUS_VARIATION = 2.5;
    private static final double Y_AMPL = 0.8;
    private static final double Y_OSCILATION = 0.25;
    private static final int MIN_DIR_TIME = 40;
    private static final int MAX_DIR_TIME = 160;
    private static final int MIN_IDLE_TIME = 5;
    private static final int MAX_IDLE_TIME = 10;
    private static final int CHARGE_COOLDOWN = 80;
    private final TeddyEntity teddy;
    private LivingEntity target;
    private double angle;
    private double time;
    private int dir;
    private State state;
    private int ticksInState;
    private int untilNextDirChange;
    private int untilNextCharge;
    private Vec3 chargeDir = Vec3.f_82478_;

    public MutatedTeddyFollowTargetGoal(TeddyEntity teddy) {
        this.teddy = teddy;
        this.dir = teddy.m_217043_().m_188499_() ? 1 : -1;
        this.untilNextDirChange = teddy.m_217043_().m_188503_(120) + 40;
        this.untilNextCharge = 80;
        this.state = State.ORBIT;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8036_() {
        if (this.teddy.getPhase() == 1) {
            return false;
        }
        if (this.teddy.m_5448_() == null) {
            return false;
        }
        this.target = this.teddy.m_5448_();
        return this.target.m_6084_();
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8037_() {
        this.teddy.m_21391_((Entity)this.target, 30.0f, 30.0f);
        ++this.ticksInState;
        this.time += 0.04;
        switch (this.state) {
            case ORBIT: {
                this.orbitTick();
                break;
            }
            case IDLE: {
                this.idleTick();
                break;
            }
            case CHARGE: {
                this.chargeTick();
            }
        }
    }

    private void orbitTick() {
        Vec3 center = new Vec3(this.target.m_20185_(), this.target.m_20186_() + (double)this.target.m_20206_() * 0.5, this.target.m_20189_());
        Vec3 relativePos = this.teddy.m_20182_().m_82546_(center);
        double currAngle = Math.atan2(relativePos.f_82481_, relativePos.f_82479_);
        if (currAngle < 0.0) {
            currAngle += Math.PI * 2;
        }
        if (this.teddy.getTeleported()) {
            this.angle = currAngle;
            this.teddy.setTeleported(false);
        } else if (Math.abs(currAngle - this.angle) > Math.PI) {
            this.angle = currAngle;
        }
        this.angle = (this.angle + 0.03225 * (double)this.dir) % (Math.PI * 2);
        double r = 4.0 + 1.25 * (1.0 + Math.sin(this.time * 0.35 * Math.PI * 2.0));
        double y = 0.8 * Math.sin(this.time * 0.25 * Math.PI * 2.0);
        Vec3 nextPos = this.teddy.m_20182_().m_165921_(center.m_82520_(r * Math.cos(this.angle), y + 0.7, r * Math.sin(this.angle)), 0.12);
        this.teddy.m_6034_(nextPos.f_82479_, nextPos.f_82480_, nextPos.f_82481_);
        this.teddy.m_20256_(Vec3.f_82478_);
        if (this.ticksInState >= this.untilNextDirChange) {
            if (this.untilNextCharge <= 0) {
                this.state = State.CHARGE;
                this.chargeDir = center.m_82546_(this.teddy.m_20182_()).m_82541_();
                this.ticksInState = 0;
            } else {
                if (this.teddy.m_217043_().m_188499_()) {
                    this.dir *= -1;
                } else {
                    this.state = State.IDLE;
                }
                this.ticksInState = 0;
                this.untilNextDirChange = this.teddy.m_217043_().m_188503_(120) + 40;
            }
        }
        --this.untilNextCharge;
    }

    private void idleTick() {
        double y = 0.4 * Math.sin(this.time * 0.25 * Math.PI * 2.0);
        this.teddy.m_6034_(this.teddy.m_20185_(), this.teddy.m_20186_() + y * 0.1, this.teddy.m_20189_());
        this.teddy.m_20256_(Vec3.f_82478_);
        if (this.ticksInState >= this.teddy.m_217043_().m_188503_(5) + 5) {
            this.state = State.ORBIT;
            this.ticksInState = 0;
        }
    }

    private void chargeTick() {
        Vec3 v = this.chargeDir.m_82490_(0.2875);
        this.teddy.m_20256_(v);
        this.teddy.m_20219_(this.target.m_20182_().m_82549_(v));
        this.teddy.setTeleported(true);
        if (this.ticksInState > 12 || this.teddy.m_20280_((Entity)this.target) < 4.0) {
            this.teddy.m_20256_(Vec3.f_82478_);
            this.state = State.ORBIT;
            this.ticksInState = 0;
            this.teddy.setTeleported(false);
            this.untilNextCharge = 80;
        }
    }

    public void m_8041_() {
        this.teddy.m_20256_(Vec3.f_82478_);
        super.m_8041_();
    }

    private static enum State {
        ORBIT,
        IDLE,
        CHARGE;

    }
}

