/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mage.goal;

import dev.xylonity.companions.common.entity.ai.mage.AbstractSoulMageAttackGoal;
import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.common.entity.projectile.MagicRayCircleProjectile;
import dev.xylonity.companions.common.entity.projectile.MagicRayPieceProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SoulMageMagicRayGoal
extends AbstractSoulMageAttackGoal {
    public SoulMageMagicRayGoal(SoulMageEntity soulMage, int minCd, int maxCd) {
        super(soulMage, minCd, maxCd, "MAGIC_RAY");
    }

    @Override
    protected void performAttack(LivingEntity target) {
        if (target != null) {
            Vec3 baseDir = target.m_20182_().m_82546_(this.soulMage.m_20182_()).m_82541_();
            double traveled = 0.0;
            for (int i = 0; i < 30; ++i) {
                Vec3 piecePos = this.soulMage.m_20299_(1.0f).m_82549_(baseDir).m_82549_(baseDir.m_82490_(traveled));
                traveled += 1.0;
                BlockPos blockPos = BlockPos.m_274446_((Position)piecePos);
                if (!this.isPassableBlock(this.soulMage.m_9236_(), blockPos)) {
                    this.spawnRayPiece(this.soulMage.m_9236_(), this.soulMage, piecePos, baseDir, i == 0);
                    break;
                }
                this.spawnRayPiece(this.soulMage.m_9236_(), this.soulMage, piecePos, baseDir, i == 0);
            }
        }
    }

    private boolean isPassableBlock(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60812_((BlockGetter)level, pos).m_83281_();
    }

    private void spawnRayPiece(Level pLevel, SoulMageEntity pPlayer, Vec3 piecePos, Vec3 lookVec, boolean isFirstPiece) {
        if (isFirstPiece) {
            MagicRayCircleProjectile circle = (MagicRayCircleProjectile)((EntityType)CompanionsEntities.MAGIC_RAY_PIECE_CIRCLE_PROJECTILE.get()).m_20615_(pLevel);
            if (circle != null) {
                circle.m_6034_(piecePos.f_82479_, piecePos.f_82480_, piecePos.f_82481_);
                circle.m_5602_((Entity)pPlayer);
                this.rotateProjectile(circle, lookVec);
                pLevel.m_7967_((Entity)circle);
            }
        } else {
            MagicRayPieceProjectile ray = (MagicRayPieceProjectile)((EntityType)CompanionsEntities.MAGIC_RAY_PIECE_PROJECTILE.get()).m_20615_(pLevel);
            if (ray != null) {
                ray.m_6034_(piecePos.f_82479_, piecePos.f_82480_, piecePos.f_82481_);
                this.rotateProjectile(ray, lookVec);
                ray.m_5602_((Entity)pPlayer);
                if (pLevel instanceof ServerLevel) {
                    ServerLevel level = (ServerLevel)pLevel;
                    TickScheduler.scheduleServer((Level)level, () -> pLevel.m_7967_((Entity)ray), (int)3);
                }
            }
        }
    }

    private void rotateProjectile(MagicRayPieceProjectile projectile, Vec3 direction) {
        projectile.setPitch((float)(-Math.atan2(direction.f_82480_, Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_)) * 57.29577951308232));
        projectile.setYaw((float)(Math.atan2(direction.f_82481_, direction.f_82479_) * 57.29577951308232) - 90.0f);
    }

    @Override
    protected boolean hasRequiredBook() {
        for (int i = 0; i < this.soulMage.inventory.m_6643_(); ++i) {
            ItemStack stack = this.soulMage.inventory.m_8020_(i);
            if (stack.m_41720_() != CompanionsItems.BOOK_MAGIC_RAY.get()) continue;
            return true;
        }
        return false;
    }
}

