/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.antlion.wild.goal;

import dev.xylonity.companions.common.entity.ai.antlion.wild.AbstractWildAntlionAttackGoal;
import dev.xylonity.companions.common.entity.hostile.WildAntlionEntity;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import java.util.Random;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class WildAntlionBaseLongAttackGoal
extends AbstractWildAntlionAttackGoal {
    private static final double HIT_PROBABILITY = 0.85;
    private static final double MISS_OFFSET_RANGE = 2.0;
    private static final double ARC_HEIGHT_MULTIPLIER = 0.1;
    private static final int PARTICLES_PER_UNIT = 4;
    private static final int TICK_DELAY_DIVISOR = 6;

    public WildAntlionBaseLongAttackGoal(WildAntlionEntity antlion, int minCd, int maxCd) {
        super(antlion, 13, minCd, maxCd);
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.antlion.setNoMovement(true);
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.antlion.setNoMovement(false);
    }

    @Override
    public boolean m_8036_() {
        LivingEntity target = this.antlion.m_5448_();
        if (target != null && this.antlion.m_20280_((Entity)target) > 625.0) {
            return false;
        }
        if (this.antlion.getState() == 0 && target != null) {
            this.antlion.cycleState();
            return false;
        }
        if (!this.antlion.isUnderground()) {
            return false;
        }
        return super.m_8036_();
    }

    @Override
    protected void performAttack(LivingEntity target) {
        this.spawnParabolicParticles(target);
    }

    @Override
    protected int attackDelay() {
        return 6;
    }

    @Override
    protected int attackType() {
        return 2;
    }

    private void spawnParabolicParticles(LivingEntity target) {
        ServerLevel serverLevel = (ServerLevel)this.antlion.m_9236_();
        BlockState blockState = serverLevel.m_8055_(this.antlion.m_20183_().m_7495_());
        if (blockState.m_60795_()) {
            return;
        }
        boolean isHit = serverLevel.f_46441_.m_188500_() <= 0.85;
        TrajectoryData trajectory = this.calculateTrajectory(target, isHit);
        int steps = Math.max(1, (int)(trajectory.distance * 4.0));
        for (int i = 0; i <= steps; ++i) {
            double progress = (double)i / (double)steps;
            double x = Mth.m_14139_((double)progress, (double)trajectory.startX, (double)trajectory.endX);
            double y = Mth.m_14139_((double)progress, (double)trajectory.startY, (double)trajectory.endY) + (1.0 + trajectory.distance * 0.1) * 4.0 * progress * (1.0 - progress);
            double z = Mth.m_14139_((double)progress, (double)trajectory.startZ, (double)trajectory.endZ);
            TickScheduler.scheduleServer((Level)serverLevel, () -> serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), x, y, z, 1, 0.0, 0.0, 0.0, 0.01), (int)(i / 6));
        }
        if (isHit) {
            TickScheduler.scheduleServer((Level)serverLevel, () -> this.antlion.m_7327_((Entity)target), (int)(steps / 6));
            if (this.antlion.m_9236_().f_46441_.m_188501_() < 0.35f) {
                TickScheduler.scheduleServer((Level)serverLevel, () -> target.m_20254_(new Random().nextInt(1, 3)), (int)(steps / 6));
            }
        }
    }

    private TrajectoryData calculateTrajectory(LivingEntity target, boolean isHit) {
        double endZ;
        double endY;
        double endX;
        double startX = this.antlion.m_20185_();
        double startY = this.antlion.m_20186_() - 0.5;
        double startZ = this.antlion.m_20189_();
        if (isHit) {
            endX = target.m_20185_();
            endY = target.m_20186_() + (double)target.m_20192_();
            endZ = target.m_20189_();
        } else {
            endX = target.m_20185_() + (this.antlion.m_9236_().f_46441_.m_188500_() - 0.5) * 2.0;
            endY = target.m_20186_();
            endZ = target.m_20189_() + (this.antlion.m_9236_().f_46441_.m_188500_() - 0.5) * 2.0;
        }
        double dX = endX - startX;
        double dY = endY - startY;
        double dZ = endZ - startZ;
        double distance = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        return new TrajectoryData(startX, startY, startZ, endX, endY, endZ, distance);
    }

    private record TrajectoryData(double startX, double startY, double startZ, double endX, double endY, double endZ, double distance) {
    }
}

