/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.antlion.tamable.goal;

import dev.xylonity.companions.common.entity.companion.AntlionEntity;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.FlyNodeEvaluator;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class AntlionAdultFollowOwnerGoal
extends Goal {
    public static final int TELEPORT_WHEN_DISTANCE_IS = CompanionsConfig.COMPANIONS_FOLLOW_OWNER_TELEPORT_DISTANCE;
    private final double minDistance;
    private final double startDistance;
    private final double maxSpeedModifier;
    private final float lerpFactor;
    private final AntlionEntity antlion;
    private final PathNavigation navigation;
    private LivingEntity owner;

    public AntlionAdultFollowOwnerGoal(AntlionEntity antlion, double maxSpeedModifier, double minDistance, double startDistance, float lerpFactor) {
        this.antlion = antlion;
        this.maxSpeedModifier = maxSpeedModifier;
        this.minDistance = minDistance;
        this.startDistance = startDistance;
        this.lerpFactor = lerpFactor;
        this.navigation = this.antlion.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.antlion.getVariant() != 2) {
            return false;
        }
        if (this.antlion.getMainAction() != 1) {
            return false;
        }
        LivingEntity poss = this.antlion.m_269323_();
        if (poss == null || !poss.m_6084_()) {
            return false;
        }
        if (this.antlion.m_20280_((Entity)poss) < this.startDistance * this.startDistance) {
            return false;
        }
        this.owner = poss;
        return true;
    }

    public boolean m_8045_() {
        if (this.owner == null) {
            return false;
        }
        if (!this.owner.m_6084_()) {
            return false;
        }
        return this.antlion.m_20280_((Entity)this.owner) > this.minDistance * this.minDistance;
    }

    public void m_8037_() {
        if (this.owner == null) {
            return;
        }
        if (this.antlion.m_20280_((Entity)this.owner) >= (double)(TELEPORT_WHEN_DISTANCE_IS * TELEPORT_WHEN_DISTANCE_IS)) {
            this.teleportToOwner();
        }
        this.antlion.m_21391_((Entity)this.owner, 30.0f, 30.0f);
        double dx = this.owner.m_20185_() - this.antlion.m_20185_();
        double dy = this.owner.m_20186_() + 2.0 - this.antlion.m_20186_();
        double dz = this.owner.m_20189_() - this.antlion.m_20189_();
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (dist <= this.minDistance) {
            Vec3 slowed = this.antlion.m_20184_().m_82490_(0.9);
            this.antlion.m_20256_(slowed);
            if (slowed.m_82556_() < 0.01) {
                this.navigation.m_26573_();
                this.antlion.m_21566_().m_6849_(this.antlion.m_20185_(), this.antlion.m_20186_(), this.antlion.m_20189_(), 0.0);
            }
            return;
        }
        double theta = dist >= this.startDistance ? 1.0 : Mth.m_14008_((double)((dist - this.minDistance) / (this.startDistance - this.minDistance)), (double)0.0, (double)1.0);
        Vec3 target = new Vec3(this.owner.m_20185_() - dx / dist * this.minDistance, this.owner.m_20186_() + 2.0 - dy / dist * this.minDistance, this.owner.m_20189_() - dz / dist * this.minDistance);
        Vec3 vel = target.m_82546_(this.antlion.m_20182_()).m_82541_().m_82490_(this.maxSpeedModifier * theta);
        Vec3 cVel = this.antlion.m_20184_();
        this.antlion.m_20256_(new Vec3(Mth.m_14139_((double)this.lerpFactor, (double)cVel.f_82479_, (double)vel.f_82479_), Mth.m_14139_((double)this.lerpFactor, (double)cVel.f_82480_, (double)vel.f_82480_), Mth.m_14139_((double)this.lerpFactor, (double)cVel.f_82481_, (double)vel.f_82481_)));
        this.antlion.f_19794_ = this.isPathBlocked(this.antlion.m_9236_(), this.antlion.m_146892_(), target);
    }

    private boolean isPathBlocked(Level level, Vec3 from, Vec3 to) {
        return level.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.antlion)).m_6662_() != HitResult.Type.MISS;
    }

    protected void teleportToOwner() {
        BlockPos pos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int x = this.randomIntInclusive(-3, 3);
            int y = this.randomIntInclusive(-1, 1);
            int z = this.randomIntInclusive(-3, 3);
            if (!this.maybeTeleportTo(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int pX, int pY, int pZ) {
        if (Math.abs((double)pX - this.owner.m_20185_()) < 2.0 && Math.abs((double)pZ - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(pX, pY, pZ))) {
            return false;
        }
        this.antlion.m_7678_((float)pX + 0.5f, pY, (float)pZ + 0.5f, this.antlion.m_146908_(), this.antlion.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pPos) {
        if (FlyNodeEvaluator.m_77604_((BlockGetter)this.antlion.m_9236_(), (BlockPos.MutableBlockPos)pPos.m_122032_()) != BlockPathTypes.WALKABLE) {
            return false;
        }
        if (this.antlion.m_9236_().m_8055_(pPos.m_7495_()).m_60734_() instanceof LeavesBlock) {
            return false;
        }
        return this.antlion.m_9236_().m_45756_((Entity)this.antlion, this.antlion.m_20191_().m_82338_(pPos.m_121996_((Vec3i)this.antlion.m_20183_())));
    }

    private int randomIntInclusive(int pMin, int pMax) {
        return this.antlion.m_217043_().m_188503_(pMax - pMin + 1) + pMin;
    }
}

